/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.dnd;

import com.owc.gui.charting.ChartConfigurationException;
import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.SeriesFormat;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.gui.PlotConfigurationTreeModel;
import com.owc.gui.charting.gui.dnd.DataTableColumnCollection;
import com.owc.gui.charting.gui.treenodes.DimensionConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.PlotConfigurationTreeNode;
import com.owc.gui.charting.gui.treenodes.RangeAxisConfigTreeNode;
import com.owc.gui.charting.gui.treenodes.ValueSourceTreeNode;
import com.rapidminer.gui.dnd.AbstractPatchedTransferHandler;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import java.awt.Component;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PlotConfigurationTreeTransferHandler
extends AbstractPatchedTransferHandler {
    private static final long serialVersionUID = 1L;
    private static final String[] OPTIONS = new String[]{I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_below_last_range_axis.option.add_value_source.label", (Object[])new Object[0]), I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_below_last_range_axis.option.create_new_axis.label", (Object[])new Object[0]), I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.plotter.configuration_dialog.cancel_menu_item.label", (Object[])new Object[0]), I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_below_last_range_axis.option.move_value_source_to_axis_end.label", (Object[])new Object[0])};
    private static final String[] VALUE_SOURCE_OPTIONS = new String[]{I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_on_value_source.option.exchange_main_column.label", (Object[])new Object[0]), I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_on_value_source.option.utility1.label", (Object[])new Object[0]), I18N.getMessage((ResourceBundle)I18N.getGUIBundle(), (String)"gui.label.input.plotter.drop_on_value_source.option.utility2.label", (Object[])new Object[0])};
    private final JTree parent;

    public PlotConfigurationTreeTransferHandler(JTree parent) {
        this.parent = parent;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public Icon getVisualRepresentation(Transferable t) {
        return null;
    }

    public Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath selectionPath = tree.getSelectionPath();
        Object lastPathComponent = selectionPath.getLastPathComponent();
        DefaultMutableTreeNode t = null;
        if (lastPathComponent instanceof ValueSourceTreeNode) {
            t = (ValueSourceTreeNode)lastPathComponent;
        } else if (lastPathComponent instanceof RangeAxisConfigTreeNode) {
            t = (RangeAxisConfigTreeNode)lastPathComponent;
        }
        return t;
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean moveSupported;
        boolean copySupported;
        if (!support.isDrop()) {
            this.updateDropDeniedTooltip((JComponent)support.getComponent(), null);
            return false;
        }
        if (!this.doesSupportFlavor(support)) {
            this.updateDropDeniedTooltip((JComponent)support.getComponent(), null);
            return false;
        }
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        TreePath path = dropLocation.getPath();
        if (path == null) {
            this.updateDropDeniedTooltip((JComponent)support.getComponent(), null);
            return false;
        }
        Object lastPathComponent = path.getLastPathComponent();
        int childIndex = dropLocation.getChildIndex();
        Transferable transferable = support.getTransferable();
        String actionDescription = this.isDropOnTreeComponentPossible(support.getComponent(), (TreeNode)lastPathComponent, transferable, childIndex);
        if (actionDescription == null) {
            return false;
        }
        boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
        if (copySupported) {
            support.setDropAction(1);
            this.updateDropDeniedTooltip((JComponent)support.getComponent(), actionDescription);
            return true;
        }
        boolean bl2 = moveSupported = (2 & support.getSourceDropActions()) == 2;
        if (moveSupported) {
            support.setDropAction(2);
            this.updateDropDeniedTooltip((JComponent)support.getComponent(), actionDescription);
            return true;
        }
        this.updateDropDeniedTooltip((JComponent)support.getComponent(), null);
        return false;
    }

    public boolean doesSupportFlavor(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(ValueSourceTreeNode.VALUE_SOURCE_FLAVOR) || support.isDataFlavorSupported(RangeAxisConfigTreeNode.RANGE_AXIS_CONFIG_FLAVOR) || support.isDataFlavorSupported(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            if (!this.canImport(support)) {
                return false;
            }
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            TreePath path = dropLocation.getPath();
            int childIndex = dropLocation.getChildIndex();
            support.setShowDropLocation(true);
            if (support.isDataFlavorSupported(RangeAxisConfigTreeNode.RANGE_AXIS_CONFIG_FLAVOR)) {
                this.rangeAxisConfigDrop(support, path, childIndex);
            } else if (support.isDataFlavorSupported(ValueSourceTreeNode.VALUE_SOURCE_FLAVOR)) {
                ValueSourceTreeNode valueSourceTreeNode = (ValueSourceTreeNode)support.getTransferable().getTransferData(ValueSourceTreeNode.VALUE_SOURCE_FLAVOR);
                this.valueSourceDrop(valueSourceTreeNode, path, childIndex, false);
            } else if (support.isDataFlavorSupported(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR)) {
                this.dataTableColumnDrop(support, path, childIndex);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String isDropOnTreeComponentPossible(Component container, TreeNode treeNode, Transferable transferable, int childIndex) {
        try {
            if (transferable.isDataFlavorSupported(ValueSourceTreeNode.VALUE_SOURCE_FLAVOR)) {
                return this.canImportValueSource(container, treeNode, transferable, childIndex);
            }
            if (transferable.isDataFlavorSupported(RangeAxisConfigTreeNode.RANGE_AXIS_CONFIG_FLAVOR)) {
                return this.canImportRangeAxis(container, treeNode, childIndex, container);
            }
            if (transferable.isDataFlavorSupported(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR)) {
                return this.canImportDataTableColumnCollection(container, treeNode, transferable, childIndex);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String canImportDataTableColumnCollection(Component container, TreeNode treeNode, Transferable transferable, int childIndex) {
        DataTableColumnCollection collection;
        String importAction = I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.create_or_add", (Object[])new Object[0]);
        try {
            collection = (DataTableColumnCollection)transferable.getTransferData(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        int size = collection.getDataTableColumns().size();
        if (size == 0) {
            this.updateToolTip(container, I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.error", (Object[])new Object[0]));
            return null;
        }
        if (treeNode instanceof RangeAxisConfigTreeNode) {
            if (childIndex == -1 || childIndex < treeNode.getChildCount()) {
                return I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.add_to_axis", (Object[])new Object[0]);
            }
            return importAction;
        }
        if (treeNode instanceof PlotConfigurationTreeNode) {
            if (childIndex > -1 && childIndex < PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS) {
                this.updateToolTip(container, I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.cant_drop_between_dims", (Object[])new Object[0]));
                return null;
            }
            if (childIndex == PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS) {
                return I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.create_after_dims", (Object[])new Object[0]);
            }
            if (childIndex == -1) {
                return I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.create_at_end", (Object[])new Object[0]);
            }
            return importAction;
        }
        if (size == 1) {
            if (treeNode instanceof DimensionConfigTreeNode) {
                importAction = I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.set_dim_column", (Object[])new Object[0]);
            } else if (treeNode instanceof ValueSourceTreeNode) {
                importAction = I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.drop_on_data_config", (Object[])new Object[0]);
            }
            return importAction;
        }
        this.updateToolTip(container, I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.drop_collection_not_possible", (Object[])new Object[0]));
        return null;
    }

    private String canImportRangeAxis(Component container, TreeNode treeNode, int childIndex, Component container2) {
        String importAction = I18N.getGUILabel((String)"plotter.drag_and_drop.axis_drop.move_axis", (Object[])new Object[0]);
        if (!(treeNode instanceof PlotConfigurationTreeNode)) {
            this.updateToolTip(container, I18N.getGUILabel((String)"plotter.drag_and_drop.axis_drop.cant_drop_axis_config", (Object[])new Object[0]));
            return null;
        }
        if (childIndex > -1 && childIndex < PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS) {
            this.updateToolTip(container, I18N.getGUILabel((String)"plotter.drag_and_drop.axis_drop.only_below_dims", (Object[])new Object[0]));
            return null;
        }
        if (childIndex == -1) {
            return I18N.getGUILabel((String)"plotter.drag_and_drop.axis_drop.move_to_end", (Object[])new Object[0]);
        }
        return importAction;
    }

    private String canImportValueSource(Component comp, TreeNode treeNode, Transferable transferable, int childIndex) throws UnsupportedFlavorException, IOException {
        String importAction = null;
        if (treeNode instanceof RangeAxisConfigTreeNode) {
            importAction = childIndex == -1 ? I18N.getGUILabel((String)"plotter.drag_and_drop.source_drop.move_to_axis_end", (Object[])new Object[0]) : I18N.getGUILabel((String)"plotter.drag_and_drop.source_drop.move_or_change_position", (Object[])new Object[0]);
        } else if (treeNode instanceof PlotConfigurationTreeNode) {
            if (childIndex > -1 && childIndex < PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS) {
                this.updateToolTip(comp, I18N.getGUILabel((String)"plotter.drag_and_drop.source_drop.only_below_dims", (Object[])new Object[0]));
                return null;
            }
            importAction = childIndex == -1 ? I18N.getGUILabel((String)"plotter.drag_and_drop.column_drop.create_at_end", (Object[])new Object[0]) : I18N.getGUILabel((String)"plotter.drag_and_drop.source_drop.create_new_or_add", (Object[])new Object[0]);
        } else {
            this.updateToolTip(comp, I18N.getGUILabel((String)"plotter.drag_and_drop.source_drop.cant_drop", (Object[])new Object[0]));
            return null;
        }
        return importAction;
    }

    private void updateToolTip(Component comp, String reason) {
        if (comp instanceof JComponent) {
            JComponent jComp = (JComponent)comp;
            this.updateDropDeniedTooltip(jComp, reason);
        }
    }

    private void valueSourceDrop(ValueSourceTreeNode valueSourceTreeNode, TreePath path, int childIndex, boolean importDataTableColumn) throws UnsupportedFlavorException, IOException, ChartConfigurationException {
        ValueSource valueSource = valueSourceTreeNode.getUserObject();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof RangeAxisConfigTreeNode) {
            this.valueSourceDropOnRangeAxisConfig(valueSourceTreeNode, childIndex, valueSource, lastPathComponent);
        } else {
            this.valueSourceDropOnPlotConfiguration(valueSourceTreeNode, childIndex, valueSource, lastPathComponent, importDataTableColumn);
        }
    }

    private void valueSourceDropOnPlotConfiguration(ValueSourceTreeNode valueSourceTreeNode, int childIndex, ValueSource valueSource, Object lastPathComponent, boolean importedDataTableColumn) {
        PlotConfigurationTreeNode plotConfigurationTreeNode = (PlotConfigurationTreeNode)lastPathComponent;
        PlotConfiguration plotConfiguration = plotConfigurationTreeNode.getUserObject();
        int index = childIndex - PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS;
        if (index >= 0) {
            this.valueSourceDropOnPlotConfigBelowDimensionConfigs(valueSourceTreeNode, childIndex, valueSource, plotConfigurationTreeNode, plotConfiguration, index, importedDataTableColumn);
        } else {
            RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)valueSourceTreeNode.getParent();
            boolean process = plotConfiguration.isProcessingEvents();
            plotConfiguration.setProcessEvents(false);
            if (parent != null) {
                RangeAxisConfig oldRangeAxis = parent.getUserObject();
                oldRangeAxis.removeValueSource(valueSource);
            }
            RangeAxisConfig newRangeAxis = new RangeAxisConfig(null, plotConfiguration);
            SeriesFormat newSeriesFormat = null;
            if (importedDataTableColumn) {
                newSeriesFormat = plotConfiguration.getAutomaticSeriesFormatForNextValueSource(newRangeAxis);
            }
            newRangeAxis.addValueSource(valueSource, newSeriesFormat);
            plotConfiguration.addRangeAxisConfig(newRangeAxis);
            plotConfiguration.setProcessEvents(process);
        }
    }

    private void valueSourceDropOnPlotConfigBelowDimensionConfigs(ValueSourceTreeNode valueSourceTreeNode, int childIndex, ValueSource valueSource, PlotConfigurationTreeNode plotConfigurationTreeNode, PlotConfiguration plotConfiguration, int index, boolean importedDataTableColumn) {
        if (index > 0) {
            this.valueSourceDropOnPlotConfigBelowLastRangeAxis(valueSourceTreeNode, childIndex, valueSource, plotConfigurationTreeNode, plotConfiguration, index, importedDataTableColumn);
        } else {
            RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)valueSourceTreeNode.getParent();
            boolean process = plotConfiguration.isProcessingEvents();
            plotConfiguration.setProcessEvents(false);
            if (parent != null) {
                RangeAxisConfig oldRangeAxis = parent.getUserObject();
                oldRangeAxis.removeValueSource(valueSource);
            }
            RangeAxisConfig newRangeAxis = new RangeAxisConfig(null, plotConfiguration);
            SeriesFormat newSeriesFormat = null;
            if (importedDataTableColumn) {
                newSeriesFormat = plotConfiguration.getAutomaticSeriesFormatForNextValueSource(newRangeAxis);
            }
            newRangeAxis.addValueSource(valueSource, newSeriesFormat);
            plotConfiguration.addRangeAxisConfig(index, newRangeAxis);
            plotConfiguration.setProcessEvents(process);
        }
    }

    private void valueSourceDropOnPlotConfigBelowLastRangeAxis(final ValueSourceTreeNode valueSourceTreeNode, int childIndex, final ValueSource valueSource, PlotConfigurationTreeNode plotConfigurationTreeNode, final PlotConfiguration plotConfiguration, final int index, final boolean importedDataTableColumn) {
        JPopupMenu rangeAxisPopupMenu = new JPopupMenu();
        final RangeAxisConfig rangeAxis = (RangeAxisConfig)((DefaultMutableTreeNode)plotConfigurationTreeNode.getChildAt(childIndex - 1)).getUserObject();
        String menuItemText = OPTIONS[0];
        if (!importedDataTableColumn) {
            menuItemText = OPTIONS[3];
        }
        JMenuItem menuItem = new JMenuItem(menuItemText);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)valueSourceTreeNode.getParent();
                boolean process = plotConfiguration.isProcessingEvents();
                plotConfiguration.setProcessEvents(false);
                if (parent != null) {
                    RangeAxisConfig oldRangeAxis = parent.getUserObject();
                    oldRangeAxis.removeValueSource(valueSource);
                }
                SeriesFormat newSeriesFormat = null;
                if (importedDataTableColumn) {
                    newSeriesFormat = plotConfiguration.getAutomaticSeriesFormatForNextValueSource(rangeAxis);
                }
                rangeAxis.addValueSource(valueSource, newSeriesFormat);
                plotConfiguration.setProcessEvents(process);
            }
        });
        rangeAxisPopupMenu.add(menuItem);
        menuItem = new JMenuItem(OPTIONS[1]);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)valueSourceTreeNode.getParent();
                boolean process = plotConfiguration.isProcessingEvents();
                plotConfiguration.setProcessEvents(false);
                if (parent != null) {
                    RangeAxisConfig oldRangeAxis = parent.getUserObject();
                    oldRangeAxis.removeValueSource(valueSource);
                }
                RangeAxisConfig newRangeAxis = new RangeAxisConfig(null, plotConfiguration);
                plotConfiguration.addRangeAxisConfig(index, newRangeAxis);
                SeriesFormat newSeriesFormat = null;
                if (importedDataTableColumn) {
                    newSeriesFormat = plotConfiguration.getAutomaticSeriesFormatForNextValueSource(newRangeAxis);
                }
                newRangeAxis.addValueSource(valueSource, newSeriesFormat);
                plotConfiguration.setProcessEvents(process);
            }
        });
        rangeAxisPopupMenu.add(menuItem);
        rangeAxisPopupMenu.addSeparator();
        menuItem = new JMenuItem(OPTIONS[2]);
        Font font = menuItem.getFont();
        menuItem.setFont(new Font(font.getFamily(), 2, font.getSize()));
        rangeAxisPopupMenu.add(menuItem);
        PointerInfo mouseInfo = MouseInfo.getPointerInfo();
        Point point = mouseInfo.getLocation();
        SwingUtilities.convertPointFromScreen(point, this.parent);
        rangeAxisPopupMenu.show(this.parent, (int)point.getX(), (int)point.getY());
    }

    private void valueSourceDropOnRangeAxisConfig(ValueSourceTreeNode valueSourceTreeNode, int childIndex, ValueSource valueSource, Object lastPathComponent) {
        RangeAxisConfigTreeNode rangeAxisTreeNode = (RangeAxisConfigTreeNode)lastPathComponent;
        RangeAxisConfig rangeAxis = rangeAxisTreeNode.getUserObject();
        PlotConfiguration plotConfig = (PlotConfiguration)((DefaultMutableTreeNode)rangeAxisTreeNode.getParent()).getUserObject();
        RangeAxisConfigTreeNode parent = (RangeAxisConfigTreeNode)valueSourceTreeNode.getParent();
        if (parent != lastPathComponent) {
            RangeAxisConfig oldRangeAxis = parent.getUserObject();
            boolean process = plotConfig.isProcessingEvents();
            plotConfig.setProcessEvents(false);
            oldRangeAxis.removeValueSource(valueSource);
            if (childIndex < 0) {
                rangeAxis.addValueSource(valueSource, null);
            } else {
                rangeAxis.addValueSource(childIndex, valueSource, null);
            }
            plotConfig.setProcessEvents(process);
        } else if (childIndex < 0) {
            rangeAxis.changeIndex(rangeAxis.getSize() - 1, valueSource);
        } else {
            rangeAxis.changeIndex(childIndex, valueSource);
        }
    }

    private void rangeAxisConfigDrop(TransferHandler.TransferSupport support, TreePath path, int childIndex) throws UnsupportedFlavorException, IOException {
        RangeAxisConfigTreeNode rangeAxisConfigTreeNode = (RangeAxisConfigTreeNode)support.getTransferable().getTransferData(RangeAxisConfigTreeNode.RANGE_AXIS_CONFIG_FLAVOR);
        RangeAxisConfig rangeAxis = rangeAxisConfigTreeNode.getUserObject();
        PlotConfigurationTreeNode root = (PlotConfigurationTreeNode)rangeAxisConfigTreeNode.getParent();
        PlotConfiguration plotConfig = root.getUserObject();
        int maxIndex = plotConfig.getRangeAxisCount() - 1;
        int newIndex = childIndex - PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS;
        if (childIndex < 0 || newIndex > maxIndex) {
            plotConfig.changeIndex(maxIndex, rangeAxis);
        } else {
            plotConfig.changeIndex(newIndex, rangeAxis);
        }
    }

    private void dataTableColumnDrop(TransferHandler.TransferSupport support, TreePath path, int childIndex) throws ChartConfigurationException, UnsupportedFlavorException, IOException {
        Transferable transferable = support.getTransferable();
        LinkedList<DataTableColumn> dataTableColumnList = new LinkedList<DataTableColumn>();
        DataTableColumnCollection dataTableColumCollection = (DataTableColumnCollection)transferable.getTransferData(DataTableColumnCollection.DATATABLE_COLUMN_COLLECTION_FLAVOR);
        dataTableColumnList.addAll(dataTableColumCollection.getDataTableColumns());
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof PlotConfigurationTreeNode) {
            PlotConfigurationTreeNode plotConfigurationTreeNode = (PlotConfigurationTreeNode)lastPathComponent;
            PlotConfiguration plotConfiguration = plotConfigurationTreeNode.getUserObject();
            List<RangeAxisConfig> rangeAxisConfigs = plotConfiguration.getRangeAxisConfigs();
            int size = rangeAxisConfigs.size();
            boolean grouping = false;
            if (size > 0) {
                grouping = plotConfiguration.isGroupingRequiredForNewValueSource(rangeAxisConfigs.get(size - 1));
            }
            LinkedList<ValueSource> valueSources = new LinkedList<ValueSource>();
            for (DataTableColumn dtc : dataTableColumnList) {
                ValueSource newValueSource = new ValueSource(plotConfiguration, dtc, AbstractAggregationFunction.AggregationFunctionType.average, grouping);
                valueSources.add(newValueSource);
            }
            if (dataTableColumnList.size() == 1) {
                this.valueSourceDrop(new ValueSourceTreeNode((ValueSource)valueSources.get(0)), path, childIndex, true);
            } else {
                this.multipleDataTableColumnsDropOnPlotConfigTreeNode(valueSources, path, childIndex);
            }
        } else if (lastPathComponent instanceof RangeAxisConfigTreeNode) {
            RangeAxisConfigTreeNode rangeAxisConfigTreeNode = (RangeAxisConfigTreeNode)lastPathComponent;
            PlotConfiguration plotConfiguration = ((PlotConfigurationTreeNode)((RangeAxisConfigTreeNode)lastPathComponent).getParent()).getUserObject();
            RangeAxisConfig rangeAxis = rangeAxisConfigTreeNode.getUserObject();
            boolean grouped = plotConfiguration.isGroupingRequiredForNewValueSource(rangeAxis);
            ValueSource referenceValueSource = null;
            if (!rangeAxis.getValueSources().isEmpty()) {
                referenceValueSource = rangeAxis.getValueSources().get(rangeAxis.getValueSources().size() - 1);
            }
            AbstractAggregationFunction.AggregationFunctionType newAggregationFunctionType = null;
            if (referenceValueSource != null) {
                newAggregationFunctionType = referenceValueSource.getAggregationFunctionType(ValueSource.SeriesUsageType.MAIN_SERIES);
            } else if (referenceValueSource == null && grouped) {
                newAggregationFunctionType = AbstractAggregationFunction.AggregationFunctionType.count;
            }
            boolean process = plotConfiguration.isProcessingEvents();
            plotConfiguration.setProcessEvents(false);
            if (childIndex >= 0) {
                for (int i = dataTableColumnList.size() - 1; i >= 0; --i) {
                    DataTableColumn dtc = (DataTableColumn)dataTableColumnList.get(i);
                    ValueSource newValueSource = new ValueSource(plotConfiguration, dtc, newAggregationFunctionType, grouped);
                    rangeAxis.addValueSource(childIndex, newValueSource, plotConfiguration.getAutomaticSeriesFormatForNextValueSource(rangeAxis));
                }
            } else {
                for (DataTableColumn dtc : dataTableColumnList) {
                    ValueSource newValueSource = new ValueSource(plotConfiguration, dtc, newAggregationFunctionType, grouped);
                    rangeAxis.addValueSource(newValueSource, plotConfiguration.getAutomaticSeriesFormatForNextValueSource(rangeAxis));
                }
            }
            plotConfiguration.setProcessEvents(process);
        } else if (lastPathComponent instanceof DimensionConfigTreeNode) {
            DataTableColumn dataTableColumn = (DataTableColumn)dataTableColumnList.get(0);
            DimensionConfigTreeNode dimensionConfigTreeNode = (DimensionConfigTreeNode)lastPathComponent;
            DimensionConfig.PlotDimension dimension = dimensionConfigTreeNode.getDimension();
            JTree dropTarget = (JTree)support.getComponent();
            PlotConfigurationTreeNode root = (PlotConfigurationTreeNode)dropTarget.getModel().getRoot();
            PlotConfiguration plotConfig = root.getUserObject();
            boolean process = plotConfig.isProcessingEvents();
            plotConfig.setProcessEvents(false);
            if (dimension == DimensionConfig.PlotDimension.DOMAIN) {
                DomainConfigManager domainConfigMngr = (DomainConfigManager)dimensionConfigTreeNode.getUserObject();
                domainConfigMngr.setDataTableColumn(dataTableColumn);
            } else {
                DimensionConfig dimensionConfig = dimensionConfigTreeNode.getUserObject();
                DataTableColumn.ValueType valueType = dataTableColumn.getValueType();
                if (dimensionConfig != null) {
                    if (dimensionConfig.isGrouping() && valueType != dimensionConfig.getDataTableColumn().getValueType()) {
                        switch (valueType) {
                            case NOMINAL: {
                                dimensionConfig.setGrouping(ValueGrouping.ValueGroupingFactory.getValueGrouping(ValueGrouping.GroupingType.DISTINCT_VALUES, dataTableColumn, true, dimensionConfig.getDateFormat()));
                                break;
                            }
                            case DATE_TIME: 
                            case NUMERICAL: {
                                dimensionConfig.setGrouping(ValueGrouping.ValueGroupingFactory.getValueGrouping(ValueGrouping.GroupingType.EQUIDISTANT_FIXED_BIN_COUNT, dataTableColumn, true, dimensionConfig.getDateFormat()));
                                break;
                            }
                        }
                    }
                    dimensionConfig.setDataTableColumn(dataTableColumn);
                } else {
                    DefaultDimensionConfig newDimensionConfig = new DefaultDimensionConfig(plotConfig, dataTableColumn, dimension);
                    boolean grouped = plotConfig.getDomainConfigManager().isGrouping();
                    if (grouped) {
                        switch (valueType) {
                            case NOMINAL: {
                                newDimensionConfig.setGrouping(ValueGrouping.ValueGroupingFactory.getValueGrouping(ValueGrouping.GroupingType.DISTINCT_VALUES, dataTableColumn, true, newDimensionConfig.getDateFormat()));
                                break;
                            }
                            case DATE_TIME: 
                            case NUMERICAL: {
                                newDimensionConfig.setGrouping(ValueGrouping.ValueGroupingFactory.getValueGrouping(ValueGrouping.GroupingType.EQUIDISTANT_FIXED_BIN_COUNT, dataTableColumn, true, newDimensionConfig.getDateFormat()));
                                break;
                            }
                        }
                    }
                    plotConfig.setDimensionConfig(dimension, newDimensionConfig);
                }
            }
            plotConfig.setProcessEvents(process);
        } else if (lastPathComponent instanceof ValueSourceTreeNode) {
            final DataTableColumn dataTableColumn = (DataTableColumn)dataTableColumnList.get(0);
            ValueSourceTreeNode valueSourceNode = (ValueSourceTreeNode)lastPathComponent;
            final ValueSource valueSource = valueSourceNode.getUserObject();
            ActionListener valueSourceExchangeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (valueSource instanceof ValueSource) {
                        ValueSource source = valueSource;
                        try {
                            source.setDataTableColumn(ValueSource.SeriesUsageType.MAIN_SERIES, dataTableColumn);
                        }
                        catch (ChartConfigurationException e1) {
                            e1.printStackTrace();
                            SwingTools.showVerySimpleErrorMessage((String)"plotting.general_error", (Object[])new Object[0]);
                        }
                    }
                }
            };
            ActionListener valueSourceUtility1Action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (valueSource instanceof ValueSource) {
                        ValueSource source = valueSource;
                        try {
                            source.setDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_1, dataTableColumn);
                        }
                        catch (ChartConfigurationException e1) {
                            e1.printStackTrace();
                            SwingTools.showVerySimpleErrorMessage((String)"plotting.general_error", (Object[])new Object[0]);
                        }
                    }
                }
            };
            ActionListener valueSourceUtility2Action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (valueSource instanceof ValueSource) {
                        ValueSource source = valueSource;
                        try {
                            source.setDataTableColumn(ValueSource.SeriesUsageType.INDICATOR_2, dataTableColumn);
                        }
                        catch (ChartConfigurationException e1) {
                            e1.printStackTrace();
                            SwingTools.showVerySimpleErrorMessage((String)"plotting.general_error", (Object[])new Object[0]);
                        }
                    }
                }
            };
            JPopupMenu valueSourcePopupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(VALUE_SOURCE_OPTIONS[0]);
            menuItem.addActionListener(valueSourceExchangeAction);
            valueSourcePopupMenu.add(menuItem);
            menuItem = new JMenuItem(VALUE_SOURCE_OPTIONS[1]);
            menuItem.addActionListener(valueSourceUtility1Action);
            valueSourcePopupMenu.add(menuItem);
            menuItem = new JMenuItem(VALUE_SOURCE_OPTIONS[2]);
            menuItem.addActionListener(valueSourceUtility2Action);
            valueSourcePopupMenu.add(menuItem);
            valueSourcePopupMenu.addSeparator();
            menuItem = new JMenuItem(OPTIONS[2]);
            Font font = menuItem.getFont();
            menuItem.setFont(new Font(font.getFamily(), 2, font.getSize()));
            valueSourcePopupMenu.add(menuItem);
            PointerInfo mouseInfo = MouseInfo.getPointerInfo();
            Point point = mouseInfo.getLocation();
            SwingUtilities.convertPointFromScreen(point, this.parent);
            valueSourcePopupMenu.show(this.parent, (int)point.getX(), (int)point.getY());
        }
    }

    private void multipleDataTableColumnsDropOnPlotConfigTreeNode(final List<ValueSource> valueSources, TreePath path, int childIndex) {
        Object lastPathComponent = path.getLastPathComponent();
        PlotConfigurationTreeNode plotConfigurationTreeNode = (PlotConfigurationTreeNode)lastPathComponent;
        final PlotConfiguration plotConfiguration = plotConfigurationTreeNode.getUserObject();
        int index = childIndex - PlotConfigurationTreeModel.NUMBER_OF_PERMANENT_DIMENSIONS;
        if (index > 0) {
            JPopupMenu rangeAxisPopupMenu = new JPopupMenu();
            final RangeAxisConfig rangeAxis = (RangeAxisConfig)((DefaultMutableTreeNode)plotConfigurationTreeNode.getChildAt(childIndex - 1)).getUserObject();
            JMenuItem menuItem = new JMenuItem(OPTIONS[0]);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean tmp_processing = plotConfiguration.isProcessingEvents();
                    plotConfiguration.setProcessEvents(false);
                    for (ValueSource valueSource : valueSources) {
                        rangeAxis.addValueSource(valueSource, plotConfiguration.getAutomaticSeriesFormatForNextValueSource(rangeAxis));
                    }
                    plotConfiguration.setProcessEvents(tmp_processing);
                }
            });
            rangeAxisPopupMenu.add(menuItem);
            menuItem = new JMenuItem(OPTIONS[1]);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RangeAxisConfig newRangeAxis = new RangeAxisConfig(null, plotConfiguration);
                    boolean process = plotConfiguration.isProcessingEvents();
                    plotConfiguration.setProcessEvents(false);
                    plotConfiguration.addRangeAxisConfig(newRangeAxis);
                    for (ValueSource valueSource : valueSources) {
                        newRangeAxis.addValueSource(valueSource, plotConfiguration.getAutomaticSeriesFormatForNextValueSource(rangeAxis));
                    }
                    plotConfiguration.setProcessEvents(process);
                }
            });
            rangeAxisPopupMenu.add(menuItem);
            rangeAxisPopupMenu.addSeparator();
            menuItem = new JMenuItem(OPTIONS[2]);
            Font font = menuItem.getFont();
            menuItem.setFont(new Font(font.getFamily(), 2, font.getSize()));
            rangeAxisPopupMenu.add(menuItem);
            PointerInfo mouseInfo = MouseInfo.getPointerInfo();
            Point point = mouseInfo.getLocation();
            SwingUtilities.convertPointFromScreen(point, this.parent);
            rangeAxisPopupMenu.show(this.parent, (int)point.getX(), (int)point.getY());
        } else {
            RangeAxisConfig newRangeAxis = new RangeAxisConfig(null, plotConfiguration);
            boolean tmp_processing = plotConfiguration.isProcessingEvents();
            plotConfiguration.setProcessEvents(false);
            plotConfiguration.addRangeAxisConfig(newRangeAxis);
            for (ValueSource valueSource : valueSources) {
                newRangeAxis.addValueSource(valueSource, plotConfiguration.getAutomaticSeriesFormatForNextValueSource(newRangeAxis));
            }
            plotConfiguration.setProcessEvents(tmp_processing);
        }
    }
}

