/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.groupingpanel;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.EqualDataFractionGrouping;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.groupingpanel.AbstractGroupingCardPanel;
import com.rapidminer.gui.tools.ResourceLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EqualDataFractionCardPanel
extends AbstractGroupingCardPanel {
    private static final long serialVersionUID = 1L;
    protected JSpinner binCountSpinner;

    public EqualDataFractionCardPanel(PlotInstance plotInstance, DimensionConfig.PlotDimension dimension) {
        super(plotInstance, dimension);
        this.adaptGUI();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        ResourceLabel binCountLabel = new ResourceLabel("plotter.configuration_dialog.bin_count", new Object[0]);
        this.binCountSpinner = new JSpinner(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        binCountLabel.setLabelFor(this.binCountSpinner);
        this.binCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EqualDataFractionCardPanel.this.binCountChanged();
            }
        });
        this.addTwoComponentRow(this, (JComponent)binCountLabel, this.binCountSpinner);
        JPanel spacerPanel = new JPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint);
    }

    private void binCountChanged() {
        int newBinCount;
        int oldBinCount;
        EqualDataFractionGrouping grouping;
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = (EqualDataFractionGrouping)dimensionConfig.getGrouping()) != null && (oldBinCount = grouping.getBinCount()) != (newBinCount = ((Integer)this.binCountSpinner.getValue()).intValue())) {
            grouping.setBinCount(newBinCount);
        }
    }

    @Override
    protected void adaptGUI() {
        ValueGrouping grouping;
        super.adaptGUI();
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = dimensionConfig.getGrouping()) != null && grouping.getGroupingType() == ValueGrouping.GroupingType.EQUAL_DATA_FRACTION) {
            EqualDataFractionGrouping equalDataFractionGrouping = (EqualDataFractionGrouping)grouping;
            this.binCountSpinner.setValue(equalDataFractionGrouping.getBinCount());
        }
    }
}

