/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.groupingpanel;

import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.EquidistantFixedBinCountBinning;
import com.owc.gui.charting.configuration.ValueGrouping;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.gui.groupingpanel.AbstractGroupingCardPanel;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.rapidminer.gui.tools.ResourceLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EquidistantFixedBinCountCardPanel
extends AbstractGroupingCardPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoRangeCheckBox;
    private JLabel upperBoundLabel;
    private JSpinner upperBoundSpinner;
    private JLabel lowerBoundLabel;
    private JSpinner lowerBoundSpinner;
    private JSpinner binCountSpinner;
    private boolean changingAutoRange;

    public EquidistantFixedBinCountCardPanel(PlotInstance plotInstance, DimensionConfig.PlotDimension dimension) {
        super(plotInstance, dimension);
        this.adaptGUI();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        ResourceLabel binCountLabel = new ResourceLabel("plotter.configuration_dialog.bin_count", new Object[0]);
        this.binCountSpinner = new JSpinner(new SpinnerNumberModel((Number)5, Integer.valueOf(1), null, (Number)1));
        binCountLabel.setLabelFor(this.binCountSpinner);
        this.binCountSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquidistantFixedBinCountCardPanel.this.binCountChanged();
            }
        });
        this.addTwoComponentRow(this, (JComponent)binCountLabel, this.binCountSpinner);
        ResourceLabel autoRangeLabel = new ResourceLabel("plotter.configuration_dialog.auto_range", new Object[0]);
        this.autoRangeCheckBox = new JCheckBox();
        autoRangeLabel.setLabelFor(this.autoRangeCheckBox);
        this.autoRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EquidistantFixedBinCountCardPanel.this.autoRangeChanged();
            }
        });
        this.addTwoComponentRow(this, (JComponent)autoRangeLabel, this.autoRangeCheckBox);
        this.upperBoundLabel = new ResourceLabel("plotter.configuration_dialog.upper_bound", new Object[0]);
        this.upperBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)10.1, null, null, (Number)0.1));
        this.upperBoundLabel.setLabelFor(this.upperBoundSpinner);
        this.upperBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquidistantFixedBinCountCardPanel.this.upperBoundChanged();
            }
        });
        this.addTwoComponentRow(this, this.upperBoundLabel, this.upperBoundSpinner);
        this.lowerBoundLabel = new ResourceLabel("plotter.configuration_dialog.lower_bound", new Object[0]);
        this.lowerBoundSpinner = new JSpinner(new SpinnerNumberModel((Number)0.1, null, null, (Number)0.1));
        this.lowerBoundLabel.setLabelFor(this.lowerBoundSpinner);
        this.lowerBoundSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EquidistantFixedBinCountCardPanel.this.lowerBoundChanged();
            }
        });
        this.addTwoComponentRow(this, this.lowerBoundLabel, this.lowerBoundSpinner);
        JPanel spacerPanel = new JPanel();
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        this.add((Component)spacerPanel, itemConstraint);
    }

    private void binCountChanged() {
        int newBinCount;
        int oldBinCount;
        EquidistantFixedBinCountBinning grouping;
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = (EquidistantFixedBinCountBinning)dimensionConfig.getGrouping()) != null && (oldBinCount = grouping.getBinCount()) != (newBinCount = ((Integer)this.binCountSpinner.getValue()).intValue())) {
            grouping.setBinCount(newBinCount);
        }
    }

    protected void upperBoundChanged() {
        double newUpperBound;
        double oldUpperBound;
        EquidistantFixedBinCountBinning grouping;
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = (EquidistantFixedBinCountBinning)dimensionConfig.getGrouping()) != null && (oldUpperBound = grouping.getMaxValue()) != (newUpperBound = ((Double)this.upperBoundSpinner.getValue()).doubleValue())) {
            double currentLowerBound = (Double)this.lowerBoundSpinner.getValue();
            if (DataStructureUtils.almostEqual(currentLowerBound, newUpperBound, 1.0E-6) || newUpperBound <= currentLowerBound) {
                this.upperBoundSpinner.setValue(oldUpperBound);
                return;
            }
            if (!this.changingAutoRange) {
                grouping.setMaxValue(newUpperBound);
            }
        }
    }

    protected void lowerBoundChanged() {
        double newLowerBound;
        double oldLowerBound;
        EquidistantFixedBinCountBinning grouping;
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = (EquidistantFixedBinCountBinning)dimensionConfig.getGrouping()) != null && (oldLowerBound = grouping.getMinValue()) != (newLowerBound = ((Double)this.lowerBoundSpinner.getValue()).doubleValue())) {
            double currentUpperBound = (Double)this.upperBoundSpinner.getValue();
            if (DataStructureUtils.almostEqual(currentUpperBound, newLowerBound, 1.0E-6) || currentUpperBound <= newLowerBound) {
                this.lowerBoundSpinner.setValue(oldLowerBound);
                return;
            }
            if (!this.changingAutoRange) {
                grouping.setMinValue(newLowerBound);
            }
        }
    }

    private void autoRangeChanged() {
        boolean autoRanging;
        boolean selected;
        EquidistantFixedBinCountBinning grouping;
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = (EquidistantFixedBinCountBinning)dimensionConfig.getGrouping()) != null && (selected = this.autoRangeCheckBox.isSelected()) != (autoRanging = grouping.isAutoRanging())) {
            this.changingAutoRange = true;
            grouping.setAutoRange(selected);
        }
    }

    @Override
    protected void adaptGUI() {
        ValueGrouping grouping;
        super.adaptGUI();
        DimensionConfig dimensionConfig = this.getPlotConfiguration().getDimensionConfig(this.getDimension());
        if (dimensionConfig != null && (grouping = dimensionConfig.getGrouping()) != null && grouping.getGroupingType() == ValueGrouping.GroupingType.EQUIDISTANT_FIXED_BIN_COUNT) {
            EquidistantFixedBinCountBinning equidistantFixedBinCountBinning = (EquidistantFixedBinCountBinning)grouping;
            this.binCountSpinner.setValue(equidistantFixedBinCountBinning.getBinCount());
            this.upperBoundSpinner.setValue(equidistantFixedBinCountBinning.getMaxValue());
            this.lowerBoundSpinner.setValue(equidistantFixedBinCountBinning.getMinValue());
            boolean autoRanging = equidistantFixedBinCountBinning.isAutoRanging();
            this.autoRangeCheckBox.setSelected(autoRanging);
            this.lowerBoundLabel.setEnabled(!autoRanging);
            this.lowerBoundSpinner.setEnabled(!autoRanging);
            this.upperBoundLabel.setEnabled(!autoRanging);
            this.upperBoundSpinner.setEnabled(!autoRanging);
            if (this.changingAutoRange) {
                this.changingAutoRange = false;
            }
        }
    }
}

