/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.popup;

import com.owc.gui.charting.gui.popup.PopupComponentListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class PopupPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final List<PopupComponentListener> listenerList = new LinkedList<PopupComponentListener>();
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";
    private Window containingWindow;

    public PopupPanel(Component comp) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints itemConstraint = new GridBagConstraints();
        itemConstraint = new GridBagConstraints();
        itemConstraint.fill = 1;
        itemConstraint.weightx = 1.0;
        itemConstraint.weighty = 1.0;
        itemConstraint.gridwidth = 0;
        itemConstraint.insets = new Insets(5, 5, 5, 5);
        this.setBorder(new JPopupMenu().getBorder());
        this.add(comp, itemConstraint);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component newValue = (Component)evt.getNewValue();
        if (newValue == null) {
            return;
        }
        if (!this.isFocusInside(newValue)) {
            this.fireFocusLost();
        }
    }

    public void addListener(PopupComponentListener l) {
        this.listenerList.add(l);
    }

    public void removeListener(PopupComponentListener l) {
        this.listenerList.remove(l);
    }

    public void startTracking(Window containingWindow, Component actionSource) {
        this.containingWindow = containingWindow;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
    }

    public void stopTracking() {
        this.containingWindow = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
    }

    private void fireFocusLost() {
        for (PopupComponentListener l : this.listenerList) {
            l.focusLost();
        }
        this.stopTracking();
    }

    private boolean isFocusInside(Object newFocusedComp) {
        if (newFocusedComp instanceof Popup) {
            return true;
        }
        if (newFocusedComp instanceof Component && !SwingUtilities.isDescendingFrom((Component)newFocusedComp, this)) {
            if (this.containingWindow == null) {
                return false;
            }
            Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (this.containingWindow == focusedWindow) {
                return false;
            }
        }
        return true;
    }
}

