/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.gui.treenodes;

import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.ValueSource;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class RangeAxisConfigTreeNode
extends DefaultMutableTreeNode
implements Transferable {
    private static final long serialVersionUID = 1L;
    private static final String MIME_TYPE = "application/x-java-jvm-local-objectref;class=" + RangeAxisConfig.class.getName();
    public static DataFlavor RANGE_AXIS_CONFIG_FLAVOR;

    public RangeAxisConfigTreeNode(RangeAxisConfig rangeAxis) {
        super(rangeAxis, true);
    }

    public int getValueSourceIndex(ValueSource valueSource) {
        if (this.children == null) {
            return -1;
        }
        for (Object child : this.children) {
            if (valueSource != ((DefaultMutableTreeNode)child).getUserObject()) continue;
            return this.children.indexOf(child);
        }
        return -1;
    }

    public TreeNode getChild(ValueSource source) {
        int valueSourceIndex = this.getValueSourceIndex(source);
        if (valueSourceIndex < 0) {
            return null;
        }
        return this.getChildAt(valueSourceIndex);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavour = new DataFlavor[]{RANGE_AXIS_CONFIG_FLAVOR};
        return dataFlavour;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.match(RANGE_AXIS_CONFIG_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public RangeAxisConfig getUserObject() {
        return (RangeAxisConfig)super.getUserObject();
    }

    static {
        try {
            RANGE_AXIS_CONFIG_FLAVOR = new DataFlavor(MIME_TYPE, "OWCRangeAxisConfigTreeNode", RangeAxisConfigTreeNode.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

