/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.integration;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DefaultDimensionConfig;
import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.data.DataTableColumnIndex;
import com.owc.gui.charting.gui.AbstractConfigurationPanel;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.ports.ProcessingStep;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class PlotConfigurationHistory {
    private static final HashMap<ProcessingStep, Map<AbstractConfigurationPanel.DatasetTransformationType, PlotConfiguration>> settingsHistory = new HashMap();

    private PlotConfigurationHistory() {
    }

    public static Map<AbstractConfigurationPanel.DatasetTransformationType, PlotConfiguration> getPlotConfigurationMap(IOObject object, DataTable dataTable) {
        List steps = object.getProcessingHistory();
        ListIterator iterator = steps.listIterator(steps.size());
        Map<AbstractConfigurationPanel.DatasetTransformationType, PlotConfiguration> plotConfigMap = new HashMap<AbstractConfigurationPanel.DatasetTransformationType, PlotConfiguration>();
        boolean isFirst = false;
        while (iterator.hasPrevious()) {
            ProcessingStep step = (ProcessingStep)iterator.previous();
            if (!isFirst) {
                PlotConfiguration plotConfiguration;
                plotConfigMap = settingsHistory.get(step);
                if (plotConfigMap == null || (plotConfiguration = plotConfigMap.get((Object)AbstractConfigurationPanel.DatasetTransformationType.ORIGINAL)) == null) continue;
                if (PlotConfigurationHistory.isPlotConfigurationCompatible(plotConfiguration, dataTable)) {
                    plotConfiguration = plotConfiguration.clone();
                    settingsHistory.put((ProcessingStep)steps.get(steps.size() - 1), plotConfigMap);
                    return plotConfigMap;
                }
                plotConfigMap = null;
                break;
            }
            isFirst = false;
        }
        if (plotConfigMap == null || plotConfigMap.isEmpty()) {
            plotConfigMap = new HashMap();
            PlotConfiguration plotConfiguration = new PlotConfiguration(new DataTableColumn(dataTable, -1));
            plotConfigMap.put(AbstractConfigurationPanel.DatasetTransformationType.ORIGINAL, plotConfiguration);
            PlotConfiguration metaPlotConfiguration = new PlotConfiguration(new DataTableColumn(null, DataTableColumn.ValueType.INVALID));
            plotConfigMap.put(AbstractConfigurationPanel.DatasetTransformationType.DE_PIVOTED, metaPlotConfiguration);
            if (!steps.isEmpty()) {
                settingsHistory.put((ProcessingStep)steps.get(steps.size() - 1), plotConfigMap);
            }
        }
        return plotConfigMap;
    }

    private static boolean isPlotConfigurationCompatible(PlotConfiguration plotConfiguration, DataTable dataTable) {
        for (ValueSource valueSource : plotConfiguration.getAllValueSources()) {
            for (ValueSource.SeriesUsageType usageType : valueSource.getDefinedUsageTypes()) {
                DataTableColumnIndex columnIdx;
                DataTableColumn column = valueSource.getDataTableColumn(usageType);
                if (column == null || (columnIdx = new DataTableColumnIndex(column, dataTable)).getIndex() >= 0) continue;
                return false;
            }
        }
        for (DefaultDimensionConfig defaultDimensionConfig : plotConfiguration.getDefaultDimensionConfigs().values()) {
            DataTableColumn column = defaultDimensionConfig.getDataTableColumn();
            DataTableColumnIndex columnIdx = new DataTableColumnIndex(column, dataTable);
            if (columnIdx.getIndex() >= 0) continue;
            return false;
        }
        DataTableColumn column = plotConfiguration.getDomainConfigManager().getDataTableColumn();
        DataTableColumnIndex columnIdx = new DataTableColumnIndex(column, dataTable);
        return columnIdx.getIndex() >= 0;
    }
}

