/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.DataTableColumn;
import com.owc.gui.charting.configuration.DimensionConfig;
import com.owc.gui.charting.configuration.DomainConfigManager;
import com.owc.gui.charting.configuration.event.AxisParallelLinesConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.ValueGroupingChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.ShapeProvider;
import com.owc.gui.charting.utility.SizeProvider;
import java.text.DateFormat;

public class DimensionConfigChangeEvent
implements ConfigurationChangeEvent {
    private final DimensionConfigChangeType type;
    private final DimensionConfig source;
    private final DimensionConfig.PlotDimension dimension;
    private DataTableColumn column = null;
    private ValueGroupingChangeEvent groupingChangeEvent = null;
    private ValueRangeChangeEvent valueRangeChangedEvent = null;
    private Boolean logarithmic = null;
    private String label = null;
    private ColorProvider colorProvider = null;
    private ShapeProvider shapeProvider = null;
    private SizeProvider sizeProvider = null;
    private DomainConfigManager.Sorting sortingMode = null;
    private Boolean includeZero = null;
    private Boolean autoNaming = null;
    private AxisParallelLinesConfigurationChangeEvent crosshairLinesChange;
    private DateFormat dateFormat;

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, DimensionConfigChangeType type) {
        if (type != DimensionConfigChangeType.ABOUT_TO_CHANGE_GROUPING && type != DimensionConfigChangeType.RESET && type != DimensionConfigChangeType.COLOR_SCHEME) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, ValueGroupingChangeEvent groupingChangeEvent) {
        this.source = source;
        this.type = DimensionConfigChangeType.GROUPING_CHANGED;
        this.groupingChangeEvent = groupingChangeEvent;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, ValueRangeChangeEvent valueRangeChangedEvent) {
        this.source = source;
        this.type = DimensionConfigChangeType.RANGE;
        this.valueRangeChangedEvent = valueRangeChangedEvent;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, DataTableColumn column) {
        this.source = source;
        this.type = DimensionConfigChangeType.COLUMN;
        this.column = column;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, Boolean bool, DimensionConfigChangeType type) {
        if (type != DimensionConfigChangeType.SCALING && type != DimensionConfigChangeType.AUTO_NAMING) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
        if (type == DimensionConfigChangeType.SCALING) {
            this.logarithmic = bool;
        } else if (type == DimensionConfigChangeType.AUTO_NAMING) {
            this.autoNaming = bool;
        } else {
            this.includeZero = bool;
        }
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, String label) {
        this.source = source;
        this.type = DimensionConfigChangeType.LABEL;
        this.label = label;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, ColorProvider colorProvider) {
        this.source = source;
        this.type = DimensionConfigChangeType.COLOR_PROVIDER;
        this.colorProvider = colorProvider;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, SizeProvider sizeProvider) {
        this.source = source;
        this.type = DimensionConfigChangeType.SIZE_PROVIDER;
        this.sizeProvider = sizeProvider;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, ShapeProvider shapeProvider) {
        this.source = source;
        this.type = DimensionConfigChangeType.SHAPE_PROVIDER;
        this.shapeProvider = shapeProvider;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DimensionConfig.PlotDimension dimension, DomainConfigManager.Sorting sortingMode) {
        this.source = source;
        this.type = DimensionConfigChangeType.SORTING;
        this.sortingMode = sortingMode;
        this.dimension = dimension;
    }

    public DimensionConfigChangeEvent(DomainConfigManager source, DimensionConfig.PlotDimension dimension, AxisParallelLinesConfigurationChangeEvent e) {
        this.type = DimensionConfigChangeType.CROSSHAIR_LINES_CHANGED;
        this.dimension = dimension;
        this.source = source;
        this.crosshairLinesChange = e;
    }

    public DimensionConfigChangeEvent(DimensionConfig source, DateFormat dateFormat) {
        this.source = source;
        this.dimension = source.getDimension();
        this.type = DimensionConfigChangeType.DATE_FORMAT_CHANGED;
        this.dateFormat = dateFormat;
    }

    public DataTableColumn getDataTableColumn() {
        return this.column;
    }

    public ValueGroupingChangeEvent getGroupingChangeEvent() {
        return this.groupingChangeEvent;
    }

    public ValueRangeChangeEvent getValueRangeChangedEvent() {
        return this.valueRangeChangedEvent;
    }

    public Boolean getLogarithmic() {
        return this.logarithmic;
    }

    public String getLabel() {
        return this.label;
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public SizeProvider getSizeProvider() {
        return this.sizeProvider;
    }

    public ShapeProvider getShapeProvider() {
        return this.shapeProvider;
    }

    public DimensionConfigChangeType getType() {
        return this.type;
    }

    public DimensionConfig getSource() {
        return this.source;
    }

    public DomainConfigManager.Sorting getSortingMode() {
        return this.sortingMode;
    }

    public DimensionConfig.PlotDimension getDimension() {
        return this.dimension;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.DIMENSION_CONFIG_CHANGE;
    }

    public Boolean getIncludeZero() {
        return this.includeZero;
    }

    public Boolean getAutoNaming() {
        return this.autoNaming;
    }

    public String toString() {
        return this.getType().toString();
    }

    public AxisParallelLinesConfigurationChangeEvent getCrosshairLinesChange() {
        return this.crosshairLinesChange;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public static enum DimensionConfigChangeType {
        RESET,
        ABOUT_TO_CHANGE_GROUPING,
        GROUPING_CHANGED,
        RANGE,
        COLUMN,
        SCALING,
        LABEL,
        COLOR_PROVIDER,
        SHAPE_PROVIDER,
        SIZE_PROVIDER,
        SORTING,
        AUTO_NAMING,
        COLOR_SCHEME,
        CROSSHAIR_LINES_CHANGED,
        DATE_FORMAT_CHANGED;

    }
}

