/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.LegendConfiguration;
import java.awt.Color;
import java.awt.Font;

public class LegendConfigurationChangeEvent {
    private LegendConfiguration.LegendPosition legendPosition = null;
    private Font legendFont = null;
    private LegendConfiguration source;
    private LegendConfigurationChangeType type;
    private boolean showDimensionType;
    private Color frameColor;
    private Color backgroundColor;
    private boolean showLegendFrame;

    public LegendConfigurationChangeEvent(LegendConfiguration source, LegendConfiguration.LegendPosition legendPosition) {
        this.source = source;
        this.type = LegendConfigurationChangeType.POSITON;
        this.legendPosition = legendPosition;
    }

    public LegendConfigurationChangeEvent(LegendConfiguration source, Font font) {
        this.source = source;
        this.type = LegendConfigurationChangeType.FONT;
        this.legendFont = font;
    }

    public LegendConfigurationChangeEvent(LegendConfiguration source, boolean show, LegendConfigurationChangeType type) {
        if (type != LegendConfigurationChangeType.SHOW_DIMENSION_TYPE && type != LegendConfigurationChangeType.SHOW_LEGEND_FRAME) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
        if (type == LegendConfigurationChangeType.SHOW_DIMENSION_TYPE) {
            this.showDimensionType = show;
        } else {
            this.showLegendFrame = show;
        }
    }

    public LegendConfigurationChangeEvent(LegendConfiguration source, Color color, LegendConfigurationChangeType type) {
        if (type != LegendConfigurationChangeType.FRAME_COLOR && type != LegendConfigurationChangeType.BACKGROUND_COLOR) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.type = type;
        if (type == LegendConfigurationChangeType.FRAME_COLOR) {
            this.frameColor = color;
        } else {
            this.backgroundColor = color;
        }
    }

    public boolean isShowDimensionType() {
        return this.showDimensionType;
    }

    public LegendConfiguration.LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public LegendConfiguration getSource() {
        return this.source;
    }

    public LegendConfigurationChangeType getType() {
        return this.type;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isShowLegendFrame() {
        return this.showLegendFrame;
    }

    public static enum LegendConfigurationChangeType {
        POSITON,
        FONT,
        SHOW_DIMENSION_TYPE,
        BACKGROUND_COLOR,
        FRAME_COLOR,
        SHOW_LEGEND_FRAME;

    }
}

