/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.listener.events;

import com.owc.gui.charting.configuration.RangeAxisConfig;
import com.owc.gui.charting.configuration.ValueSource;
import com.owc.gui.charting.configuration.event.AxisParallelLinesConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.ConfigurationChangeEvent;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.listener.events.ValueSourceChangeEvent;
import java.awt.Color;

public class RangeAxisConfigChangeEvent
implements ConfigurationChangeEvent {
    private final RangeAxisConfigChangeType type;
    private final RangeAxisConfig source;
    private ValueSource valueSource = null;
    private Integer index = null;
    private String label = null;
    private Boolean logarithmic = null;
    private Boolean includeZero = null;
    private Boolean autoNaming = null;
    private ValueSourceChangeEvent valueSourceChange = null;
    private Color rangeAxisLineColor;
    private Float rangeAxisLineWidth;
    private ValueRangeChangeEvent valueRangeChange = null;
    private AxisParallelLinesConfigurationChangeEvent crosshairChange;

    public RangeAxisConfigChangeEvent(RangeAxisConfig source) {
        this.source = source;
        this.type = RangeAxisConfigChangeType.CLEARED;
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig source, RangeAxisConfigChangeType type, ValueSource valueSource, Integer index) {
        this.type = type;
        if (type != RangeAxisConfigChangeType.VALUE_SOURCE_ADDED && type != RangeAxisConfigChangeType.VALUE_SOURCE_REMOVED && type != RangeAxisConfigChangeType.VALUE_SOURCE_MOVED) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        this.valueSource = valueSource;
        this.index = index;
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig source, String label) {
        this.type = RangeAxisConfigChangeType.LABEL;
        this.source = source;
        this.label = label;
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig source, RangeAxisConfigChangeType type, Boolean bool) {
        this.type = type;
        if (type != RangeAxisConfigChangeType.SCALING && type != RangeAxisConfigChangeType.AUTO_NAMING) {
            throw new RuntimeException((Object)((Object)type) + " is not allowed calling this constructor.");
        }
        this.source = source;
        if (type == RangeAxisConfigChangeType.SCALING) {
            this.logarithmic = bool;
        } else {
            this.autoNaming = bool;
        }
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig source, ValueRangeChangeEvent valueRangeChange) {
        this.source = source;
        this.type = RangeAxisConfigChangeType.RANGE_CHANGED;
        this.valueRangeChange = valueRangeChange;
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig source, ValueSourceChangeEvent valueSourceChange) {
        this.source = source;
        this.type = RangeAxisConfigChangeType.VALUE_SOURCE_CHANGED;
        this.valueSourceChange = valueSourceChange;
    }

    public RangeAxisConfigChangeEvent(RangeAxisConfig rangeAxisConfig, AxisParallelLinesConfigurationChangeEvent e) {
        this.type = RangeAxisConfigChangeType.CROSSHAIR_LINES_CHANGED;
        this.source = rangeAxisConfig;
        this.crosshairChange = e;
    }

    public ValueSourceChangeEvent getValueSourceChange() {
        return this.valueSourceChange;
    }

    public ValueSource getValueSource() {
        return this.valueSource;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getLabel() {
        return this.label;
    }

    public Boolean getLogarithmic() {
        return this.logarithmic;
    }

    public Boolean getIncludeZero() {
        return this.includeZero;
    }

    public RangeAxisConfigChangeType getType() {
        return this.type;
    }

    public ValueRangeChangeEvent getValueRangeChange() {
        return this.valueRangeChange;
    }

    public RangeAxisConfig getSource() {
        return this.source;
    }

    @Override
    public ConfigurationChangeEvent.ConfigurationChangeType getConfigurationChangeType() {
        return ConfigurationChangeEvent.ConfigurationChangeType.RANGE_AXIS_CONFIG_CHANGE;
    }

    public Boolean getAutoNaming() {
        return this.autoNaming;
    }

    public String toString() {
        return this.getType().toString();
    }

    public Color getRangeAxisLineColor() {
        return this.rangeAxisLineColor;
    }

    public Float getRangeAxisLineWidth() {
        return this.rangeAxisLineWidth;
    }

    public AxisParallelLinesConfigurationChangeEvent getCrosshairChange() {
        return this.crosshairChange;
    }

    public static enum RangeAxisConfigChangeType {
        VALUE_SOURCE_ADDED,
        VALUE_SOURCE_REMOVED,
        VALUE_SOURCE_MOVED,
        VALUE_SOURCE_CHANGED,
        CLEARED,
        LABEL,
        SCALING,
        AUTO_NAMING,
        RANGE_CHANGED,
        CROSSHAIR_LINES_CHANGED;

    }
}

