/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.templates.style;

import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.XMLException;
import java.awt.Color;
import java.io.Serializable;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColorRGB
extends AbstractObservable<ColorRGB>
implements Serializable {
    private static final long serialVersionUID = -3003380979103428136L;
    public static final String XML_TAG_NAME = "color";
    private static final String R_XML_TAG = "red";
    private static final String G_XML_TAG = "green";
    private static final String B_XML_TAG = "blue";
    private static final String ALPHA_XML_TAG = "alpha";
    private int r;
    private int g;
    private int b;
    private int alpha;
    private UUID id = UUID.randomUUID();

    public ColorRGB(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public ColorRGB(int r, int g, int b, int alpha) {
        if (r > 255 || r < 0) {
            throw new IllegalArgumentException("r must be between 0 and 255, but was '" + r + "'!");
        }
        if (g > 255 || g < 0) {
            throw new IllegalArgumentException("g must be between 0 and 255, but was '" + g + "'!");
        }
        if (b > 255 || b < 0) {
            throw new IllegalArgumentException("b must be between 0 and 255, but was '" + b + "'!");
        }
        if (alpha > 255 || alpha < 0) {
            throw new IllegalArgumentException("alpha must be between 0 and 255, but was '" + alpha + "'!");
        }
        this.r = r;
        this.g = g;
        this.b = b;
        this.alpha = alpha;
    }

    public ColorRGB(Element element) throws XMLException {
        if (!XML_TAG_NAME.equals(element.getTagName())) {
            throw new XMLException("<color> expected.");
        }
        this.r = XMLTools.getTagContentsAsInt((Element)element, (String)R_XML_TAG);
        this.g = XMLTools.getTagContentsAsInt((Element)element, (String)G_XML_TAG);
        this.b = XMLTools.getTagContentsAsInt((Element)element, (String)B_XML_TAG);
        this.alpha = XMLTools.getTagContentsAsInt((Element)element, (String)ALPHA_XML_TAG);
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public String getHexValue() {
        return "#" + ColorRGB.convertColorRGBToHex(this);
    }

    public void setHexValue(String hexValue) {
        ColorRGB convertHexToColorRGB = ColorRGB.convertHexToColorRGB(hexValue.substring(1));
        this.r = convertHexToColorRGB.getR();
        this.g = convertHexToColorRGB.getG();
        this.b = convertHexToColorRGB.getB();
        this.alpha = convertHexToColorRGB.getAlpha();
        this.fireUpdate(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alpha;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorRGB other = (ColorRGB)obj;
        if (this.alpha != other.alpha) {
            return false;
        }
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.r == other.r;
    }

    public static Color convertToColor(ColorRGB colorRGB) {
        return new Color(colorRGB.getR(), colorRGB.getG(), colorRGB.getB());
    }

    public static Color convertToColorWithAlpha(ColorRGB colorRGB) {
        return new Color(colorRGB.getR(), colorRGB.getG(), colorRGB.getB(), colorRGB.getAlpha());
    }

    public static ColorRGB convertColorToColorRGB(Color color) {
        return new ColorRGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static ColorRGB convertColorWithAlphaToColorRGB(Color color) {
        return new ColorRGB(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public ColorRGB clone() {
        return new ColorRGB(this.r, this.g, this.b, this.alpha);
    }

    public static String convertColorRGBToHex(ColorRGB color) {
        return String.format("%02x%02x%02x", color.getR(), color.getG(), color.getB());
    }

    public static ColorRGB convertHexToColorRGB(String hexString) {
        return ColorRGB.convertColorToColorRGB(Color.decode("#" + hexString));
    }

    public Node toXML(Document doc) {
        Element root = doc.createElement(XML_TAG_NAME);
        XMLTools.setTagContents((Element)root, (String)R_XML_TAG, (String)String.valueOf(this.getR()));
        XMLTools.setTagContents((Element)root, (String)G_XML_TAG, (String)String.valueOf(this.getG()));
        XMLTools.setTagContents((Element)root, (String)B_XML_TAG, (String)String.valueOf(this.getB()));
        XMLTools.setTagContents((Element)root, (String)ALPHA_XML_TAG, (String)String.valueOf(this.getAlpha()));
        return root;
    }
}

