/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.listener.ValueRangeListener;
import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.utility.ValueRange;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractValueRange
implements ValueRange,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1670287541641322688L;
    private transient List<WeakReference<ValueRangeListener>> listeners = new LinkedList<WeakReference<ValueRangeListener>>();

    @Override
    public abstract ValueRange clone();

    public abstract boolean equals(Object var1);

    @Override
    public void addValueRangeListener(ValueRangeListener l) {
        this.listeners.add(new WeakReference<ValueRangeListener>(l));
    }

    @Override
    public void removeValueRangeListener(ValueRangeListener l) {
        Iterator<WeakReference<ValueRangeListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ValueRangeListener listener = (ValueRangeListener)it.next().get();
            if (listener != null && listener != l) continue;
            it.remove();
        }
    }

    protected void fireValueRangeChanged(ValueRangeChangeEvent e) {
        Iterator<WeakReference<ValueRangeListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            ValueRangeListener listener = (ValueRangeListener)it.next().get();
            if (listener == null) {
                it.remove();
                continue;
            }
            listener.valueRangeChanged(e);
        }
    }
}

