/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.listener.events.ValueRangeChangeEvent;
import com.owc.gui.charting.utility.AbstractValueRange;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTableRow;
import java.util.LinkedList;
import java.util.List;

public class AggregatedValueRange
extends AbstractValueRange {
    private static final long serialVersionUID = -5165349285678290300L;
    private List<ValueRange> subRanges = new LinkedList<ValueRange>();

    public void addSubRange(ValueRange subRange) {
        this.subRanges.add(subRange);
        this.fireValueRangeChanged(new ValueRangeChangeEvent(this, ValueRangeChangeEvent.ValueRangeChangeType.RESET));
    }

    public boolean keepRow(DataTableRow row) {
        for (ValueRange subRange : this.subRanges) {
            if (!subRange.keepRow(row)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getValue() {
        if (!this.subRanges.isEmpty()) {
            return this.subRanges.get(0).getValue();
        }
        return Double.NaN;
    }

    @Override
    public boolean definesUpperLowerBound() {
        if (!this.subRanges.isEmpty()) {
            return this.subRanges.get(0).definesUpperLowerBound();
        }
        return false;
    }

    @Override
    public double getUpperBound() {
        if (!this.subRanges.isEmpty()) {
            return this.subRanges.get(0).getUpperBound();
        }
        return Double.NaN;
    }

    @Override
    public double getLowerBound() {
        if (!this.subRanges.isEmpty()) {
            return this.subRanges.get(0).getLowerBound();
        }
        return Double.NaN;
    }

    @Override
    public ValueRange clone() {
        AggregatedValueRange clone = new AggregatedValueRange();
        for (ValueRange subRange : this.subRanges) {
            clone.addSubRange(subRange.clone());
        }
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AggregatedValueRange)) {
            return false;
        }
        AggregatedValueRange tempObj = (AggregatedValueRange)obj;
        if (tempObj.getLowerBound() != this.getLowerBound()) {
            return false;
        }
        return tempObj.getUpperBound() == this.getUpperBound();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Aggregated:{");
        for (ValueRange subRange : this.subRanges) {
            builder.append(subRange.toString()).append(",");
        }
        builder.append("}");
        return builder.toString();
    }
}

