/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.templates.style.ColorScheme;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.DataStructureUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoricalColorProvider
implements ColorProvider {
    private Map<Double, Color> colorMap;
    private int alpha;

    public CategoricalColorProvider(Map<Double, Color> colorMap, int alpha) {
        this.colorMap = colorMap;
        this.alpha = alpha;
        this.updateColorMapAlpha();
    }

    public CategoricalColorProvider(PlotInstance plotInstance, List<Double> categoryList, int alpha) {
        this.alpha = alpha;
        this.colorMap = this.createColorMapping(plotInstance, categoryList, alpha);
    }

    private Map<Double, Color> createColorMapping(PlotInstance plotInstance, List<Double> categoryList, int alpha) {
        ColorScheme colorScheme = plotInstance.getCurrentPlotConfigurationClone().getActiveColorScheme();
        HashMap<Double, Color> colorMapping = new HashMap<Double, Color>();
        int idx = 0;
        for (Double category : categoryList) {
            colorMapping.put(category, CategoricalColorProvider.getColorForCategoryIdx(idx, colorScheme));
            ++idx;
        }
        return colorMapping;
    }

    public static Color getColorForCategoryIdx(int idx, ColorScheme colorScheme) {
        List<ColorRGB> colors = colorScheme.getColors();
        int colorListSize = colors.size();
        int darken = idx / colorListSize;
        Color categoryColor = ColorRGB.convertToColor(colors.get(idx % colorListSize));
        for (int i = 0; i < darken; ++i) {
            categoryColor = categoryColor.darker();
        }
        return categoryColor;
    }

    public void setCategoryColor(double category, Color color) {
        this.colorMap.put(category, DataStructureUtils.setColorAlpha(color, this.alpha));
    }

    @Override
    public Color getColorForValue(double value) {
        return this.colorMap.get(value);
    }

    private void updateColorMapAlpha() {
        HashMap<Double, Color> newColorMap = new HashMap<Double, Color>();
        for (Map.Entry<Double, Color> colorEntry : this.colorMap.entrySet()) {
            newColorMap.put(colorEntry.getKey(), DataStructureUtils.setColorAlpha(colorEntry.getValue(), this.alpha));
        }
        this.colorMap = newColorMap;
    }

    @Override
    public boolean supportsCategoricalValues() {
        return true;
    }

    @Override
    public boolean supportsNumericalValues() {
        return false;
    }

    @Override
    public ColorProvider clone() {
        HashMap<Double, Color> clonedColorMap = new HashMap<Double, Color>();
        clonedColorMap.putAll(this.colorMap);
        return new CategoricalColorProvider(clonedColorMap, this.alpha);
    }

    @Override
    public void seriesFormatChanged(SeriesFormatChangeEvent e) {
        if (e.getType() == SeriesFormatChangeEvent.SeriesFormatChangeType.OPACITY) {
            this.alpha = e.getOpacity();
            this.updateColorMapAlpha();
        }
    }

    public Map<Double, Color> getColorMap() {
        return this.colorMap;
    }
}

