/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.configuration.PlotConfiguration;
import com.owc.gui.charting.data.PlotInstance;
import com.owc.gui.charting.listener.events.SeriesFormatChangeEvent;
import com.owc.gui.charting.templates.style.ColorRGB;
import com.owc.gui.charting.utility.ColorProvider;
import com.owc.gui.charting.utility.DataStructureUtils;
import java.awt.Color;

public class ContinuousColorProvider
implements ColorProvider {
    private double minValue;
    private double maxValue;
    private double originalMinValue;
    private double originalMaxValue;
    Color minColor;
    Color maxColor;
    int alpha;
    private boolean logarithmic;
    private boolean useGrayForOutliers;

    public ContinuousColorProvider(double minValue, double maxValue, Color minColor, Color maxColor, int alpha, boolean logarithmic) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.originalMinValue = minValue;
        this.originalMaxValue = maxValue;
        this.minColor = minColor;
        this.maxColor = maxColor;
        this.alpha = alpha;
        this.logarithmic = logarithmic;
        this.useGrayForOutliers = false;
    }

    public ContinuousColorProvider(PlotInstance plotInstance, double minValue, double maxValue, int alpha, boolean logarithmic) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.originalMinValue = minValue;
        this.originalMaxValue = maxValue;
        PlotConfiguration currentPlotConfigurationClone = plotInstance.getCurrentPlotConfigurationClone();
        this.minColor = ColorRGB.convertToColor(currentPlotConfigurationClone.getActiveColorScheme().getGradientStartColor());
        this.maxColor = ColorRGB.convertToColor(currentPlotConfigurationClone.getActiveColorScheme().getGradientEndColor());
        this.alpha = alpha;
        this.logarithmic = logarithmic;
        this.useGrayForOutliers = false;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public Color getMinColor() {
        return this.minColor;
    }

    public void setMinColor(Color minColor) {
        this.minColor = minColor;
    }

    public Color getMaxColor() {
        return this.maxColor;
    }

    public void setMaxColor(Color maxColor) {
        this.maxColor = maxColor;
    }

    public static Color getColorForValue(double value, int alpha, boolean logarithmic, double minValue, double maxValue, Color minColor, Color maxColor) {
        if (Double.isNaN(value)) {
            return Color.LIGHT_GRAY;
        }
        value = minValue == maxValue ? 0.5 : (logarithmic ? (Math.log(value) - Math.log(minValue)) / (Math.log(maxValue) - Math.log(minValue)) : (value - minValue) / (maxValue - minValue));
        Color MIN_LEGEND_COLOR = minColor;
        Color MAX_LEGEND_COLOR = maxColor;
        float[] minCol = Color.RGBtoHSB(MIN_LEGEND_COLOR.getRed(), MIN_LEGEND_COLOR.getGreen(), MIN_LEGEND_COLOR.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(MAX_LEGEND_COLOR.getRed(), MAX_LEGEND_COLOR.getGreen(), MAX_LEGEND_COLOR.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        Color color = new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
        if (alpha < 255) {
            color = DataStructureUtils.setColorAlpha(color, alpha);
        }
        return color;
    }

    @Override
    public Color getColorForValue(double value) {
        if (Double.isNaN(value)) {
            return Color.LIGHT_GRAY;
        }
        if (this.minValue == this.maxValue) {
            value = 0.5;
        } else {
            if (value < this.minValue) {
                Color minColor = this.useGrayForOutliers ? Color.GRAY : this.minColor;
                if (this.alpha < 255) {
                    minColor = DataStructureUtils.setColorAlpha(minColor, this.alpha);
                }
                return minColor;
            }
            if (value > this.maxValue) {
                Color maxColor = this.useGrayForOutliers ? Color.GRAY : this.maxColor;
                if (this.alpha < 255) {
                    maxColor = DataStructureUtils.setColorAlpha(maxColor, this.alpha);
                }
                return maxColor;
            }
            value = this.logarithmic ? (Math.log(value) - Math.log(this.minValue)) / (Math.log(this.maxValue) - Math.log(this.minValue)) : (value - this.minValue) / (this.maxValue - this.minValue);
        }
        Color MIN_LEGEND_COLOR = this.getMinColor();
        Color MAX_LEGEND_COLOR = this.getMaxColor();
        float[] minCol = Color.RGBtoHSB(MIN_LEGEND_COLOR.getRed(), MIN_LEGEND_COLOR.getGreen(), MIN_LEGEND_COLOR.getBlue(), null);
        float[] maxCol = Color.RGBtoHSB(MAX_LEGEND_COLOR.getRed(), MAX_LEGEND_COLOR.getGreen(), MAX_LEGEND_COLOR.getBlue(), null);
        double hColorDiff = maxCol[0] - minCol[0];
        double sColorDiff = maxCol[1] - minCol[1];
        double bColorDiff = maxCol[2] - minCol[2];
        Color color = new Color(Color.HSBtoRGB((float)((double)minCol[0] + hColorDiff * value), (float)((double)minCol[1] + value * sColorDiff), (float)((double)minCol[2] + value * bColorDiff)));
        if (this.alpha < 255) {
            color = DataStructureUtils.setColorAlpha(color, this.alpha);
        }
        return color;
    }

    @Override
    public boolean supportsCategoricalValues() {
        return false;
    }

    @Override
    public boolean supportsNumericalValues() {
        return true;
    }

    @Override
    public ColorProvider clone() {
        return new ContinuousColorProvider(this.minValue, this.maxValue, new Color(this.minColor.getRed(), this.minColor.getGreen(), this.minColor.getBlue()), new Color(this.maxColor.getRed(), this.maxColor.getGreen(), this.maxColor.getBlue()), this.alpha, this.logarithmic);
    }

    @Override
    public void seriesFormatChanged(SeriesFormatChangeEvent e) {
        if (e.getType() == SeriesFormatChangeEvent.SeriesFormatChangeType.OPACITY) {
            this.alpha = e.getOpacity();
        }
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void revertMinAndMaxValuesBackToOriginalValues() {
        this.minValue = this.originalMinValue;
        this.maxValue = this.originalMaxValue;
    }

    public boolean isUseGrayForOutliers() {
        return this.useGrayForOutliers;
    }

    public void setUseGrayForOutliers(boolean useGrayForOutliers) {
        this.useGrayForOutliers = useGrayForOutliers;
    }

    public boolean isColorMinMaxValueDifferentFromOriginal(double minValue, double maxValue) {
        return minValue != this.originalMinValue || maxValue != this.originalMaxValue;
    }
}

