/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.utility.SizeProvider;

public class ContinuousSizeProvider
implements SizeProvider {
    private boolean logarithmic;
    private double maxScalingFactor;
    private double minScalingFactor;
    private double minValue;
    private double maxValue;

    public ContinuousSizeProvider(double minValue, double maxValue, double minSize, double maxSize, boolean logarithmic) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue > maxValue not allowed");
        }
        if (logarithmic && minValue <= 0.0) {
            throw new IllegalArgumentException("minValue <= 0 not allowed for logarithmic");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minScalingFactor = minSize * minSize;
        this.maxScalingFactor = maxSize * maxSize;
        this.logarithmic = logarithmic;
    }

    @Override
    public double getScalingFactorForValue(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return Double.NaN;
        }
        double fraction = this.minValue == this.maxValue ? 0.5 : (this.logarithmic ? (Math.log(value) - Math.log(this.minValue)) / (Math.log(this.maxValue) - Math.log(this.minValue)) : (value - this.minValue) / (this.maxValue - this.minValue));
        return Math.sqrt(this.minScalingFactor + (this.maxScalingFactor - this.minScalingFactor) * fraction);
    }

    @Override
    public boolean supportsCategoricalValues() {
        return false;
    }

    @Override
    public boolean supportsNumericalValues() {
        return true;
    }

    @Override
    public SizeProvider clone() {
        return new ContinuousSizeProvider(this.minValue, this.maxValue, this.minScalingFactor, this.maxScalingFactor, this.logarithmic);
    }

    @Override
    public double getMinScalingFactor() {
        return this.minScalingFactor;
    }

    @Override
    public double getMaxScalingFactor() {
        return this.maxScalingFactor;
    }
}

