/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.configuration.SeriesFormat;
import java.awt.Shape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShapeProvider {
    private Map<Double, Shape> shapeMap;

    public ShapeProvider(Map<Double, Shape> shapeMap) {
        this.shapeMap = shapeMap;
    }

    public ShapeProvider(List<Double> categoryList) {
        this.shapeMap = ShapeProvider.createShapeMapping(categoryList);
    }

    public Shape getShapeForCategory(double category) {
        return this.shapeMap.get(category);
    }

    public static Map<Double, Shape> createShapeMapping(List<Double> categoryList) {
        List<SeriesFormat.ItemShape> itemShapeValues = Arrays.asList(SeriesFormat.ItemShape.values());
        HashMap<Double, Shape> shapeMapping = new HashMap<Double, Shape>();
        int idx = 1;
        for (Double category : categoryList) {
            SeriesFormat.ItemShape itemShape;
            if (idx < itemShapeValues.size() && (itemShape = itemShapeValues.get(idx)) != SeriesFormat.ItemShape.NONE) {
                shapeMapping.put(category, itemShape.getShape());
            }
            ++idx;
        }
        return shapeMapping;
    }

    public void setShapeForCategory(double category, Shape shape) {
        if (shape == null) {
            this.shapeMap.remove(category);
        } else {
            this.shapeMap.put(category, shape);
        }
    }

    public int maxCategoryCount() {
        return SeriesFormat.ItemShape.values().length - 1;
    }

    public boolean supportsNumericalValues() {
        return false;
    }
}

