/*
 * Decompiled with CFR 0.152.
 */
package com.owc.gui.charting.utility;

import com.owc.gui.charting.utility.AbstractValueRange;
import com.owc.gui.charting.utility.DataStructureUtils;
import com.owc.gui.charting.utility.ValueRange;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.Tools;
import java.text.DateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public class SingleValueValueRange
extends AbstractValueRange {
    private static final long serialVersionUID = 7393794054468521034L;
    private double value;
    private String valueString;
    private int columnIdx;

    public SingleValueValueRange(double value) {
        this(value, (String)null, -1);
    }

    public SingleValueValueRange(double value, String valueString, int columnIdx) {
        this.value = value;
        this.valueString = valueString;
        this.columnIdx = columnIdx;
    }

    public SingleValueValueRange(double value, DataTable dataTable, int columnIdx) {
        this.value = value;
        this.columnIdx = columnIdx;
        if (columnIdx >= 0) {
            if (Double.isNaN(value)) {
                this.valueString = I18N.getGUILabel((String)"plotter.unknown_value_label", (Object[])new Object[0]);
            } else if (dataTable.isNumerical(columnIdx)) {
                this.valueString = Double.toString(value);
            } else if (dataTable.isNominal(columnIdx)) {
                this.valueString = dataTable.mapIndex(columnIdx, (int)value);
            } else if (dataTable.isDateTime(columnIdx)) {
                this.valueString = Tools.formatDateTime((Date)new java.sql.Date((long)value));
            } else {
                throw new IllegalArgumentException("unknown data type in data table - this should not happen");
            }
        }
    }

    public SingleValueValueRange(double value, DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("null format not allowed");
        }
        this.value = value;
        this.valueString = dateFormat.format(new java.sql.Date((long)value));
    }

    public boolean keepRow(DataTableRow row) {
        return row.getValue(this.columnIdx) == this.value;
    }

    @Override
    public String toString() {
        return this.valueString;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SingleValueValueRange)) {
            return false;
        }
        SingleValueValueRange other = (SingleValueValueRange)obj;
        return other.value == this.value;
    }

    public int hashCode() {
        Double dValue = new Double(this.value);
        return dValue.hashCode();
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public ValueRange clone() {
        SingleValueValueRange clone = new SingleValueValueRange(this.value, this.valueString, this.columnIdx);
        return clone;
    }

    @Override
    public boolean definesUpperLowerBound() {
        return false;
    }

    @Override
    public double getUpperBound() {
        return Double.NaN;
    }

    @Override
    public double getLowerBound() {
        return Double.NaN;
    }

    public void setVisualPrecision(int precision) {
        StringBuilder builder = new StringBuilder();
        double roundedValue = DataStructureUtils.roundToPowerOf10(this.getValue(), precision);
        Formatter formatter = new Formatter(builder, Locale.getDefault());
        String format = precision < 0 ? "%." + -precision + "f" : "%.0f";
        formatter.format(format, roundedValue);
        formatter.close();
        this.valueString = builder.toString();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.valueString = dateFormat.format(new java.sql.Date((long)this.value));
    }
}

