/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io;

import com.owc.tools.CSVParser;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.Charsets;

public class ExampleSetCSVInputStream
extends InputStream {
    private ExampleSet exampleSet;
    private Attribute[] attributes;
    private byte[] currentLine;
    private int currentLinePointer = 0;
    private Iterator<Example> exampleIterator;
    private DateFormat dateFormat = CSVParser.getDefaultFormat();

    public ExampleSetCSVInputStream(ExampleSet exampleSet) {
        this.exampleSet = exampleSet;
        this.exampleIterator = exampleSet.iterator();
        this.attributes = new Attribute[exampleSet.getAttributes().allSize()];
        Iterator allAttributes = exampleSet.getAttributes().allAttributes();
        int i = 0;
        while (allAttributes.hasNext()) {
            this.attributes[i++] = (Attribute)allAttributes.next();
        }
        this.currentLine = CSVParser.formatHeader(this.attributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
    }

    public ExampleSetCSVInputStream(ExampleSet exampleSet, List<Attribute> exportAttributes) {
        this.exampleSet = exampleSet;
        this.exampleIterator = exampleSet.iterator();
        this.attributes = exportAttributes.toArray(new Attribute[exportAttributes.size()]);
        this.currentLine = CSVParser.formatHeader(this.attributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
    }

    @Override
    public int read() throws IOException {
        if (this.currentLinePointer == this.currentLine.length) {
            if (!this.exampleIterator.hasNext()) {
                return -1;
            }
            Example example = this.exampleIterator.next();
            this.currentLine = CSVParser.formatExample(example, this.attributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
            this.currentLinePointer = 0;
        }
        return this.currentLine[this.currentLinePointer++];
    }

    @Override
    public synchronized void reset() throws IOException {
        this.currentLinePointer = 0;
        this.exampleIterator = this.exampleSet.iterator();
        this.currentLine = CSVParser.formatHeader(this.attributes, true, '\"', '\\', ",", this.dateFormat).getBytes(Charsets.UTF_8);
    }
}

