/*
 * Decompiled with CFR 0.152.
 */
package com.owc.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class VerifyingInputStream
extends InputStream {
    private static final int EOF = 4;
    private static final int ESCAPE = 0;
    private Signature signatureMethod;
    private InputStream inputStream;
    private boolean isSignatureVerfied = false;

    public VerifyingInputStream(InputStream output, PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(output, "SHA256withRSA", publicKey);
    }

    public VerifyingInputStream(InputStream inputStream, String signingMethod, PublicKey publicKey) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this(inputStream, signingMethod, publicKey, null);
    }

    public VerifyingInputStream(InputStream inputStream, String signingMethod, PublicKey publicKey, byte[] salt) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this.signatureMethod = Signature.getInstance(signingMethod);
        this.signatureMethod.initVerify(publicKey);
        if (salt != null) {
            this.signatureMethod.update(salt);
        }
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        int value = this.inputStream.read();
        if (value == 4) {
            value = this.inputStream.read();
            if (value != 4) {
                throw new IOException("Invalid byte stream");
            }
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            value = this.inputStream.read();
            while (value != -1) {
                byteBuffer.write(value);
                value = this.inputStream.read();
            }
            byte[] signature = byteBuffer.toByteArray();
            try {
                if (this.signatureMethod.verify(signature)) {
                    this.isSignatureVerfied = true;
                    return -1;
                }
                throw new IOException("Signature invalid.");
            }
            catch (SignatureException e) {
                throw new IOException("Signature verification failed due to error.", e);
            }
        }
        if (value == 0) {
            value = this.inputStream.read();
        }
        if (value == -1) {
            if (this.isSignatureVerfied) {
                return -1;
            }
            throw new IOException("Missing Signature");
        }
        try {
            this.signatureMethod.update((byte)value);
        }
        catch (SignatureException e) {
            throw new IOException("Signature calculation failed due to error.", e);
        }
        return value;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
        this.isSignatureVerfied = false;
        try {
            this.signatureMethod.verify(new byte[2]);
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
    }
}

