/*
 * Decompiled with CFR 0.152.
 */
package com.owc.license;

import com.owc.license.License;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Scanner;

public class LicenseGenerator {
    private static String[] products = new String[]{"rmx_toolkit", "rmx_statistics", "rmx_adv_reporting", "rmx_in_database", "rmx_solr_3", "rmx_webautomation"};

    public static void main(String[] args) throws FileNotFoundException, IOException, GeneralSecurityException {
        Scanner userInput = new Scanner(System.in);
        System.out.println("Available products:");
        Arrays.sort(products);
        for (int i = 1; i <= products.length; ++i) {
            System.out.println(i + ": " + products[i - 1]);
        }
        System.out.println("Please enter the number or name of the product you want to create a key for:");
        String productName = userInput.nextLine();
        try {
            productName = products[Integer.valueOf(productName) - 1];
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        System.out.println("Please enter a regular expression matching the email address of the licensee:");
        String emailAddress = userInput.nextLine();
        Date today = new Date();
        String todayString = License.DATE_FORMAT.format(today);
        System.out.println("Please enter a data as start of the validity period in the format yyyy-mm-dd. Empty will take today (" + todayString + ")");
        String startDate = null;
        boolean correctInput = false;
        while (!correctInput) {
            try {
                startDate = userInput.nextLine();
                if (startDate.trim().equals("")) {
                    startDate = todayString;
                }
                License.DATE_FORMAT.parse(startDate);
                correctInput = true;
            }
            catch (ParseException e) {
                System.out.println("Invalid Date Format. Please enter correct format.");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(1, 1);
        calendar.add(6, -1);
        Date nextYear = calendar.getTime();
        String nextYearString = License.DATE_FORMAT.format(nextYear);
        System.out.println("Please enter a data as end of the validity period in the format yyyy-mm-dd.\n - Empty will assume a validity period of one year until  (" + nextYearString + ")\n - To create a perpetual license, enter -");
        String endDate = null;
        correctInput = false;
        while (!correctInput) {
            try {
                endDate = userInput.nextLine();
                if (endDate.trim().equals("-")) {
                    endDate = "0000-01-01";
                }
                if (endDate.trim().equals("")) {
                    endDate = nextYearString;
                }
                License.DATE_FORMAT.parse(endDate);
                correctInput = true;
            }
            catch (ParseException e) {
                System.out.println("Invalid Date Format. Please enter correct format.");
            }
        }
        System.out.println("Please enter a data as end of the maintenance period in the format yyyy-mm-dd.\n - Empty will assume a maintenance period eqaul to  until  (" + endDate + ")");
        String maintenanceEdDate = null;
        correctInput = false;
        while (!correctInput) {
            try {
                maintenanceEdDate = userInput.nextLine();
                if (maintenanceEdDate.trim().equals("")) {
                    maintenanceEdDate = endDate;
                }
                License.DATE_FORMAT.parse(maintenanceEdDate);
                correctInput = true;
            }
            catch (ParseException e) {
                System.out.println("Invalid Date Format. Please enter correct format.");
            }
        }
        String fileName = productName + " - ";
        fileName = fileName + emailAddress.replaceAll("\\.\\*@", "Company License for ").replaceAll("@", " at ").replaceAll("\\.\\*", "Demo License");
        fileName = fileName + " with validity of " + startDate + " to " + endDate + " and maintenance until " + maintenanceEdDate;
        License license = new License(startDate, endDate, maintenanceEdDate, emailAddress, productName);
        String privateKeyFileName = args[0];
        FileInputStream privateKeyInputStream = new FileInputStream(privateKeyFileName);
        license.writeLicense(privateKeyInputStream, new FileOutputStream("./" + fileName));
    }

    public static void generateLicense(String productName, String emailLicensee, Date startDate, Date endDateSupport, Date endDateLicense, InputStream privateKeyStream, OutputStream targetStream) throws IOException, GeneralSecurityException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        License license = new License(dateFormat.format(startDate), dateFormat.format(endDateLicense), dateFormat.format(endDateSupport), emailLicensee, productName);
        license.writeLicense(privateKeyStream, targetStream);
    }
}

