/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.data.extraction;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.tools.ExampleSetCreator;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitAdvancedReportingExtension;
import com.rapidminer.gui.renderer.Renderer;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPortExtender;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.report.Reportable;
import com.rapidminer.report.Tableable;
import java.util.LinkedList;
import java.util.List;

public class ExtractTableableOperator
extends LicensedOperator {
    private InputPort inputPort = this.getInputPorts().createPort("input", IOObject.class);
    private OutputPortExtender outputPortExtender = new OutputPortExtender("example sets", (Ports)this.getOutputPorts());

    public ExtractTableableOperator(OperatorDescription description) {
        super(description);
        this.outputPortExtender.start();
        this.getTransformer().addRule(new MDTransformationRule(){

            public void transformMD() {
                LinkedList<ExampleSetMetaData> list = new LinkedList<ExampleSetMetaData>();
                for (int i = 0; i < 5; ++i) {
                    list.add(new ExampleSetMetaData());
                }
                ExtractTableableOperator.this.outputPortExtender.deliverMetaData(list);
            }
        });
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        if (!isLicensed) {
            throw new UserError((Operator)this, "toolkit.license_exceeded_functionality");
        }
        IOObject object = this.inputPort.getData(IOObject.class);
        List renderers = RendererService.getRenderers((IOObject)object);
        LinkedList<ExampleSet> results = new LinkedList<ExampleSet>();
        for (Renderer renderer : renderers) {
            Reportable reportable = renderer.createReportable((Object)object, new IOContainer(new IOObject[]{object}), 800, 600);
            if (!(reportable instanceof Tableable)) continue;
            Tableable table = (Tableable)reportable;
            String[] attributeNames = new String[table.getColumnNumber()];
            int[] attributeTypes = new int[table.getColumnNumber()];
            for (int i = 0; i < table.getColumnNumber(); ++i) {
                attributeNames[i] = table.getColumnName(i);
                attributeTypes[i] = 7;
            }
            ExampleSetCreator creator = new ExampleSetCreator(attributeNames, attributeTypes);
            for (int i = 0; i < table.getRowNumber(); ++i) {
                for (int j = 0; j < table.getColumnNumber(); ++j) {
                    try {
                        creator.setValue(attributeNames[j], table.getCell(i, j));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                creator.commit();
            }
            results.add(creator.finish());
        }
        this.outputPortExtender.deliver(results);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitAdvancedReportingExtension.PRODUCT_INFORMATION;
    }
}

