/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.reporting;

public class ExcelCellRange {
    private int columnOffset;
    private int rowOffset;
    private int numberOfRows;
    private int numberOfColumns;

    public ExcelCellRange(String range) throws IllegalArgumentException {
        String[] split = range.split(":", 2);
        int[] topLeft = ExcelCellRange.parseExcelCell(split[0]);
        this.columnOffset = topLeft[0];
        this.rowOffset = topLeft[1];
        if (this.rowOffset < 0) {
            throw new IllegalArgumentException("Start of Range must be defined for cell and row.");
        }
        if (split.length < 2) {
            this.numberOfRows = Integer.MAX_VALUE;
            this.numberOfColumns = Integer.MAX_VALUE;
        } else {
            int[] bottomRight = ExcelCellRange.parseExcelCell(split[1]);
            this.numberOfColumns = bottomRight[0] - this.columnOffset + 1;
            this.numberOfRows = bottomRight[1] - this.rowOffset + 1;
        }
        if (this.numberOfColumns < 1 || this.numberOfRows < 1) {
            throw new IllegalArgumentException("Cell Range may not be negative.");
        }
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public int getWidth() {
        return this.numberOfColumns;
    }

    public int getLength() {
        return this.numberOfRows;
    }

    public boolean isLengthLimited() {
        return this.numberOfRows < Integer.MAX_VALUE;
    }

    public boolean isWidthLimited() {
        return this.numberOfColumns < Integer.MAX_VALUE;
    }

    private static int[] parseExcelCell(String string) throws IllegalArgumentException {
        int i;
        int column = 0;
        int row = 0;
        for (i = 0; i < string.length() && Character.isLetter(string.charAt(i)); ++i) {
            char character = Character.toUpperCase(string.charAt(i));
            if (character < 'A' || character > 'Z') {
                throw new IllegalArgumentException("Invalid Character in Cell Range");
            }
            column *= 26;
            column += character - 65 + 1;
        }
        if (i < string.length()) {
            String columnStr = string.substring(i);
            try {
                row = Integer.parseInt(columnStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unreadable row index. Must be number.");
            }
        }
        return new int[]{column - 1, row - 1};
    }
}

