/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.reporting;

import com.owc.license.LicenseManager;
import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperatorChain;
import com.rapidminer.extension.PluginInitAdvancedReportingExtension;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.nio.file.BufferedFileObject;
import com.rapidminer.operator.nio.file.FileObject;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.Port;
import com.rapidminer.operator.ports.PortPairExtender;
import com.rapidminer.operator.ports.metadata.MDTransformationRule;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.ports.metadata.Precondition;
import com.rapidminer.operator.ports.metadata.SimplePrecondition;
import com.rapidminer.operator.ports.metadata.SubprocessTransformRule;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.PortProvider;
import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.parameter.conditions.PortConnectedCondition;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class OpenExcelReportOperator
extends LicensedOperatorChain {
    public static final String PARAMETER_EVALUATE_FORMULAS = "evaluate_formulas";
    public static String PARAMETER_FORMULAR_FILE = "form_template_file";
    public static String PARAMETER_TARGET_FILE = "target_file";
    private InputPort templateFileInputPort = (InputPort)this.getInputPorts().createPort("template excel file object");
    private PortPairExtender inputPairExtender = new PortPairExtender("input", this.getInputPorts(), this.getSubprocess(0).getInnerSources());
    private PortPairExtender outputPairExtender = new PortPairExtender("output", this.getSubprocess(0).getInnerSinks(), this.getOutputPorts());
    private OutputPort targetFileOutputPort = (OutputPort)this.getOutputPorts().createPort("target excel file object");
    private Workbook workbook;

    public OpenExcelReportOperator(OperatorDescription description) {
        super(description, "Reporting");
        this.templateFileInputPort.addPrecondition((Precondition)new SimplePrecondition(this.templateFileInputPort, new MetaData(FileObject.class), false));
        this.inputPairExtender.start();
        this.outputPairExtender.start();
        this.getTransformer().addRule(this.inputPairExtender.makePassThroughRule());
        this.getTransformer().addGenerationRule(this.targetFileOutputPort, FileObject.class);
        this.getTransformer().addRule((MDTransformationRule)new SubprocessTransformRule(this.getSubprocess(0)));
        this.getTransformer().addRule(this.outputPairExtender.makePassThroughRule());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        block40: {
            InputStream templateFileInputStream;
            if (this.templateFileInputPort.isConnected()) {
                templateFileInputStream = ((FileObject)this.templateFileInputPort.getData(FileObject.class)).openStream();
            } else {
                try {
                    templateFileInputStream = new FileInputStream(this.getParameterAsFile(PARAMETER_FORMULAR_FILE));
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{this.getParameterAsString(PARAMETER_FORMULAR_FILE)});
                }
            }
            try (Workbook workbook = WorkbookFactory.create((InputStream)templateFileInputStream);){
                this.workbook = workbook;
                try {
                    this.inputPairExtender.passCloneThrough();
                    this.getSubprocess(0).execute();
                    this.outputPairExtender.passCloneThrough();
                }
                finally {
                    this.workbook = null;
                }
                FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
                evaluator.clearAllCachedResultValues();
                if (this.getParameterAsBoolean(PARAMETER_EVALUATE_FORMULAS)) {
                    evaluator.evaluateAll();
                }
                if (this.targetFileOutputPort.isConnected()) {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    workbook.write((OutputStream)outputStream);
                    this.targetFileOutputPort.deliver((IOObject)new BufferedFileObject(outputStream.toByteArray()));
                    break block40;
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.getParameterAsFile(PARAMETER_TARGET_FILE)));){
                    workbook.write((OutputStream)outputStream);
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{this.getParameterAsString(PARAMETER_TARGET_FILE), e.getMessage()});
                }
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{this.getParameterAsString(PARAMETER_FORMULAR_FILE)});
            }
            catch (EncryptedDocumentException e) {
                throw new UserError((Operator)this, "reporting.encrypted_excel_file_not_supported");
            }
            catch (InvalidFormatException e) {
                throw new UserError((Operator)this, "reporting.invalid_excel_file");
            }
        }
    }

    public Workbook getWorkbook() throws UserError {
        Workbook workbook = this.workbook;
        if (workbook == null) {
            throw new UserError((Operator)this, "reporting.license_exceeded_functionality");
        }
        if (!LicenseManager.isLicenseValid("rmx_adv_reporting")) {
            this.workbook = null;
        }
        return workbook;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_FORMULAR_FILE, "The formular file that should be filled. All content will be preserved and the data written to the indicated area.", true, new String[]{"xls", "xlsx"});
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return OpenExcelReportOperator.this.templateFileInputPort;
            }
        }, true, false));
        types.add((ParameterType)type);
        type = new ParameterTypeFile(PARAMETER_TARGET_FILE, "The target file that will be written with the content from the form template and the filled in data.", true, new String[]{"xls", "xlsx"});
        type.setExpert(false);
        type.registerDependencyCondition((ParameterCondition)new PortConnectedCondition((ParameterHandler)this, new PortProvider(){

            public Port getPort() {
                return OpenExcelReportOperator.this.targetFileOutputPort;
            }
        }, true, false));
        types.add((ParameterType)type);
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_EVALUATE_FORMULAS, "If checked all formulas will be re-computed to reflect changed data. If you use unsupported formulas, you should disabled this and recompute in excel manually.", true));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitAdvancedReportingExtension.PRODUCT_INFORMATION;
    }
}

