/*
 * Decompiled with CFR 0.152.
 */
package com.owc.operator.reporting;

import com.owc.license.ProductInformation;
import com.owc.operator.LicensedOperator;
import com.owc.operator.reporting.ExcelCellRange;
import com.owc.operator.reporting.OpenExcelReportOperator;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.extension.PluginInitAdvancedReportingExtension;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.tools.AttributeSubsetSelector;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class WriteExcelReportEntryOperator
extends LicensedOperator {
    public static final String PARAMETER_FIT_TO_RANGE = "fit_to_range";
    public static final String PARAMETER_SHEET = "sheet";
    public static final String PARAMETER_FILL_RANGE = "fill_range";
    public static final String PARAMETER_IGNORE_NAMES = "ignore_names";
    private InputPort examplesetInputPort = this.getInputPorts().createPort("example set", ExampleSet.class);
    private OutputPort examplesetOutputPort = (OutputPort)this.getOutputPorts().createPort("exampe set");
    private AttributeSubsetSelector selector = new AttributeSubsetSelector((ParameterHandler)this, this.examplesetInputPort);

    public WriteExcelReportEntryOperator(OperatorDescription description) {
        super(description);
        this.getTransformer().addPassThroughRule(this.examplesetInputPort, this.examplesetOutputPort);
    }

    @Override
    public void doWork(boolean isLicensed) throws OperatorException {
        ExampleSet set = this.selector.getSubset((ExampleSet)this.examplesetInputPort.getData(ExampleSet.class), true);
        ExcelCellRange range = null;
        try {
            range = new ExcelCellRange(this.getParameterAsString(PARAMETER_FILL_RANGE));
        }
        catch (IllegalArgumentException e) {
            throw new UserError((Operator)this, (Throwable)e, "reporting.invalid_excel_range");
        }
        if (range.isLengthLimited() && range.getLength() < set.size() && !this.getParameterAsBoolean(PARAMETER_FIT_TO_RANGE)) {
            throw new UserError((Operator)this, "reporting.content_exceeds_range");
        }
        if (range.isWidthLimited() && range.getWidth() < set.getAttributes().allSize() && !this.getParameterAsBoolean(PARAMETER_FIT_TO_RANGE)) {
            throw new UserError((Operator)this, "reporting.content_exceeds_range");
        }
        int numberOfRows = Math.min(range.getLength(), set.size());
        int numberOfColumns = Math.min(range.getWidth(), set.getAttributes().allSize());
        Sheet sheet = this.getWorkbookFromParent().getSheetAt(this.getParameterAsInt(PARAMETER_SHEET) - 1);
        Attribute[] attributes = new Attribute[numberOfColumns];
        Iterator iterator = set.getAttributes().allAttributes();
        for (int j = 0; j < numberOfColumns; ++j) {
            attributes[j] = (Attribute)iterator.next();
        }
        int headerOffset = 0;
        if (!this.getParameterAsBoolean(PARAMETER_IGNORE_NAMES)) {
            Row row = sheet.getRow(range.getRowOffset());
            if (row == null) {
                row = sheet.createRow(range.getRowOffset());
            }
            headerOffset = 1;
            for (int j = 0; j < numberOfColumns; ++j) {
                Cell cell = row.getCell(j + range.getColumnOffset());
                if (cell == null) {
                    cell = row.createCell(j + range.getColumnOffset());
                }
                cell.setCellValue(attributes[j].getName());
            }
        }
        for (int i = headerOffset; i < numberOfRows + headerOffset; ++i) {
            Example example = set.getExample(i - headerOffset);
            Row row = sheet.getRow(i + range.getRowOffset());
            if (row == null) {
                row = sheet.createRow(i + range.getRowOffset());
            }
            for (int j = 0; j < numberOfColumns; ++j) {
                if (Double.isNaN(example.getValue(attributes[j]))) continue;
                Cell cell = row.getCell(j + range.getColumnOffset());
                if (cell == null) {
                    cell = row.createCell(j + range.getColumnOffset());
                }
                if (attributes[j].isNominal()) {
                    cell.setCellValue(example.getValueAsString(attributes[j]));
                    continue;
                }
                if (attributes[j].isNumerical()) {
                    cell.setCellValue(example.getValue(attributes[j]));
                    continue;
                }
                if (!attributes[j].isDateTime()) continue;
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTimeInMillis((long)example.getValue(attributes[j]));
                cell.setCellValue((Calendar)calendar);
            }
        }
        this.examplesetOutputPort.deliver(((ExampleSet)this.examplesetInputPort.getData(ExampleSet.class)).copy());
    }

    private Workbook getWorkbookFromParent() throws UserError {
        OperatorChain parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof OpenExcelReportOperator); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((OpenExcelReportOperator)parent).getWorkbook();
        }
        throw new UserError((Operator)this, "reporting.operator_misplaced");
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(this.selector.getParameterTypes());
        types.add((ParameterType)new ParameterTypeInt(PARAMETER_SHEET, "The index of the sheet, counting starts from 1.", 1, 256, 1, false));
        types.add((ParameterType)new ParameterTypeString(PARAMETER_FILL_RANGE, "Range where to fill in the data, e.g. B2:D25 or B2 for an open interval.", "A1"));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_FIT_TO_RANGE, "Check to automatically shorten the example set and drop rows or columns if the table exceeds the given range. If not checked and table exceeds the range, an error will be thrown.", false, false));
        types.add((ParameterType)new ParameterTypeBoolean(PARAMETER_IGNORE_NAMES, "If checked names of attributes will not be written into the first line.", true, false));
        return types;
    }

    @Override
    public ProductInformation getProductInformation() {
        return PluginInitAdvancedReportingExtension.PRODUCT_INFORMATION;
    }
}

