/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import java.time.ZoneId;
import java.util.Arrays;

public class DateTools {
    private static final String PARAMETER_TIMEZONE = "timezone";
    private static String[] zoneIDs = DateTools.getZoneIDs();
    private static int defaultTimeZone = DateTools.getDefaultZoneIndex();

    private static String[] getZoneIDs() {
        Object[] zoneArray = ZoneId.getAvailableZoneIds().toArray(new String[0]);
        Arrays.sort(zoneArray);
        return zoneArray;
    }

    public static ParameterType getZoneParameter() {
        return new ParameterTypeCategory(PARAMETER_TIMEZONE, "The timezone in which to operate. Important for leap hours and week computation.", zoneIDs, defaultTimeZone, false);
    }

    public static ZoneId evaluateZoneParameter(Operator operator) throws UserError {
        String zoneIDName = operator.getParameterAsString(PARAMETER_TIMEZONE);
        try {
            return ZoneId.of(zoneIDName);
        }
        catch (Exception e) {
            throw new UserError(operator, (Throwable)e, "unkown_zoneid", new Object[]{zoneIDName});
        }
    }

    private static int getDefaultZoneIndex() {
        return Arrays.binarySearch(zoneIDs, ZoneId.systemDefault().toString());
    }
}

