/*
 * Decompiled with CFR 0.152.
 */
package com.owc.tools;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.Ontology;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetAppender {
    private static void checkForCompatibility(List<ExampleSet> allExampleSets, Operator callee) throws OperatorException {
        ExampleSet first = allExampleSets.get(0);
        Iterator<ExampleSet> i = allExampleSets.iterator();
        while (i.hasNext()) {
            ExampleSetAppender.checkForCompatibility(first, i.next(), callee);
        }
    }

    private static void checkForCompatibility(ExampleSet first, ExampleSet second, Operator callee) throws OperatorException {
        if (first.getAttributes().allSize() != second.getAttributes().allSize()) {
            throw new UserError(callee, 925, new Object[]{"numbers of attributes are different"});
        }
        Iterator firstIterator = first.getAttributes().allAttributes();
        while (firstIterator.hasNext()) {
            Attribute firstAttribute = (Attribute)firstIterator.next();
            Attribute secondAttribute = second.getAttributes().get(firstAttribute.getName());
            if (secondAttribute != null) continue;
            throw new UserError(callee, 925, new Object[]{"Attribute with name '" + firstAttribute.getName() + "' is not part of second example set."});
        }
    }

    public static ExampleSet merge(List<ExampleSet> allExampleSets, Operator callee) throws OperatorException {
        if (allExampleSets.size() == 0) {
            throw new MissingIOObjectException(ExampleSet.class);
        }
        ExampleSetAppender.checkForCompatibility(allExampleSets, callee);
        ExampleSet firstSet = allExampleSets.get(0);
        LinkedList<Attribute> newAttributeList = new LinkedList<Attribute>();
        HashMap<String, Attribute> newAttributeNameMap = new HashMap<String, Attribute>();
        HashMap<Attribute, String> specialAttributesMap = new HashMap<Attribute, String>();
        Iterator a = firstSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            int newType;
            AttributeRole role = (AttributeRole)a.next();
            Attribute oldAttribute = role.getAttribute();
            if (oldAttribute.isNominal()) {
                HashSet values = new HashSet();
                values.addAll(oldAttribute.getMapping().getValues());
                boolean hasNominal = false;
                boolean hasPolynominal = false;
                boolean hasSameValueType = true;
                for (ExampleSet otherExampleSet : allExampleSets) {
                    Attribute otherAttribute = otherExampleSet.getAttributes().get(oldAttribute.getName());
                    if (!otherAttribute.isNominal()) {
                        ExampleSetAppender.throwIncompatible(oldAttribute, otherAttribute, callee);
                    }
                    values.addAll(otherAttribute.getMapping().getValues());
                    hasSameValueType &= otherAttribute.getValueType() == oldAttribute.getValueType();
                    hasNominal |= otherAttribute.getValueType() == 1;
                    hasPolynominal |= Ontology.ATTRIBUTE_VALUE_TYPE.isA(otherAttribute.getValueType(), 7);
                }
                newType = hasSameValueType && (!Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 6) || values.size() <= 2) ? oldAttribute.getValueType() : (hasNominal ? 1 : (hasPolynominal || values.size() > 2 ? 7 : oldAttribute.getValueType()));
            } else if (oldAttribute.isNumerical()) {
                boolean hasReal = false;
                boolean hasNumerical = false;
                boolean hasSameValueType = true;
                for (ExampleSet otherExampleSet : allExampleSets) {
                    Attribute otherAttribute = otherExampleSet.getAttributes().get(oldAttribute.getName());
                    if (!otherAttribute.isNumerical()) {
                        ExampleSetAppender.throwIncompatible(oldAttribute, otherAttribute, callee);
                    }
                    hasSameValueType &= otherAttribute.getValueType() == oldAttribute.getValueType();
                    hasNumerical |= otherAttribute.getValueType() == 2;
                    hasReal |= Ontology.ATTRIBUTE_VALUE_TYPE.isA(otherAttribute.getValueType(), 4);
                }
                newType = hasSameValueType ? oldAttribute.getValueType() : (hasNumerical ? 2 : (hasReal ? 4 : oldAttribute.getValueType()));
            } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 10) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 11) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 9)) {
                newType = oldAttribute.getValueType();
                for (ExampleSet otherExampleSet : allExampleSets) {
                    Attribute otherAttribute = otherExampleSet.getAttributes().get(oldAttribute.getName());
                    if (otherAttribute.getValueType() == newType) continue;
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 10) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 11) || Ontology.ATTRIBUTE_VALUE_TYPE.isA(oldAttribute.getValueType(), 9)) {
                        newType = 9;
                        continue;
                    }
                    ExampleSetAppender.throwIncompatible(oldAttribute, otherAttribute, callee);
                }
            } else {
                for (ExampleSet otherExampleSet : allExampleSets) {
                    Attribute otherAttribute = otherExampleSet.getAttributes().get(oldAttribute.getName());
                    if (otherAttribute.getValueType() == oldAttribute.getValueType()) continue;
                    ExampleSetAppender.throwIncompatible(oldAttribute, otherAttribute, callee);
                }
                newType = oldAttribute.getValueType();
            }
            Attribute newAttribute = AttributeFactory.createAttribute((String)oldAttribute.getName(), (int)newType, (int)oldAttribute.getBlockType());
            newAttributeNameMap.put(newAttribute.getName(), newAttribute);
            newAttributeList.add(newAttribute);
            if (!role.isSpecial()) continue;
            specialAttributesMap.put(newAttribute, role.getSpecialName());
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(newAttributeList);
        DataRowFactory factory = new DataRowFactory(0, '.');
        int numberOfAttributes = newAttributeList.size();
        for (ExampleSet exampleSet : allExampleSets) {
            for (Example example : exampleSet) {
                DataRow dataRow = factory.create(numberOfAttributes);
                Iterator iterator = exampleSet.getAttributes().allAttributes();
                while (iterator.hasNext()) {
                    Attribute oldAttribute = (Attribute)iterator.next();
                    Attribute newAttribute = (Attribute)newAttributeNameMap.get(oldAttribute.getName());
                    double oldValue = example.getValue(oldAttribute);
                    if (Double.isNaN(oldValue)) {
                        dataRow.set(newAttribute, oldValue);
                        continue;
                    }
                    if (oldAttribute.isNominal()) {
                        dataRow.set(newAttribute, (double)newAttribute.getMapping().mapString(oldAttribute.getMapping().mapIndex((int)oldValue)));
                        continue;
                    }
                    dataRow.set(newAttribute, oldValue);
                }
                exampleTable.addDataRow(dataRow);
            }
            callee.checkForStop();
        }
        ExampleSet resultSet = exampleTable.createExampleSet(specialAttributesMap);
        resultSet.getAnnotations().addAll(firstSet.getAnnotations());
        return resultSet;
    }

    private static void throwIncompatible(Attribute oldAttribute, Attribute otherAttribute, Operator callee) throws UserError {
        throw new UserError(callee, 925, new Object[]{"Attribute '" + oldAttribute.getName() + "' has incompatible types (" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(oldAttribute.getValueType()) + " and " + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(otherAttribute.getValueType()) + ") in two input sets."});
    }
}

