/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.actions;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.dialog.SaveCustomOperatorDialog;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.UserData;
import com.rapidminer.repository.BinaryEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.gui.OpenBinaryEntryCallback;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class OpenCustomOperatorCallback
implements OpenBinaryEntryCallback {
    public static final String KEY_CUSTOM_OPERATOR_LOCATION = "process_defined_operators.custom_operator_location";

    public void openEntry(final BinaryEntry entry) {
        if (!RapidMinerGUI.getMainFrame().close()) {
            return;
        }
        new ProgressThread("open_custom_operator"){

            public void run() {
                try (InputStream ins = entry.openInputStream();){
                    CustomOperatorTemplate template = new CustomOperatorTemplate(ins);
                    Process templateProcess = template.getProcess();
                    if (templateProcess == null) {
                        SwingTools.showVerySimpleErrorMessage((String)"cannot_load_custom_operator", (Object[])new Object[]{"Cannot load process"});
                    } else {
                        templateProcess.getRootOperator().setUserData(OpenCustomOperatorCallback.KEY_CUSTOM_OPERATOR_LOCATION, (UserData)new StringUserData(entry.getLocation().getAbsoluteLocation()));
                        RapidMinerGUI.getMainFrame().setOpenedProcess(templateProcess);
                    }
                    OpenCustomOperatorCallback.this.openDialog(templateProcess, template, entry.getLocation().getAbsoluteLocation());
                }
                catch (RepositoryException | XMLException | IOException | RuntimeException | SAXException e) {
                    SwingTools.showSimpleErrorMessage((String)"cannot_load_custom_operator", (Throwable)e, (Object[])new Object[]{e.getMessage()});
                }
            }
        }.start();
    }

    private void openDialog(Process templateProcess, CustomOperatorTemplate template, String location) {
        SwingTools.invokeLater(() -> {
            SaveCustomOperatorDialog dialog = new SaveCustomOperatorDialog(templateProcess);
            dialog.reloadFromTemplate(template, location);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                try {
                    dialog.getTemplate().saveAsCustomOperator(templateProcess, dialog.getSaveLocation());
                }
                catch (Exception ioe) {
                    SwingTools.showSimpleErrorMessage((String)"cannot_write_template_file", (Throwable)ioe, (Object[])new Object[0]);
                }
            }
        });
    }

    public static class StringUserData
    implements UserData<Object> {
        private final String value;

        public StringUserData(String value) {
            this.value = value;
        }

        public UserData<Object> copyUserData(Object newParent) {
            return this;
        }

        public String getValue() {
            return this.value;
        }
    }
}

