/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.dialog;

import com.rapidminer.extension.processdefined.browser.BrowserPanel;
import com.rapidminer.extension.processdefined.browser.CallbackAdapter;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.extension.processdefined.extension.ExtensionInfo;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.celleditors.value.ColorValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.SimpleFileValueCellEditor;
import com.rapidminer.gui.tools.MultiSwingWorker;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.LinkRemoteButton;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RMUrlHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CreateCustomExtensionDialog
extends ButtonDialog {
    private static final String ICON_LINK = I18N.getGUILabel((String)"process_defined_operators.icon_search.url", (Object[])new Object[0]);
    private static final Action ICON_ACTION = new ResourceAction("process_defined_operators.icon_search", new Object[0]){
        private static final long serialVersionUID = 1L;

        public void loggedActionPerformed(ActionEvent e) {
            RMUrlHandler.openInBrowser((String)ICON_LINK);
        }
    };
    private static final long serialVersionUID = -4892200177390173103L;
    private static final Pattern VALID_NAME = Pattern.compile("[A-Za-z0-9 ]*");
    private static final Dimension DIMENSION_MESSAGE_EXTENDED_EXTENDED = new Dimension(600, 540);
    private final JTextField nameField = new JTextField();
    private final JTextField vendorField = new JTextField();
    private final JTextField homepageField = new JTextField();
    private final JTextField versionNumber = new JTextField();
    private final RepoLocationWithAccess folder = new RepoLocationWithAccess();
    private final RepoLocationWithAccess ioobjectsFolder = new RepoLocationWithAccess();
    private final ColorValueCellEditor color = new ColorValueCellEditor(new ParameterTypeColor("", "", Color.WHITE));
    private final JCheckBox dependenciesCheckbox = new JCheckBox();
    private final JCheckBox hideProcessesCheckbox = new JCheckBox();
    private final JTextField iconField = new JTextField();
    private final FolderLocationWithAccess jarsFolder = new FolderLocationWithAccess();
    private final FolderLocationWithAccess iconsFolder = new FolderLocationWithAccess();
    private List<String> orderedFiles;
    private final transient Action openAction = new ResourceAction(true, "process_defined_operators.reload_extension_info", new Object[0]){
        private static final long serialVersionUID = 1L;

        public void loggedActionPerformed(ActionEvent e) {
            CreateCustomExtensionDialog.this.loadSettingsWithWorker(null);
        }
    };
    private final transient Action loadFileAction = new ResourceAction(true, "process_defined_operators.load_extension_info_file", new Object[0]){
        private static final long serialVersionUID = 1L;

        public void loggedActionPerformed(ActionEvent e) {
            CreateCustomExtensionDialog.this.loadFromFile();
        }
    };
    private final JPanel containerPanel = new JPanel(new BorderLayout());
    private transient CallbackAdapter order = null;
    private BrowserPanel browserPanel = null;

    public CreateCustomExtensionDialog() {
        super((Window)ApplicationFrame.getApplicationFrame(), "create_custom_extension", Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        JPanel panel = this.createOverviewPanel();
        JButton nextButton = new JButton();
        JButton previousButton = new JButton();
        this.setupNextButton(nextButton, previousButton);
        this.setupPreviousButton(nextButton, previousButton);
        JButton okButton = this.makeOkButton();
        this.containerPanel.add((Component)panel, "Center");
        this.layoutDefault(this.containerPanel, 5, new AbstractButton[]{previousButton, nextButton, okButton, this.makeCancelButton()});
        this.setPreferredSize(DIMENSION_MESSAGE_EXTENDED_EXTENDED);
        this.revalidate();
        this.pack();
        this.setDefaultLocation();
        this.getRootPane().setDefaultButton(okButton);
    }

    public void loadFromFile(String location) {
        File selectedFile;
        Path path = RepositoryUtils.locationToCusopPath((String)location);
        File file = selectedFile = path != null ? path.toFile() : null;
        if (selectedFile == null || !selectedFile.exists()) {
            SwingTools.showVerySimpleErrorMessage((String)"process_defined_operators.no_extension_file", (Object[])new Object[0]);
            return;
        }
        this.loadSettingsWithWorker(path);
    }

    public void dispose() {
        super.dispose();
        if (this.browserPanel != null) {
            this.browserPanel.dispose();
        }
    }

    protected void cancel() {
        this.dispose();
    }

    protected void ok() {
        if (this.checkIfNameOk()) {
            this.dispose();
            this.createAndStoreSettings();
        }
    }

    private JPanel createOverviewPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        ResourceLabel label = new ResourceLabel("custom_extension.name", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.nameField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.nameField.setToolTipText(label.getToolTipText());
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.nameField, "Center");
        JButton openButton = new JButton(this.openAction);
        JButton loadButton = new JButton(this.loadFileAction);
        JPanel wrapper2 = new JPanel(new BorderLayout());
        JPanel wrapper3 = new JPanel(new BorderLayout());
        wrapper3.add((Component)loadButton, "East");
        wrapper3.add(Box.createHorizontalStrut(2), "Center");
        wrapper2.add((Component)wrapper3, "East");
        wrapper2.add((Component)openButton, "Center");
        wrapper2.add(Box.createHorizontalStrut(10), "West");
        wrapper.add((Component)wrapper2, "East");
        panel.add((Component)wrapper, c);
        label = new ResourceLabel("custom_extension.vendor", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.vendorField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.vendorField.setToolTipText(label.getToolTipText());
        panel.add((Component)this.vendorField, c);
        label = new ResourceLabel("custom_extension.homepage", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.homepageField);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.homepageField.setToolTipText(label.getToolTipText());
        panel.add((Component)this.homepageField, c);
        label = new ResourceLabel("custom_extension.version", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.versionNumber);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.versionNumber.setText("1.0.0");
        this.versionNumber.setToolTipText(label.getToolTipText());
        panel.add((Component)this.versionNumber, c);
        label = new ResourceLabel("custom_extension.folder", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        String folderValue = (String)this.folder.getCellEditorValue();
        panel.add(this.folder.getTableCellEditorComponent(null, null, false, 0, 0), c);
        if (folderValue != null) {
            this.folder.setText(folderValue);
        }
        label = new ResourceLabel("custom_extension.color", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        String colorValue = null;
        try {
            colorValue = (String)this.color.getCellEditorValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        panel.add(this.color.getTableCellEditorComponent(null, null, false, 0, 0), c);
        if (colorValue != null) {
            this.color.setEditorColor(ParameterTypeColor.string2Color((String)colorValue));
        }
        label = new ResourceLabel("bundled_ioobjects.folder", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        String ioobjectsValue = (String)this.ioobjectsFolder.getCellEditorValue();
        panel.add(this.ioobjectsFolder.getTableCellEditorComponent(null, null, false, 0, 0), c);
        if (ioobjectsValue != null) {
            this.ioobjectsFolder.setText(ioobjectsValue);
        }
        label = new ResourceLabel("custom_extension.jars_folder", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        String jarsValue = (String)this.jarsFolder.getCellEditorValue();
        panel.add(this.jarsFolder.getTableCellEditorComponent(null, null, false, 0, 0), c);
        if (jarsValue != null) {
            this.jarsFolder.setText(jarsValue);
        }
        label = new ResourceLabel("custom_extension.calculate_dependencies", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.dependenciesCheckbox.setToolTipText(label.getToolTipText());
        panel.add((Component)this.dependenciesCheckbox, c);
        label = new ResourceLabel("custom_extension.extension_icon", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        LinkRemoteButton iconLink = new LinkRemoteButton(ICON_ACTION);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this.iconField, "Center");
        container.add((Component)iconLink, "East");
        panel.add((Component)container, c);
        label = new ResourceLabel("custom_extension.icons_folder", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        String iconsValue = (String)this.iconsFolder.getCellEditorValue();
        panel.add(this.iconsFolder.getTableCellEditorComponent(null, null, false, 0, 0), c);
        if (iconsValue != null) {
            this.iconsFolder.setText(iconsValue);
        }
        label = new ResourceLabel("custom_extension.hide_processes", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.hideProcessesCheckbox.setToolTipText(label.getToolTipText());
        panel.add((Component)this.hideProcessesCheckbox, c);
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JPanel(new BorderLayout()), c);
        return panel;
    }

    private boolean checkIfNameOk() {
        String name = this.nameField.getText();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.no_extension_name", (Object[])new Object[0]);
            return false;
        }
        if (!VALID_NAME.matcher(name).matches()) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_extension_name", (Object[])new Object[0]);
            return false;
        }
        String objectsFolderName = (String)this.ioobjectsFolder.getCellEditorValue();
        if (objectsFolderName != null && !objectsFolderName.isEmpty() && !RepositoryUtils.checkFolder((String)objectsFolderName)) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_ioobjects_folder", (Object[])new Object[0]);
            return false;
        }
        String folderName = (String)this.folder.getCellEditorValue();
        if ((folderName == null || folderName.isEmpty()) && objectsFolderName != null && !objectsFolderName.isEmpty()) {
            LogService.getRoot().log(Level.INFO, "No Custom operator folder but Repository folder is present.");
        } else if (folderName == null || folderName.isEmpty() || !RepositoryUtils.checkFolder((String)folderName)) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_cusop_folder", (Object[])new Object[0]);
            return false;
        }
        String jarsFolderName = (String)this.jarsFolder.getCellEditorValue();
        if (jarsFolderName != null && !jarsFolderName.isEmpty() && !ExtensionCreationHelper.isFolder(jarsFolderName)) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_jars_folder", (Object[])new Object[0]);
            return false;
        }
        String iconsFolderName = (String)this.iconsFolder.getCellEditorValue();
        if (iconsFolderName != null && !iconsFolderName.isEmpty() && !ExtensionCreationHelper.isFolder(iconsFolderName)) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_icons_folder", (Object[])new Object[0]);
            return false;
        }
        if (folderName != null && !folderName.isEmpty()) {
            return ExtensionCreationHelper.checkCustomOpPath(RepositoryUtils.locationToFolderPath((String)folderName));
        }
        return true;
    }

    private void createExtension(final List<String> orderedFiles) {
        ProgressThread progressThread = new ProgressThread("create_custom_extension"){

            public void run() {
                ExtensionCreator.CreationError error = new ExtensionCreator(CreateCustomExtensionDialog.this.vendorField.getText(), CreateCustomExtensionDialog.this.homepageField.getText(), RepositoryUtils.locationToFolderPath((String)((String)CreateCustomExtensionDialog.this.folder.getCellEditorValue())), ParameterTypeColor.string2Color((String)((String)CreateCustomExtensionDialog.this.color.getCellEditorValue())), CreateCustomExtensionDialog.this.versionNumber.getText(), RepositoryUtils.locationToFolderPath((String)((String)CreateCustomExtensionDialog.this.ioobjectsFolder.getCellEditorValue())), CreateCustomExtensionDialog.this.getDefinedPath(CreateCustomExtensionDialog.this.jarsFolder), CreateCustomExtensionDialog.this.iconField.getText(), CreateCustomExtensionDialog.this.getDefinedPath(CreateCustomExtensionDialog.this.iconsFolder)).createExtension(CreateCustomExtensionDialog.this.nameField.getText(), orderedFiles, CreateCustomExtensionDialog.this.dependenciesCheckbox.isSelected(), CreateCustomExtensionDialog.this.hideProcessesCheckbox.isSelected(), this.getProgressListener());
                new ExtensionCreationHelper(CreateCustomExtensionDialog.this.nameField.getText(), CreateCustomExtensionDialog.this.versionNumber.getText()).handleCreationResult(error);
            }
        };
        progressThread.setStartDialogShowTimer(true);
        progressThread.start();
    }

    private void copyInfo(ExtensionInfo infoStorer) {
        this.nameField.setText(infoStorer.getName());
        this.vendorField.setText(infoStorer.getVendor());
        this.homepageField.setText(infoStorer.getHomepage());
        this.folder.setText(infoStorer.getFolder());
        this.ioobjectsFolder.setText(infoStorer.getIoobjectsFolder());
        this.color.setEditorColor(ExtensionCreationHelper.transformString2Color(infoStorer.getColor()));
        this.versionNumber.setText(infoStorer.getVersionNumber());
        this.jarsFolder.setText(infoStorer.getOptionalJars());
        this.iconsFolder.setText(infoStorer.getAdditionalIcons());
        this.dependenciesCheckbox.setSelected(infoStorer.isCalculateDependencies());
        this.iconField.setText(infoStorer.getIcon());
        this.hideProcessesCheckbox.setSelected(infoStorer.isHideProcesses());
        this.orderedFiles = infoStorer.getOrderedFiles();
    }

    private void storeExtensionSettings(final List<String> orderedFiles) {
        ProgressThread progressThread = new ProgressThread("store_custom_extension_settings", false){

            public void run() {
                new ExtensionInfo(CreateCustomExtensionDialog.this.nameField.getText(), CreateCustomExtensionDialog.this.vendorField.getText(), CreateCustomExtensionDialog.this.homepageField.getText(), (String)CreateCustomExtensionDialog.this.folder.getCellEditorValue(), (String)CreateCustomExtensionDialog.this.ioobjectsFolder.getCellEditorValue(), (String)CreateCustomExtensionDialog.this.color.getCellEditorValue(), CreateCustomExtensionDialog.this.versionNumber.getText(), (String)CreateCustomExtensionDialog.this.jarsFolder.getCellEditorValue(), (String)CreateCustomExtensionDialog.this.iconsFolder.getCellEditorValue(), CreateCustomExtensionDialog.this.dependenciesCheckbox.isSelected(), CreateCustomExtensionDialog.this.iconField.getText(), CreateCustomExtensionDialog.this.hideProcessesCheckbox.isSelected(), orderedFiles).store();
            }
        };
        progressThread.start();
    }

    private void loadFromFile() {
        String selectLocation = RepositoryLocationChooser.selectLocation(null, null, (Component)RapidMinerGUI.getMainFrame(), (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (Predicate)RepositoryUtils.CUSTOM_EXTENSION_FILTER, (String)"process_defined_operators.reload_from_definition");
        if (StringUtils.trimToNull((String)selectLocation) == null) {
            return;
        }
        this.loadFromFile(selectLocation);
    }

    private void loadSettingsWithWorker(final Path path) {
        new MultiSwingWorker<ExtensionInfo, Void>(){

            protected ExtensionInfo doInBackground() throws Exception {
                ExtensionInfo infoStorer = new ExtensionInfo();
                if (path == null) {
                    infoStorer.reload();
                } else {
                    infoStorer.reload(path.toFile());
                }
                return infoStorer;
            }

            protected void done() {
                try {
                    ExtensionInfo info = (ExtensionInfo)this.get();
                    CreateCustomExtensionDialog.this.copyInfo(info);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SwingTools.showVerySimpleErrorMessage((String)(path == null ? "custom_extension.reload_file_failed" : "custom_extension.load_file_failed"), (Object[])new Object[]{e.getMessage()});
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof SAXException) {
                        SwingTools.showVerySimpleErrorMessage((String)(path == null ? "custom_extension.reload_parse_failed" : "custom_extension.load_parse_failed"), (Object[])new Object[]{e.getCause().getMessage()});
                    }
                    SwingTools.showVerySimpleErrorMessage((String)(path == null ? "custom_extension.reload_file_failed" : "custom_extension.load_file_failed"), (Object[])new Object[]{e.getCause().getMessage()});
                }
            }
        }.start();
    }

    private Path getDefinedPath(FolderLocationWithAccess location) {
        String folderName = (String)location.getCellEditorValue();
        if (folderName == null || folderName.isEmpty()) {
            return null;
        }
        try {
            return Paths.get(folderName, new String[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setupNextButton(final JButton nextButton, final JButton previousButton) {
        ResourceAction nextAction = new ResourceAction("custom_extension.create_dialog_next", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                if (CreateCustomExtensionDialog.this.checkIfNameOk()) {
                    CreateCustomExtensionDialog.this.goToNext();
                    nextButton.setEnabled(false);
                    previousButton.setEnabled(true);
                }
            }
        };
        nextButton.setAction((Action)nextAction);
    }

    private void setupPreviousButton(final JButton nextButton, final JButton previousButton) {
        ResourceAction previousAction = new ResourceAction("custom_extension.create_dialog_previous", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                CreateCustomExtensionDialog.this.goToPrevious();
                previousButton.setEnabled(false);
                nextButton.setEnabled(true);
            }
        };
        previousButton.setAction((Action)previousAction);
        previousButton.setEnabled(false);
    }

    private void goToPrevious() {
        this.containerPanel.removeAll();
        if (this.browserPanel != null) {
            this.browserPanel.dispose();
            this.browserPanel = null;
        }
        this.containerPanel.add(this.createOverviewPanel());
        this.revalidate();
        this.repaint();
    }

    private void goToNext() {
        this.containerPanel.removeAll();
        this.browserPanel = new BrowserPanel(this.createOrderCallback(), "com/rapidminer/extension/resources/generated/js/operators.html");
        this.containerPanel.add(this.browserPanel);
        this.revalidate();
        this.repaint();
    }

    private CallbackAdapter createOrderCallback() {
        this.order = new CallbackAdapter(() -> ExtensionCreationHelper.getCusopsFrom(RepositoryUtils.locationToFolderPath((String)((String)this.folder.getCellEditorValue())), this.orderedFiles));
        return this.order;
    }

    private void createAndStoreSettings() {
        List<String> orderedFiles = Collections.emptyList();
        if (this.order != null) {
            List<Object[]> values = this.order.getValues();
            if (values != null && (values.size() != 1 || values.get(0)[1] != null)) {
                orderedFiles = new ArrayList<String>(values.size());
                for (Object[] value : values) {
                    orderedFiles.add((String)value[1]);
                }
            }
        } else if (this.orderedFiles != null) {
            orderedFiles = this.orderedFiles;
        }
        this.createExtension(orderedFiles);
        this.storeExtensionSettings(orderedFiles);
    }

    private final class FolderLocationWithAccess
    extends SimpleFileValueCellEditor {
        private FolderLocationWithAccess() {
            super((ParameterTypeFile)new ParameterTypeDirectory("", "", true));
        }

        public void setText(String file) {
            super.setText(new File(file));
        }
    }

    private final class RepoLocationWithAccess
    extends RepositoryLocationValueCellEditor {
        private RepoLocationWithAccess() {
            super(new ParameterTypeRepositoryLocation("", "", false, true, true, false, false));
        }

        protected Predicate<Entry> getRepositoryFilter() {
            return RepositoryUtils.FILESYSTEM_REPOS_FILTER;
        }

        public void setText(String text) {
            super.getTextField().setText(text);
        }
    }
}

