/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.dialog;

import com.rapidminer.Process;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.actions.OpenCustomOperatorCallback;
import com.rapidminer.extension.processdefined.browser.BrowserPanel;
import com.rapidminer.extension.processdefined.browser.CallbackAdapter;
import com.rapidminer.extension.processdefined.dialog.DocuPanel;
import com.rapidminer.extension.processdefined.dialog.OverviewPanel;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.extension.processdefined.util.DocuInfos;
import com.rapidminer.extension.processdefined.util.PortInfo;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.ApplicationFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.tools.MultiSwingWorker;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.UserData;
import com.rapidminer.operator.ports.Ports;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.container.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.lang3.StringUtils;

public class SaveCustomOperatorDialog
extends ButtonDialog {
    private static final long serialVersionUID = -4892200177390173103L;
    private static final byte INDEX_FOR_EXPERT = 2;
    private static final byte INDEX_FOR_OPTIONAL = 0;
    private static final byte INDEX_FOR_MANDATORY = 1;
    private static final Pattern PORT_PATTERN = Pattern.compile("^[a-z]{2}$|^[a-z]{3}$|^[a-z]{3}[a-z ]*\\d*[^ ]$");
    private final transient Action openAction = new ResourceAction(true, "process_defined_operators.reload", new Object[0]){
        private static final long serialVersionUID = 1L;

        public void loggedActionPerformed(ActionEvent e) {
            SaveCustomOperatorDialog.this.loadFromFile();
        }
    };
    private boolean ok = false;
    private final transient DocuInfos docuInfos = new DocuInfos(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    private final transient Pair<List<String>, List<String>> portNames = new Pair(new ArrayList(), new ArrayList());
    private final JTextArea synopsisField = new JTextArea(1, 40);
    private final JTextArea descriptionField = new JTextArea(2, 40);
    private final JPanel containerPanel = new JPanel(new BorderLayout());
    private transient CallbackAdapter order = null;
    private BrowserPanel browserPanel = null;
    private final OverviewPanel overviewPanel;
    private State currentState = State.OVERVIEW;
    private String originalLocation;
    private final JButton saveInLocationButton;
    private boolean useOriginalLocation = false;
    private final String defaultLocation;

    public SaveCustomOperatorDialog(Process process) {
        super((Window)ApplicationFrame.getApplicationFrame(), "save_as_template", Dialog.ModalityType.APPLICATION_MODAL, new Object[0]);
        this.overviewPanel = new OverviewPanel(process, this.openAction);
        UserData locationUserData = process.getRootOperator().getUserData("process_defined_operators.custom_operator_location");
        this.defaultLocation = locationUserData instanceof OpenCustomOperatorCallback.StringUserData ? ((OpenCustomOperatorCallback.StringUserData)locationUserData).getValue() : null;
        PortInfo.createPortInfos((Ports)process.getRootOperator().getSubprocess(0).getInnerSources(), (List)this.docuInfos.getInputPortInfos(), (List)((List)this.portNames.getFirst()));
        PortInfo.createPortInfos((Ports)process.getRootOperator().getSubprocess(0).getInnerSinks(), (List)this.docuInfos.getOutputPortInfos(), (List)((List)this.portNames.getSecond()));
        JButton previousButton = new JButton();
        JButton nextButton = new JButton();
        this.saveInLocationButton = new JButton();
        this.setupButtons(previousButton, nextButton, this.saveInLocationButton);
        JButton okButton = this.makeOkButton("save_as_template_dialog_save_as");
        this.containerPanel.add((Component)this.overviewPanel, "Center");
        this.layoutDefault(this.containerPanel, 11, new AbstractButton[]{previousButton, nextButton, this.saveInLocationButton, okButton, this.makeCancelButton()});
        this.getRootPane().setDefaultButton(okButton);
    }

    private void setupButtons(final JButton previousButton, final JButton nextButton, JButton saveButton) {
        ResourceAction prevAction = new ResourceAction("save_as_template_dialog_previous", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                SaveCustomOperatorDialog.this.goToPrevious(previousButton, nextButton);
            }
        };
        previousButton.setAction((Action)prevAction);
        previousButton.setEnabled(false);
        ResourceAction nextAction = new ResourceAction("save_as_template_dialog_next", new Object[0]){
            private static final long serialVersionUID = 1L;

            public void loggedActionPerformed(ActionEvent e) {
                SaveCustomOperatorDialog.this.goToNext(nextButton, previousButton);
            }
        };
        nextButton.setAction((Action)nextAction);
        ResourceAction saveAction = new ResourceAction("save_as_template_dialog_save", new Object[0]){

            protected void loggedActionPerformed(ActionEvent e) {
                SaveCustomOperatorDialog.this.useOriginalLocation = true;
                SaveCustomOperatorDialog.this.ok();
            }
        };
        saveButton.setAction((Action)saveAction);
        saveButton.setEnabled(false);
    }

    private void goToPrevious(JButton button, JButton nextButton) {
        this.containerPanel.removeAll();
        switch (this.currentState) {
            case PARAMETERS: {
                if (this.browserPanel != null) {
                    this.browserPanel.dispose();
                    this.browserPanel = null;
                }
                this.containerPanel.add(this.overviewPanel);
                this.currentState = State.OVERVIEW;
                button.setEnabled(false);
                button.setToolTipText("");
                nextButton.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.parameters", (Object[])new Object[0]));
                break;
            }
            case DOCU: {
                this.containerPanel.add(this.browserPanel);
                this.currentState = State.PARAMETERS;
                nextButton.setEnabled(true);
                nextButton.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.docu", (Object[])new Object[0]));
                button.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.overview", (Object[])new Object[0]));
                break;
            }
            default: {
                throw new AssertionError((Object)"should not be called");
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void goToNext(JButton button, JButton previousButton) {
        this.containerPanel.removeAll();
        switch (this.currentState) {
            case OVERVIEW: {
                this.browserPanel = new BrowserPanel(this.createOrderCallback(), "com/rapidminer/extension/resources/generated/js/parameters.html");
                this.containerPanel.add(this.browserPanel);
                this.currentState = State.PARAMETERS;
                button.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.docu", (Object[])new Object[0]));
                previousButton.setEnabled(true);
                previousButton.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.overview", (Object[])new Object[0]));
                break;
            }
            case PARAMETERS: {
                this.containerPanel.add(new DocuPanel(this.docuInfos, this.portNames, this.synopsisField, this.descriptionField));
                button.setEnabled(false);
                button.setToolTipText("");
                this.currentState = State.DOCU;
                previousButton.setToolTipText(I18N.getGUILabel((String)"save_as_template_dialog.parameters", (Object[])new Object[0]));
                break;
            }
            default: {
                throw new AssertionError((Object)"should not be called");
            }
        }
        this.revalidate();
        this.repaint();
    }

    private CallbackAdapter createOrderCallback() {
        Set<CustomParameterInfo> selectedParameters = this.overviewPanel.getSelectedParameters();
        ArrayList<Object[]> params = new ArrayList<Object[]>(selectedParameters.size());
        for (CustomParameterInfo customParameterInfo : selectedParameters) {
            Pair dependency = customParameterInfo.getDependency();
            int paramState = customParameterInfo.isExpert() ? 2 : (customParameterInfo.isOptional() ? 0 : 1);
            params.add(new Object[]{customParameterInfo.getAlias(), paramState, dependency != null ? dependency.getFirst() : null, dependency != null ? dependency.getSecond() : null});
        }
        this.order = new CallbackAdapter(params);
        return this.order;
    }

    void loadFromFile() {
        File selectedFile;
        final String selectLocation = RepositoryLocationChooser.selectLocation(null, (String)this.defaultLocation, (Component)RapidMinerGUI.getMainFrame(), (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (Predicate)RepositoryUtils.CUSTOM_OPERATORS_FILTER, (String)"process_defined_operators.reload_from_file");
        if (StringUtils.trimToNull((String)selectLocation) == null) {
            return;
        }
        Path path = RepositoryUtils.locationToCusopPath((String)selectLocation);
        File file = selectedFile = path != null ? path.toFile() : null;
        if (selectedFile == null || !selectedFile.exists()) {
            SwingTools.showVerySimpleErrorMessage((String)"process_defined_operators.no_file", (Object[])new Object[0]);
            return;
        }
        new MultiSwingWorker<CustomOperatorTemplate, Void>(){

            protected CustomOperatorTemplate doInBackground() throws Exception {
                return new CustomOperatorTemplate((InputStream)new FileInputStream(selectedFile));
            }

            protected void done() {
                try {
                    CustomOperatorTemplate template = (CustomOperatorTemplate)this.get();
                    SaveCustomOperatorDialog.this.reloadFromTemplate(template, selectLocation);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SwingTools.showSimpleErrorMessage((String)"process_defined_operators.file_open_failed", (Throwable)e, (Object[])new Object[0]);
                }
                catch (ExecutionException e) {
                    SwingTools.showSimpleErrorMessage((String)"process_defined_operators.file_open_failed", (Throwable)e.getCause(), (Object[])new Object[0]);
                }
            }
        }.start();
    }

    public void reloadFromTemplate(CustomOperatorTemplate template, String originalLocation) {
        this.originalLocation = originalLocation;
        this.saveInLocationButton.setEnabled(true);
        this.overviewPanel.setDefinedName(template.getName());
        this.overviewPanel.setIconName(template.getIcon().replace(".png", ""));
        this.overviewPanel.setColor(template.getColor());
        this.synopsisField.setText(template.getSynopsis());
        this.descriptionField.setText(template.getDescription());
        CustomModuleUtils.CustomOperatorType customOperatorType = template.getCustomOperatorType();
        if (!customOperatorType.equals((Object)CustomModuleUtils.CustomOperatorType.STANDARD)) {
            if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
                LogService.getRoot().warning("Reloading custom operator definition of type: " + customOperatorType + ", but data structure extension is not available. Only a standard custom operator will be created");
                customOperatorType = CustomModuleUtils.CustomOperatorType.STANDARD;
            } else {
                RepositoryLocationValueCellEditor cellEditor;
                for (Map.Entry entry : template.getInputPortSchemaMap().entrySet()) {
                    cellEditor = this.overviewPanel.getInputPortSchemaEditors().get(entry.getKey());
                    if (cellEditor == null) continue;
                    cellEditor.getTableCellEditorComponent(null, entry.getValue(), false, 0, 0);
                }
                for (Map.Entry entry : template.getOutputPortVisConfigMap().entrySet()) {
                    cellEditor = this.overviewPanel.getOutputPortsVisConfigEditors().get(entry.getKey());
                    if (cellEditor == null) continue;
                    cellEditor.getTableCellEditorComponent(null, entry.getValue(), false, 0, 0);
                }
            }
        }
        this.overviewPanel.setCustomOperatorType(customOperatorType);
        Collection parameters = template.getParameters();
        HashMap<String, Map<String, CustomParameterInfo>> templateParameters = new HashMap<String, Map<String, CustomParameterInfo>>();
        HashMap<Pair<String, String>, Integer> sortingMap = new HashMap<Pair<String, String>, Integer>();
        int index = 0;
        for (CustomParameterInfo customParameterInfo : parameters) {
            Map stringInfoMap = templateParameters.computeIfAbsent(customParameterInfo.getOperator(), k -> new HashMap());
            stringInfoMap.put(customParameterInfo.getParameter(), customParameterInfo);
            sortingMap.put((Pair<String, String>)new Pair((Object)customParameterInfo.getOperator(), (Object)customParameterInfo.getParameter()), index++);
        }
        this.overviewPanel.loadSelectedParameters(template, templateParameters, sortingMap);
        DocuInfos storedDocuInfos = template.getDocuInfos();
        Pair storedPortNames = new Pair((Object)template.getInputPortNames(), (Object)template.getOutputPortNames());
        this.loadStoredPorts(storedDocuInfos, (Pair<List<String>, List<String>>)storedPortNames, true);
        this.loadStoredPorts(storedDocuInfos, (Pair<List<String>, List<String>>)storedPortNames, false);
        this.docuInfos.getTutorialInfos().clear();
        this.docuInfos.getTutorialInfos().addAll(storedDocuInfos.getTutorialInfos());
        this.docuInfos.getTags().clear();
        this.docuInfos.getTags().addAll(storedDocuInfos.getTags());
    }

    private void loadStoredPorts(DocuInfos storedDocuInfos, Pair<List<String>, List<String>> storedPortNames, boolean input) {
        List storedPorts = input ? storedDocuInfos.getInputPortInfos() : storedDocuInfos.getOutputPortInfos();
        List actualPorts = input ? this.docuInfos.getInputPortInfos() : this.docuInfos.getOutputPortInfos();
        for (int i = 0; i < Math.min(storedPorts.size(), actualPorts.size()); ++i) {
            actualPorts.set(i, (PortInfo)storedPorts.get(i));
        }
        List storedNames = input ? (List)storedPortNames.getFirst() : (List)storedPortNames.getSecond();
        List actualNames = input ? (List)this.portNames.getFirst() : (List)this.portNames.getSecond();
        for (int i = 0; i < Math.min(storedNames.size(), actualNames.size()); ++i) {
            actualNames.set(i, (String)storedNames.get(i));
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public String getSaveLocation() {
        if (this.useOriginalLocation) {
            return this.originalLocation;
        }
        return null;
    }

    public CustomOperatorTemplate getTemplate() {
        AbstractSet selectedOptional;
        String name = this.overviewPanel.getDefinedName();
        String icon = this.overviewPanel.getIconName();
        String color = this.overviewPanel.getColor();
        byte[] finalOptionals = null;
        ArrayList<Pair> finalDependencies = null;
        if (this.order != null) {
            HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
            Iterator<Map.Entry<String, RepositoryLocationValueCellEditor>> orderValues = this.order.getValues();
            finalOptionals = new byte[orderValues.size()];
            finalDependencies = new ArrayList<Pair>(orderValues.size());
            for (int i = 0; i < orderValues.size(); ++i) {
                orderMap.put(Objects.toString(((Object[])orderValues.get(i))[0]), i);
                finalOptionals[i] = ((Integer)((Object[])orderValues.get(i))[1]).byteValue();
                if (((Object[])orderValues.get(i))[2] != null && ((Object[])orderValues.get(i))[3] != null) {
                    finalDependencies.add(new Pair((Object)Objects.toString(((Object[])orderValues.get(i))[2]), (Object)Objects.toString(((Object[])orderValues.get(i))[3])));
                    continue;
                }
                finalDependencies.add(null);
            }
            selectedOptional = new TreeSet<CustomParameterInfo>(Comparator.comparingInt(info -> (Integer)orderMap.get(info.getAlias())));
        } else {
            selectedOptional = new LinkedHashSet<CustomParameterInfo>();
        }
        selectedOptional.addAll(this.overviewPanel.getSelectedParameters());
        if (finalOptionals != null) {
            int index = 0;
            for (CustomParameterInfo customParameterInfo : selectedOptional) {
                if (finalOptionals[index] == 2) {
                    customParameterInfo.setOptional(true);
                    customParameterInfo.setExpert(true);
                } else {
                    customParameterInfo.setOptional(finalOptionals[index] == 0);
                    customParameterInfo.setExpert(false);
                }
                customParameterInfo.setDependency((Pair)finalDependencies.get(index));
                ++index;
            }
        }
        if (!CustomModuleUtils.CustomOperatorType.STANDARD.equals((Object)this.overviewPanel.getCustomOperatorType())) {
            LinkedHashMap<String, String> inputPortMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, RepositoryLocationValueCellEditor> entry : this.overviewPanel.getInputPortSchemaEditors().entrySet()) {
                String portName = entry.getKey();
                RepositoryLocationValueCellEditor cellEditor = entry.getValue();
                inputPortMap.put(portName, (String)cellEditor.getCellEditorValue());
            }
            LinkedHashMap<String, String> outputPortMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, RepositoryLocationValueCellEditor> entry : this.overviewPanel.getOutputPortsVisConfigEditors().entrySet()) {
                String portName = entry.getKey();
                RepositoryLocationValueCellEditor cellEditor = entry.getValue();
                outputPortMap.put(portName, (String)cellEditor.getCellEditorValue());
            }
            return new CustomOperatorTemplate(name, icon, color, this.synopsisField.getText(), this.descriptionField.getText(), this.overviewPanel.getCustomOperatorType(), inputPortMap, outputPortMap, selectedOptional, this.docuInfos, (List)this.portNames.getFirst(), (List)this.portNames.getSecond());
        }
        return new CustomOperatorTemplate(name, icon, color, this.synopsisField.getText(), this.descriptionField.getText(), selectedOptional, this.docuInfos, (List)this.portNames.getFirst(), (List)this.portNames.getSecond());
    }

    private boolean checkIfInputOk() {
        String name = this.overviewPanel.getDefinedName();
        if (name == null || name.length() == 0) {
            SwingTools.showVerySimpleErrorMessage((String)"no_template_name", (Object[])new Object[0]);
            return false;
        }
        if (name.contains("/")) {
            SwingTools.showVerySimpleErrorMessage((String)"no_separator_in_name", (Object[])new Object[0]);
            return false;
        }
        String first = this.findFirstDoubleAlias();
        if (first != null) {
            SwingTools.showVerySimpleErrorMessage((String)"template.double_alias", (Object[])new Object[]{first});
            return false;
        }
        if (!CustomModuleUtils.CustomOperatorType.STANDARD.equals((Object)this.overviewPanel.getCustomOperatorType()) && this.overviewPanel.hasCustomSubprocess()) {
            SwingTools.showVerySimpleErrorMessage((String)"template.custom_subprocess_non_standard", (Object[])new Object[0]);
            return false;
        }
        return this.checkPortNames(true) && this.checkPortNames(false);
    }

    private boolean checkPortNames(boolean isInput) {
        List portNames = isInput ? (List)this.portNames.getFirst() : (List)this.portNames.getSecond();
        boolean nonStandardFound = false;
        String defaultName = isInput ? "input " : "result ";
        for (int i = 0; i < portNames.size(); ++i) {
            if ((defaultName + (i + 1)).equals(portNames.get(i))) continue;
            nonStandardFound = true;
            break;
        }
        if (!nonStandardFound) {
            portNames.clear();
            return true;
        }
        HashSet uniqueNames = new HashSet(portNames);
        if (uniqueNames.size() != portNames.size()) {
            SwingTools.showVerySimpleErrorMessage((String)("template.custom_port.non_unique." + (isInput ? "input" : "output")), (Object[])new Object[0]);
            return false;
        }
        for (String portName : portNames) {
            if (PORT_PATTERN.matcher(portName).matches()) continue;
            SwingTools.showVerySimpleErrorMessage((String)"template.custom_port.illegal_name", (Object[])new Object[]{portName});
            return false;
        }
        return true;
    }

    private String findFirstDoubleAlias() {
        HashSet<String> aliases = new HashSet<String>();
        for (CustomParameterInfo selectedParameter : this.overviewPanel.getSelectedParameters()) {
            String alias = selectedParameter.getAlias();
            if (aliases.contains(alias)) {
                return alias;
            }
            aliases.add(alias);
        }
        return null;
    }

    protected void ok() {
        if (this.checkIfInputOk()) {
            this.ok = true;
            this.dispose();
        }
    }

    protected void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.browserPanel != null) {
            this.browserPanel.dispose();
        }
    }

    private static enum State {
        OVERVIEW,
        PARAMETERS,
        DOCU;

    }
}

