/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.extension.PluginInitCustomOperatorCreator;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.extension.processdefined.operator.CustomOperatorCache;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.NotificationPopup;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.PlatformUtilities;
import com.rapidminer.tools.plugin.ManagedExtension;
import com.rapidminer.tools.plugin.Plugin;
import ide2rm.rmx.remote.ReplacePlugins;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.text.WordUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExtensionCreationHelper {
    private static final Pattern VALID_NAME = Pattern.compile("[A-Za-z0-9]+");
    private final String nameText;
    private final String versionText;

    public ExtensionCreationHelper(String nameText, String versionText) {
        this.nameText = nameText;
        this.versionText = versionText;
    }

    public void handleCreationResult(ExtensionCreator.CreationError error) {
        SwingUtilities.invokeLater(() -> {
            if (error == null) {
                int confirmation;
                this.clearSignatureCache();
                boolean instantReload = PluginInitCustomOperatorCreator.isIDE2RMPresent();
                String path = ".RapidMiner/extensions";
                if (new VersionNumber(PlatformUtilities.getReleaseVersion()).isAtLeast(10, 4, 0)) {
                    path = ".AltairRapidMiner/AI Studio/shared/extensions";
                }
                String dialogKey = "create_custom_operator_extension.success";
                if (instantReload) {
                    dialogKey = dialogKey + "_reload";
                }
                if ((confirmation = SwingTools.showConfirmDialog((String)dialogKey, (int)0, (Object[])new Object[]{path})) == 0) {
                    if (!instantReload) {
                        RapidMinerGUI.getMainFrame().exit(true);
                    } else {
                        CustomOperatorCache.clear();
                        this.tryReload();
                    }
                }
            } else {
                SwingTools.showSimpleErrorMessage((String)"create_custom_operator_extension.failed", (Throwable)error.getException(), (Object[])new Object[]{error.getMessage()});
            }
        });
    }

    private void clearSignatureCache() {
        if (PluginInitProcessDefinedOperators.PROCESS_WITHOUT_GUI_SWITCH != null) {
            try {
                Class<?> registryClass = Class.forName("com.rapidminer.tools.OperatorSignatureRegistry");
                Method removeProviderMethod = registryClass.getMethod("removeProvider", String.class, Boolean.TYPE);
                Object registryInstance = registryClass.getDeclaredField("INSTANCE").get(null);
                String provider = ProcessDefinedOperators.toSnakeCase((String)WordUtils.capitalizeFully((String)this.nameText.trim()));
                removeProviderMethod.invoke(registryInstance, provider, true);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                LogService.getRoot().log(Level.WARNING, "Could not clear operator signatures.", e);
            }
        }
    }

    public static boolean isFolder(String folderName) {
        try {
            Path path = Paths.get(folderName, new String[0]);
            return Files.isDirectory(path, new LinkOption[0]);
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    public static Color transformString2Color(String value) {
        String[] colors = value.split(",");
        if (colors.length != 3) {
            return Color.WHITE;
        }
        try {
            return new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
        }
        catch (NumberFormatException e) {
            return Color.WHITE;
        }
    }

    public static List<Object[]> getCusopsFrom(Path folder, List<String> legacyOrderedFiles) {
        if (folder == null || !Files.exists(folder, new LinkOption[0]) && !Files.isDirectory(folder, new LinkOption[0])) {
            return Collections.singletonList(new Object[]{"Custom operator folder does not exist", null});
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        try {
            for (Path entry : ExtensionCreationHelper.getAllContent(folder)) {
                String fileName = folder.relativize(entry).toString().replace(".cusop", "");
                Document doc = XMLTools.parse((File)entry.toFile());
                String name = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)"title");
                int sep = fileName.lastIndexOf(File.separatorChar);
                if (sep > 0) {
                    name = fileName.substring(0, sep + 1).replace(File.separatorChar, '/') + name;
                }
                list.add(new Object[]{name, fileName.replace(File.separatorChar, '/')});
            }
        }
        catch (IOException | SAXException e) {
            LogService.getRoot().log(Level.SEVERE, "Could not load custom operator file", e);
            return Collections.singletonList(new Object[]{"Custom operator parsing error, see log", null});
        }
        if (legacyOrderedFiles != null) {
            ExtensionCreationHelper.toLegacyOrder(legacyOrderedFiles, list);
        }
        return list;
    }

    public static List<Path> getAllContent(Path folder, String extension) throws IOException {
        return RepositoryUtils.getAllContent((Path)folder, (String)extension);
    }

    static List<Path> getAllContent(Path folder) throws IOException {
        return RepositoryUtils.getAllContent((Path)folder, (String)".cusop");
    }

    public static boolean checkCustomOpPath(Path folder) {
        if (folder != null && !Files.exists(folder, new LinkOption[0]) && !Files.isDirectory(folder, new LinkOption[0])) {
            SwingTools.showVerySimpleErrorMessage((String)"custom_operators.invalid_cusop_folder", (Object[])new Object[0]);
            return false;
        }
        HashSet<String> fileNamesAsKeys = new HashSet<String>();
        try {
            for (Path entry : ExtensionCreationHelper.getAllContent(folder)) {
                String fileName = entry.getFileName().toString().replace(".cusop", "");
                if (!VALID_NAME.matcher(fileName).matches()) {
                    SwingTools.showVerySimpleErrorMessage((String)"custom_operators.illegal_file_name", (Object[])new Object[]{fileName});
                    return false;
                }
                if (fileNamesAsKeys.contains(fileName)) {
                    SwingTools.showVerySimpleErrorMessage((String)"custom_operators.duplicate_file_name", (Object[])new Object[]{fileName});
                    return false;
                }
                fileNamesAsKeys.add(fileName);
            }
        }
        catch (IOException e) {
            SwingTools.showSimpleErrorMessage((String)"custom_operators.failed_to_read", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    static void toLegacyOrder(List<String> legacyOrderedFiles, List<Object[]> list) {
        ArrayList<String> newOrder = new ArrayList<String>(legacyOrderedFiles);
        for (Object[] objects : list) {
            String fileName = (String)objects[1];
            if (newOrder.contains(fileName)) continue;
            newOrder.add(fileName);
        }
        list.sort((o1, o2) -> {
            String firstFileName = (String)o1[1];
            String secondFileName = (String)o2[1];
            return newOrder.indexOf(firstFileName) - newOrder.indexOf(secondFileName);
        });
    }

    static Path getExtensionsDir() {
        return ManagedExtension.getUserExtensionsDir().toPath().getParent().resolve("extensions");
    }

    private void tryReload() {
        ProgressThread progressThread = new ProgressThread("custom_extension.reload"){

            public void run() {
                if (!ExtensionCreationHelper.this.reloadExtension()) {
                    RapidMinerGUI.getMainFrame().exit(true);
                }
            }
        };
        progressThread.setIndeterminate(true);
        progressThread.setStartDialogShowTimer(true);
        progressThread.start();
    }

    private boolean reloadExtension() {
        try {
            String name = ProcessDefinedOperators.toSnakeCase((String)WordUtils.capitalizeFully((String)this.nameText.trim()));
            HashMap<String, String> replacement = new HashMap<String, String>();
            String id = "none";
            if (Plugin.getPluginByExtensionId((String)("rmx_" + name)) != null) {
                id = "rmx_" + name;
            }
            String prefix = ExtensionCreationHelper.getExtensionsDir().toFile().getAbsolutePath().replace('\\', '/');
            replacement.put(id, prefix + '/' + name + '-' + this.getVersionString() + "-all.jar");
            boolean success = new ReplacePlugins(RapidMinerGUI.getMainFrame()).reload(replacement);
            if (!success || replacement.isEmpty()) {
                return SwingTools.showConfirmDialog((String)"manage_extensions.restart", (int)0, (Object[])new Object[0]) != 0;
            }
            Plugin plugin = Plugin.getPluginByExtensionId((String)("rmx_" + name));
            if (!this.hasRegisteredOperators(plugin)) {
                try {
                    plugin.registerOperators();
                }
                catch (Exception e) {
                    LogService.getRoot().log(Level.WARNING, "com.rapidminer.tools.plugin.Plugin.register_operators_runtime_failed", new Object[]{plugin.getName(), e.getMessage()});
                }
            }
            NotificationPopup.showFadingPopup((JPanel)SwingTools.createNotificationPanel((String)"gui.bubble.ok.icon", (String)"gui.dialog.success.custom_extension.reload_extension.message"), (Component)RapidMinerGUI.getMainFrame(), (NotificationPopup.PopupLocation)NotificationPopup.PopupLocation.LOWER_RIGHT, (int)3000, (int)30, (int)40);
            return true;
        }
        catch (Exception e) {
            return SwingTools.showConfirmDialog((String)"manage_extensions.restart", (int)0, (Object[])new Object[0]) != 0;
        }
    }

    private String getVersionString() {
        return new VersionNumber(this.versionText).getShortLongVersion();
    }

    private boolean hasRegisteredOperators(Plugin plugin) {
        for (String opKey : new HashSet(OperatorService.getOperatorKeys())) {
            OperatorDescription desc = OperatorService.getOperatorDescription((String)opKey);
            if (desc.getProvider() != plugin) continue;
            return true;
        }
        return false;
    }
}

