/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.FileSystemService;
import com.rapidminer.tools.XMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExtensionInfo {
    private static final Logger LOGGER = Logger.getLogger(ExtensionInfo.class.getName());
    private String name;
    private String vendor;
    private String homepage;
    private String folder;
    private String ioobjectsFolder;
    private String color;
    private String versionNumber;
    private String optionalJars;
    private String additionalIcons;
    private boolean calculateDependencies;
    private String icon;
    private boolean hideProcesses;
    private List<String> orderedFiles;

    public ExtensionInfo(String name, String vendor, String homepage, String folder, String ioobjectsFolder, String color, String versionNumber, String optionalJars, String additionalIcons, boolean calculateDependencies, String icon, boolean hideProcesses, List<String> orderedFiles) {
        this.name = name;
        this.vendor = vendor;
        this.homepage = homepage;
        this.folder = folder;
        this.ioobjectsFolder = ioobjectsFolder;
        this.color = color;
        this.versionNumber = versionNumber;
        this.optionalJars = optionalJars;
        this.additionalIcons = additionalIcons;
        this.calculateDependencies = calculateDependencies;
        this.icon = icon;
        this.hideProcesses = hideProcesses;
        this.orderedFiles = orderedFiles;
    }

    public ExtensionInfo() {
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getIoobjectsFolder() {
        return this.ioobjectsFolder;
    }

    public String getColor() {
        return this.color;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getOptionalJars() {
        return this.optionalJars;
    }

    public String getAdditionalIcons() {
        return this.additionalIcons;
    }

    public boolean isCalculateDependencies() {
        return this.calculateDependencies;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isHideProcesses() {
        return this.hideProcesses;
    }

    public List<String> getOrderedFiles() {
        return this.orderedFiles;
    }

    public void store() {
        try {
            Document doc = this.createXml();
            File file = ExtensionInfo.getFile();
            if (file.exists()) {
                file.delete();
            }
            XMLTools.stream((Document)doc, (File)file, (Charset)XMLImporter.PROCESS_FILE_CHARSET);
            this.storeInRepo(doc);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Failed to create custom extension previous settings xml", e);
        }
        catch (XMLException e) {
            LOGGER.log(Level.WARNING, "Failed to store custom extension previous settings xml", e);
        }
    }

    private void storeInRepo(Document doc) {
        Path path = RepositoryUtils.locationToFolderPath((String)this.folder);
        if (path == null) {
            return;
        }
        Path dictionary = path.resolve("config");
        File cusextFile = dictionary.resolve(this.name + "." + "cusext").toFile();
        try {
            Files.createDirectories(dictionary, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to create directory for custom extension settings xml", e);
        }
        try {
            XMLTools.stream((Document)doc, (File)cusextFile, (Charset)XMLImporter.PROCESS_FILE_CHARSET);
        }
        catch (XMLException e) {
            LOGGER.log(Level.WARNING, "Failed to store custom extension settings xml", e);
        }
        RepositoryUtils.refreshFolder((String)this.folder);
    }

    public void reload() throws IOException, SAXException {
        File file = ExtensionInfo.getFile();
        if (!file.exists()) {
            throw new IOException("Cannot find previously stored settings");
        }
        this.reload(file);
    }

    public void reload(File file) throws SAXException, IOException {
        Document doc = XMLTools.parse((InputStream)new ByteArrayInputStream(Files.readAllBytes(file.toPath())));
        this.name = this.getTag(doc, "name");
        this.vendor = this.getTag(doc, "vendor");
        this.homepage = this.getTag(doc, "homepage");
        this.folder = this.getTag(doc, "folder");
        this.ioobjectsFolder = this.getTag(doc, "objects_folder");
        this.color = this.getTag(doc, "color");
        this.versionNumber = this.getTag(doc, "version");
        this.optionalJars = this.getTag(doc, "jars");
        this.additionalIcons = this.getTag(doc, "icons");
        this.calculateDependencies = "true".equals(this.getTag(doc, "calculate_deps"));
        this.icon = this.getTag(doc, "icon");
        this.hideProcesses = "true".equals(this.getTag(doc, "hide_processes"));
        String ordering = this.getTag(doc, "ordered_files");
        if (!ordering.isEmpty()) {
            String[] split = ordering.split(",");
            this.orderedFiles = new ArrayList<String>(Arrays.asList(split));
        } else {
            this.orderedFiles = new ArrayList<String>();
        }
    }

    private String getTag(Document doc, String name) {
        String tagContents = XMLTools.getTagContents((Element)doc.getDocumentElement(), (String)name);
        if (tagContents == null) {
            return "";
        }
        return tagContents;
    }

    private static File getFile() {
        File pluginDir = FileSystemService.getPluginRapidMinerDir((String)"rmx_process_defined_operators");
        return new File(pluginDir, "previous_custom_extension.xml");
    }

    private Document createXml() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
        Document doc = documentBuilder.newDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"name", (String)this.name);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"vendor", (String)this.vendor);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"homepage", (String)this.homepage);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"folder", (String)this.folder);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"objects_folder", (String)this.ioobjectsFolder);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"color", (String)this.color);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"version", (String)this.versionNumber);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"jars", (String)this.optionalJars);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"icons", (String)this.additionalIcons);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"calculate_deps", (String)(this.calculateDependencies ? "true" : "false"));
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"icon", (String)this.icon);
        XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"hide_processes", (String)(this.hideProcesses ? "true" : "false"));
        if (this.orderedFiles != null && !this.orderedFiles.isEmpty()) {
            XMLTools.setTagContents((Element)doc.getDocumentElement(), (String)"ordered_files", (String)String.join((CharSequence)",", this.orderedFiles));
        }
        return doc;
    }
}

