/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.tools.Tools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

enum IconProcessor {

    private static final String ICONS_LOCATION = "com/rapidminer/resources/icons/";

    static ExtensionCreator.CreationError addIcons(Path additionalIcons, JarOutputStream jarOut) {
        if (additionalIcons == null || !Files.exists(additionalIcons, new LinkOption[0]) && !Files.isDirectory(additionalIcons, new LinkOption[0])) {
            return new ExtensionCreator.CreationError("Additional icons folder does not exist", null);
        }
        try {
            List<Path> allIcons = ExtensionCreationHelper.getAllContent(additionalIcons, ".png");
            for (Path path : allIcons) {
                ExtensionCreator.CreationError error = IconProcessor.storeScaledImages(jarOut, path);
                if (error == null) continue;
                return error;
            }
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to read from additional icons folder", e);
        }
        return null;
    }

    static ExtensionCreator.CreationError copyExtensionIcon(String iconName, Path additionalIcons, ZipOutputStream jarOut) {
        URL resource;
        String adjustedIconName = iconName;
        if (!adjustedIconName.endsWith(".png")) {
            adjustedIconName = adjustedIconName + ".png";
        }
        if ((resource = Tools.getResource((String)(adjustedIconName = "icons/24/@2x/" + adjustedIconName))) == null) {
            if (additionalIcons == null) {
                return new ExtensionCreator.CreationError("Icon " + iconName + " not found", null);
            }
            return IconProcessor.addIconFromAdditionals(additionalIcons, iconName, jarOut);
        }
        try (InputStream inputStream = resource.openStream();){
            jarOut.putNextEntry(new ZipEntry("META-INF/icon.png"));
            IOUtils.copy((InputStream)inputStream, (OutputStream)jarOut);
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to copy extension icon", e);
        }
        return null;
    }

    private static ExtensionCreator.CreationError storeScaledImages(JarOutputStream jarOut, Path path) throws IOException {
        BufferedImage read = ImageIO.read(path.toFile());
        String name = path.getFileName().toString();
        BufferedImage image16 = IconProcessor.getScaledImage(read, 16);
        ExtensionCreator.CreationError error = IconProcessor.storeIcon(image16, name, "16", jarOut);
        if (error != null) {
            return error;
        }
        BufferedImage image32 = IconProcessor.getScaledImage(read, 32);
        error = IconProcessor.storeIcon(image32, name, "16/@2x", jarOut);
        if (error != null) {
            return error;
        }
        BufferedImage image24 = IconProcessor.getScaledImage(read, 24);
        error = IconProcessor.storeIcon(image24, name, "24", jarOut);
        if (error != null) {
            return error;
        }
        BufferedImage image48 = IconProcessor.getScaledImage(read, 48);
        error = IconProcessor.storeIcon(image48, name, "24/@2x", jarOut);
        if (error != null) {
            return error;
        }
        error = IconProcessor.storeIcon(image48, name, "48", jarOut);
        if (error != null) {
            return error;
        }
        BufferedImage image96 = IconProcessor.getScaledImage(read, 96);
        error = IconProcessor.storeIcon(image96, name, "48/@2x", jarOut);
        return error;
    }

    private static ExtensionCreator.CreationError storeIcon(BufferedImage image, String name, String size, JarOutputStream jarOut) {
        String location = ICONS_LOCATION + size + "/" + name;
        try {
            jarOut.putNextEntry(new ZipEntry(location));
            ImageIO.write((RenderedImage)image, "png", jarOut);
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to write icon", e);
        }
        return null;
    }

    private static ExtensionCreator.CreationError addIconFromAdditionals(Path additionalIcons, String iconName, ZipOutputStream jarOut) {
        BufferedImage image;
        Path potentialIconPath;
        String iconWithPng = iconName;
        if (!iconWithPng.endsWith(".png")) {
            iconWithPng = iconWithPng + ".png";
        }
        if (!Files.exists(potentialIconPath = additionalIcons.resolve(iconWithPng), new LinkOption[0])) {
            return new ExtensionCreator.CreationError("Icon " + iconName + " not found, neither in standard nor in additional icons", null);
        }
        try {
            image = IconProcessor.getScaledImage(ImageIO.read(potentialIconPath.toFile()), 48);
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to read icon " + potentialIconPath.toString(), e);
        }
        try {
            jarOut.putNextEntry(new ZipEntry("META-INF/icon.png"));
            ImageIO.write((RenderedImage)image, "png", jarOut);
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to write extension icon", e);
        }
        return null;
    }

    private static BufferedImage getScaledImage(BufferedImage read, int size) {
        Image scaledInstance = read.getScaledInstance(size, size, 4);
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D bGr = image.createGraphics();
        bGr.drawImage(scaledInstance, 0, 0, null);
        bGr.dispose();
        return image;
    }
}

