/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessSuggestionParameterHelper;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.xml.sax.SAXException;

enum ProcessSuggestionsCalculator {


    static ExtensionCreator.CreationError calculate(Path processes, JarOutputStream jarOut) {
        if (processes == null) {
            return null;
        }
        try {
            String fileContent = ProcessSuggestionsCalculator.calculate(processes);
            if (!fileContent.isEmpty()) {
                jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/process_operators/process_suggestion_parameters"));
                jarOut.write(fileContent.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (XMLException | IOException | SAXException e) {
            return new ExtensionCreator.CreationError("Failed to write process suggestion parameters", (Exception)e);
        }
        return null;
    }

    private static String calculate(Path processes) throws IOException, SAXException, XMLException {
        StringBuilder builder = new StringBuilder();
        for (Path path : ExtensionCreationHelper.getAllContent(processes)) {
            InputStream ins = Files.newInputStream(path, new OpenOption[0]);
            try {
                CustomOperatorTemplate template = new CustomOperatorTemplate(ins);
                Process process = template.getProcessWithoutGUI();
                for (CustomParameterInfo parameter : template.getParameters()) {
                    Operator operator;
                    if (!"value".equals(parameter.getParameter()) || !((operator = process.getOperator(parameter.getOperator())) instanceof ProcessSuggestionParameterHelper)) continue;
                    builder.append(ProcessDefinedOperators.toSnakeCase((String)path.getFileName().toString().replace(".cusop", ""))).append(":").append(parameter.getAlias()).append("\n");
                }
            }
            finally {
                if (ins == null) continue;
                ins.close();
            }
        }
        return builder.toString();
    }
}

