/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.browser;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.browser.BrowserFactory;
import com.rapidminer.extension.browser.gui.BrowserComponent;
import com.rapidminer.extension.browser.gui.HTML5ComponentFactory;
import com.rapidminer.extension.browser.util.BrowserUtilities;
import com.rapidminer.extension.processdefined.browser.CallbackAdapter;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.event.ConsoleMessageReceived;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.engine.event.EngineCrashed;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BrowserPanel
extends JPanel {
    public static final String OPERATORS_INDEX_PATH = "com/rapidminer/extension/resources/generated/js/operators.html";
    public static final String PARAMETERS_INDEX_PATH = "com/rapidminer/extension/resources/generated/js/parameters.html";
    private Browser browser;
    private BrowserComponent browserComponent;
    private JLabel errorLabel;
    private Subscription engineCrashSubscription;
    private CallbackAdapter callbackAdapter;
    private final String indexPath;

    public BrowserPanel(CallbackAdapter callbackAdapter, String indexPath) {
        this.indexPath = indexPath;
        this.callbackAdapter = callbackAdapter;
        this.errorLabel = new JLabel();
        this.errorLabel.setHorizontalAlignment(0);
        this.errorLabel.setText(I18N.getGUILabel((String)"browser.panel.error.label", (Object[])new Object[0]));
        this.setLayout(new BorderLayout());
        this.updateBrowser(false);
        this.displayContent();
    }

    private void displayContent() {
        if (this.browser != null) {
            this.add((Component)this.browserComponent.getComponent(), "Center");
            this.revalidate();
        } else {
            LogService.getRoot().log(Level.SEVERE, "Cannot display content when browser is null! Was this called after the panel was disposed?");
            this.add((Component)this.errorLabel, "Center");
            this.revalidate();
            this.repaint();
        }
        this.reloadHTMLPage();
    }

    public void dispose() {
        if (this.engineCrashSubscription != null) {
            this.engineCrashSubscription.unsubscribe();
        }
        if (this.browserComponent != null) {
            this.browserComponent.close();
            this.browserComponent = null;
        }
        if (this.callbackAdapter != null) {
            this.callbackAdapter.destroy();
        }
        SwingTools.invokeLater(this::removeAll);
        this.callbackAdapter = null;
        this.browser = null;
    }

    private Browser createBrowser() {
        Browser browser = BrowserFactory.createBrowser((RenderingMode)RenderingMode.OFF_SCREEN);
        Level logLevel = RapidMiner.getVersion().isDevelopmentBuild() ? Level.INFO : Level.FINE;
        browser.on(ConsoleMessageReceived.class, e -> LogService.getRoot().log(logLevel, "Browser Message: " + e.consoleMessage().message()));
        browser.navigation().on(FrameLoadFailed.class, event -> {
            if (!"about:blank".equals(event.url())) {
                LogService.getRoot().log(Level.WARNING, "Browser load error: " + event.url() + " : " + event.error());
            }
        });
        if (this.engineCrashSubscription != null) {
            this.engineCrashSubscription.unsubscribe();
        }
        this.engineCrashSubscription = browser.engine().on(EngineCrashed.class, event -> this.updateBrowser(true));
        BrowserUtilities.registerJavaCallbackObject((Browser)browser, (String)"rm_api", (Object)this.callbackAdapter);
        return browser;
    }

    private void updateBrowser(boolean restore) {
        if (restore && this.browserComponent != null) {
            SwingTools.invokeLater(() -> this.remove(this.browserComponent.getComponent()));
        }
        SwingTools.invokeLater(() -> this.remove(this.errorLabel));
        try {
            this.browser = this.createBrowser();
            this.browserComponent = HTML5ComponentFactory.createBrowserComponent((Browser)this.browser);
            if (restore) {
                SwingTools.invokeLater(() -> {
                    this.add((Component)this.browserComponent.getComponent(), "Center");
                    this.revalidate();
                });
                this.reloadHTMLPage();
            }
        }
        catch (Throwable t) {
            LogService.getRoot().log(Level.SEVERE, "Failed to create browser to display content panel", t);
            SwingTools.invokeLater(() -> {
                this.add((Component)this.errorLabel, "Center");
                this.revalidate();
            });
        }
    }

    private void reloadHTMLPage() {
        if (this.browser == null) {
            return;
        }
        if (BrowserUtilities.WEBAPP_DEVELOPMENT_ACTIVATED) {
            this.browser.mainFrame().ifPresent(f -> f.loadUrl("livereload://../extension-process-defined-operator/src/main/resources/" + this.indexPath));
        } else {
            this.browser.mainFrame().ifPresent(f -> f.loadUrl("resources://" + this.indexPath));
        }
    }
}

