/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.browser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rapidminer.tools.LogService;
import com.teamdev.jxbrowser.js.JsAccessible;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;

@JsAccessible
public class CallbackAdapter {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private List<Object[]> values;
    private Supplier<List<Object[]>> valuesSupplier;

    public CallbackAdapter(List<Object[]> values) {
        this.values = values;
    }

    public CallbackAdapter(Supplier<List<Object[]>> valuesSupplier) {
        this.valuesSupplier = valuesSupplier;
    }

    public void update(String values) {
        try {
            Object[][] strings = (Object[][])MAPPER.readValue(values, Object[][].class);
            this.values = Arrays.asList(strings);
        }
        catch (IOException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to update values coming from react component", e);
        }
    }

    public String initialGet() {
        if (this.values == null && this.valuesSupplier != null) {
            this.values = this.valuesSupplier.get();
        }
        if (this.values == null) {
            this.values = Collections.emptyList();
        }
        try {
            return MAPPER.writeValueAsString(this.values);
        }
        catch (JsonProcessingException e) {
            LogService.getRoot().log(Level.WARNING, "Failed to map values for react component to String", e);
            return "[]";
        }
    }

    public List<Object[]> getValues() {
        return this.values;
    }

    void destroy() {
        this.valuesSupplier = null;
    }
}

