/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.dialog;

import com.rapidminer.extension.processdefined.util.DocuInfos;
import com.rapidminer.extension.processdefined.util.PortInfo;
import com.rapidminer.extension.processdefined.util.TutorialInfo;
import com.rapidminer.gui.properties.celleditors.value.EnumerationValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJComboBox;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeEnumeration;
import com.rapidminer.parameter.ParameterTypeProcessLocation;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.container.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DocuPanel
extends JPanel {
    private static final long serialVersionUID = -4892100177390173103L;

    public DocuPanel(DocuInfos docuInfos, Pair<List<String>, List<String>> portNames, JTextArea synopsisField, JTextArea descriptionField) {
        super(new GridBagLayout());
        descriptionField.setLineWrap(true);
        descriptionField.setWrapStyleWord(true);
        synopsisField.setLineWrap(true);
        synopsisField.setWrapStyleWord(true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        ResourceLabel label = new ResourceLabel("save_as_template.synopsis", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        label.setLabelFor(synopsisField);
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.05;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        ExtendedJScrollPane descriptionPane = new ExtendedJScrollPane((Component)synopsisField);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        this.add((Component)descriptionPane, c);
        label = new ResourceLabel("save_as_template.description", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        label.setLabelFor(descriptionField);
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        descriptionPane = new ExtendedJScrollPane((Component)descriptionField);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        this.add((Component)descriptionPane, c);
        label = new ResourceLabel("save_as_template.tags", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 2;
        this.add(DocuPanel.createTagComponent(docuInfos), c);
        label = new ResourceLabel("save_as_template.input_ports", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.weighty = 0.1;
        c.gridwidth = -1;
        c.fill = 0;
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        JComponent inputDocumentationTable = this.makePortTable(true, docuInfos, portNames);
        JComponent outputDocumentationTable = this.makePortTable(false, docuInfos, portNames);
        int inputPorts = docuInfos.getInputPortInfos().size();
        int outputPorts = docuInfos.getOutputPortInfos().size();
        int totalPorts = inputPorts + outputPorts;
        c.weighty = 0.025 + 0.4 / (double)totalPorts * (double)inputPorts;
        descriptionPane = new ExtendedJScrollPane((Component)inputDocumentationTable);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        this.add((Component)descriptionPane, c);
        label = new ResourceLabel("save_as_template.output_ports", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.025 + 0.4 / (double)totalPorts * (double)outputPorts;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        descriptionPane = new ExtendedJScrollPane((Component)outputDocumentationTable);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        this.add((Component)descriptionPane, c);
        label = new ResourceLabel("save_as_template.tutorial", new Object[0]);
        c.insets = new Insets(0, 0, 6, 6);
        c.weightx = 0.0;
        c.gridwidth = -1;
        c.fill = 0;
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.weighty = 0.4;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        JComponent tutorial = this.makeTutorialTable(docuInfos);
        descriptionPane = new ExtendedJScrollPane((Component)tutorial);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        this.add((Component)descriptionPane, c);
        JPanel emptyPanel = new JPanel();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)emptyPanel, c);
    }

    private static Component createTagComponent(DocuInfos docuInfos) {
        ParameterTypeEnumeration enumerationParameter = new ParameterTypeEnumeration("", "Specifies the operator tags for the search.", (ParameterType)new ParameterTypeString("tags", ""));
        final EnumerationValueCellEditor enumeration = new EnumerationValueCellEditor(enumerationParameter);
        enumeration.setOperator(null);
        final List tags = docuInfos.getTags();
        Component enumerationComponent = enumeration.getTableCellEditorComponent(null, (Object)ParameterTypeEnumeration.transformEnumeration2String((List)tags), false, 0, 0);
        enumeration.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                tags.clear();
                tags.addAll(ParameterTypeEnumeration.transformString2List((String)((String)enumeration.getCellEditorValue())));
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                tags.clear();
                tags.addAll(ParameterTypeEnumeration.transformString2List((String)((String)enumeration.getCellEditorValue())));
            }
        });
        return enumerationComponent;
    }

    private JComponent makeTutorialTable(DocuInfos docuInfos) {
        TutorialInfo info;
        boolean newInfo = false;
        if (!docuInfos.getTutorialInfos().isEmpty()) {
            info = (TutorialInfo)docuInfos.getTutorialInfos().get(0);
        } else {
            info = new TutorialInfo();
            docuInfos.getTutorialInfos().add(info);
            newInfo = true;
        }
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        ResourceLabel label = new ResourceLabel("save_as_template.tutorial.title", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        final JTextField titleField = new JTextField(info.getDescription());
        titleField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                info.setTitle(titleField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                info.setTitle(titleField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                info.setTitle(titleField.getText());
            }
        });
        if (!newInfo) {
            titleField.setText(info.getTitle());
        }
        panel.add((Component)titleField, c);
        label = new ResourceLabel("save_as_template.tutorial.description", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        final JTextArea docuField = new JTextArea(2, 40);
        docuField.setLineWrap(true);
        docuField.setWrapStyleWord(true);
        docuField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                info.setDescription(docuField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                info.setDescription(docuField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                info.setDescription(docuField.getText());
            }
        });
        docuField.setText(info.getDescription());
        ExtendedJScrollPane descriptionPane = new ExtendedJScrollPane((Component)docuField);
        descriptionPane.setBorder(ButtonDialog.createBorder());
        panel.add((Component)descriptionPane, c);
        JPanel labelPanel = new JPanel(new BorderLayout());
        label = new ResourceLabel("save_as_template.tutorial.process", new Object[0]);
        labelPanel.add((Component)label, "Center");
        String[] options = new String[]{I18N.getGUILabel((String)"save_as_template.tutorial.process.location.label", (Object[])new Object[0]), I18N.getGUILabel((String)"save_as_template.tutorial.process.xml.label", (Object[])new Object[0])};
        JComboBox<String> typeSelection = new JComboBox<String>(options);
        int xmlSelectionIndex = 1;
        if (info.useXML()) {
            typeSelection.setSelectedIndex(xmlSelectionIndex);
        }
        labelPanel.add(typeSelection, "East");
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)labelPanel, c);
        final ProcessLocationWithAccess tutorialLocation = new ProcessLocationWithAccess();
        tutorialLocation.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                info.setLocation((String)tutorialLocation.getCellEditorValue());
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                info.setLocation((String)tutorialLocation.getCellEditorValue());
            }
        });
        Component locationComponent = tutorialLocation.getTableCellEditorComponent(null, null, false, 0, 0);
        if (info.useXML()) {
            locationComponent.setVisible(false);
        } else {
            tutorialLocation.setText(info.getLocation());
        }
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        panel.add(locationComponent, c);
        final JTextArea processField = new JTextArea(4, 40);
        processField.setLineWrap(true);
        processField.setWrapStyleWord(true);
        processField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                info.setXml(processField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                info.setXml(processField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                info.setXml(processField.getText());
            }
        });
        processField.setText(info.getXml());
        ExtendedJScrollPane processPane = new ExtendedJScrollPane((Component)processField);
        processPane.setBorder(ButtonDialog.createBorder());
        if (!info.useXML()) {
            processPane.setVisible(false);
        }
        panel.add((Component)processPane, c);
        typeSelection.addActionListener(arg_0 -> DocuPanel.lambda$makeTutorialTable$0(typeSelection, xmlSelectionIndex, info, (JScrollPane)processPane, locationComponent, arg_0));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private JComponent makePortTable(boolean input, DocuInfos docuInfos, Pair<List<String>, List<String>> portNames) {
        List portInfos = input ? docuInfos.getInputPortInfos() : docuInfos.getOutputPortInfos();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        boolean noPorts = true;
        Object[] portOptions = OperatorService.getIOObjectsNames().toArray(new String[0]);
        List portNameList = input ? (List)portNames.getFirst() : (List)portNames.getSecond();
        int index = 0;
        for (final PortInfo portInfo : portInfos) {
            JTextField portNameField = DocuPanel.createPortNameField(index, portNameList);
            ++index;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = -1;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)portNameField, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 0);
            c.fill = 1;
            JPanel portPanel = new JPanel(new BorderLayout());
            ExtendedJComboBox typeBox = new ExtendedJComboBox(portOptions);
            typeBox.setSelectedItem((Object)portInfo.getPortType());
            typeBox.setPrototypeDisplayValue((Object)"type description here");
            typeBox.addItemListener(e -> portInfo.setPortType((String)typeBox.getSelectedItem()));
            final JTextField docuField = new JTextField(portInfo.getDescription());
            docuField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    portInfo.setDescription(docuField.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    portInfo.setDescription(docuField.getText());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    portInfo.setDescription(docuField.getText());
                }
            });
            portPanel.add((Component)typeBox, "West");
            portPanel.add((Component)docuField, "Center");
            panel.add((Component)portPanel, c);
            noPorts = false;
        }
        if (noPorts) {
            ResourceLabel label = new ResourceLabel("save_as_template.no_ports_connected", new Object[0]);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)label, c);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private static JTextField createPortNameField(final int index, final List<String> portNames) {
        final JTextField nameField = new JTextField(portNames.get(index), 7);
        nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                portNames.set(index, nameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                portNames.set(index, nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                portNames.set(index, nameField.getText());
            }
        });
        return nameField;
    }

    private static /* synthetic */ void lambda$makeTutorialTable$0(JComboBox typeSelection, int xmlSelectionIndex, TutorialInfo info, JScrollPane processPane, Component locationComponent, ActionEvent e) {
        if (typeSelection.getSelectedIndex() == xmlSelectionIndex) {
            info.setUseXML(true);
            processPane.setVisible(true);
            locationComponent.setVisible(false);
        } else {
            info.setUseXML(false);
            processPane.setVisible(false);
            locationComponent.setVisible(true);
        }
    }

    private static final class ProcessLocationWithAccess
    extends RepositoryLocationValueCellEditor {
        private ProcessLocationWithAccess() {
            super((ParameterTypeRepositoryLocation)new ParameterTypeProcessLocation("", "", true));
        }

        protected Predicate<Entry> getRepositoryFilter() {
            return RepositoryLocationChooser.ONLY_PROCESSES;
        }

        public void setText(String text) {
            super.getTextField().setText(text);
        }
    }
}

