/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.dialog;

import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitCustomOperatorCreator;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.operator.CustomSubprocess;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.gui.properties.celleditors.value.ColorValueCellEditor;
import com.rapidminer.gui.properties.celleditors.value.RepositoryLocationValueCellEditor;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.components.LinkRemoteButton;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.InputPorts;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.operator.ports.OutputPorts;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.ParameterTypeRepositoryLocation;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.RMUrlHandler;
import com.rapidminer.tools.container.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OverviewPanel
extends JPanel {
    private static final long serialVersionUID = -4897200177390173103L;
    private static final String ICON_LINK = I18N.getGUILabel((String)"process_defined_operators.icon_search.url", (Object[])new Object[0]);
    private static final Action ICON_ACTION = new ResourceAction("process_defined_operators.icon_search", new Object[0]){
        private static final long serialVersionUID = 1L;

        public void loggedActionPerformed(ActionEvent e) {
            RMUrlHandler.openInBrowser((String)ICON_LINK);
        }
    };
    private final transient Process process;
    private final transient Set<CustomParameterInfo> selectedParameters = new LinkedHashSet<CustomParameterInfo>();
    private final JTextField nameField = new JTextField();
    private final JTextField iconField = new JTextField();
    private final ColorValueCellEditor color = new ColorValueCellEditor(new ParameterTypeColor("", "", Color.WHITE));
    private final JComboBox<String> colorCombobox = new JComboBox<String>(new String[]{I18N.getGUILabel((String)"save_as_template.color.extension.label", (Object[])new Object[0]), I18N.getGUILabel((String)"save_as_template.color.operator.label", (Object[])new Object[0])});
    private final JComboBox<CustomModuleUtils.CustomOperatorType> customOperatorTypeField = new JComboBox<CustomModuleUtils.CustomOperatorType>(CustomModuleUtils.CustomOperatorType.values());
    private final transient Map<String, RepositoryLocationValueCellEditor> inputPortsSchemaEditors = new LinkedHashMap<String, RepositoryLocationValueCellEditor>();
    private final transient Map<String, RepositoryLocationValueCellEditor> outputPortsVisConfigEditors = new LinkedHashMap<String, RepositoryLocationValueCellEditor>();
    private final ExtendedJScrollPane tablePane;

    OverviewPanel(Process process, Action openAction) {
        super(new GridBagLayout());
        this.process = process;
        this.tablePane = new ExtendedJScrollPane((Component)this.makeCheckboxTable((Operator)process.getRootOperator(), null, false));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        ResourceLabel label = new ResourceLabel("save_as_template.name", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        label.setLabelFor(this.nameField);
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.add((Component)this.nameField, c);
        JButton openButton = new JButton(openAction);
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.nameField, "Center");
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)openButton, "East");
        wrapper2.add(Box.createHorizontalStrut(10), "Center");
        wrapper.add((Component)wrapper2, "East");
        this.add((Component)wrapper, c);
        label = new ResourceLabel("save_as_template.icon", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        LinkRemoteButton iconLink = new LinkRemoteButton(ICON_ACTION);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)this.iconField, "Center");
        container.add((Component)iconLink, "East");
        this.add((Component)container, c);
        if (RapidMiner.getVersion().isAbove(PluginInitCustomOperatorCreator.COLOR_SUPPORT_STUDIO_VERSION)) {
            label = new ResourceLabel("save_as_template.color", new Object[0]);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = -1;
            c.insets = new Insets(0, 0, 6, 6);
            this.add((Component)label, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 0);
            c.fill = 1;
            this.add((Component)this.getColorPanel(), c);
        }
        this.createDataStructureFields(c, this);
        this.tablePane.setBorder(ButtonDialog.createBorder());
        c.weightx = 1.0;
        c.weighty = 0.85;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.tablePane, c);
    }

    private JPanel getColorPanel() {
        Component colorComponent = this.color.getTableCellEditorComponent(null, null, false, 0, 0);
        colorComponent.setVisible(false);
        JPanel container = new JPanel(new BorderLayout());
        container.add(this.colorCombobox, "West");
        JPanel colorComponentPanel = new JPanel(new BorderLayout());
        colorComponentPanel.add(Box.createHorizontalStrut(7), "West");
        colorComponentPanel.add(colorComponent, "Center");
        container.add((Component)colorComponentPanel, "Center");
        this.colorCombobox.addActionListener(e -> colorComponent.setVisible(this.colorCombobox.getSelectedIndex() != 0));
        return container;
    }

    private void createDataStructureFields(GridBagConstraints c, JPanel panel) {
        if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
            return;
        }
        ResourceLabel label = new ResourceLabel("save_as_template.custom_operator_type", new Object[0]);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 6, 6);
        panel.add((Component)label, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 0);
        c.fill = 1;
        this.customOperatorTypeField.setEditable(false);
        this.customOperatorTypeField.setToolTipText(label.getToolTipText());
        panel.add(this.customOperatorTypeField, c);
        JPanel emptyPanel = new JPanel();
        JComponent inputSchemaTable = this.makeInputPortSchemaTable(this.process.getRootOperator().getSubprocess(0).getInnerSources());
        JComponent outputVisConfigTable = this.makeOutputPortVisConfigTable(this.process.getRootOperator().getSubprocess(0).getInnerSinks());
        ExtendedJScrollPane paneInputPorts = new ExtendedJScrollPane((Component)emptyPanel);
        paneInputPorts.setBorder(ButtonDialog.createBorder());
        ExtendedJScrollPane paneOutputPorts = new ExtendedJScrollPane((Component)emptyPanel);
        paneOutputPorts.setBorder(ButtonDialog.createBorder());
        if (!Objects.equals(this.customOperatorTypeField.getSelectedItem(), CustomModuleUtils.CustomOperatorType.STANDARD)) {
            paneInputPorts.setViewportView((Component)inputSchemaTable);
            paneOutputPorts.setViewportView((Component)outputVisConfigTable);
        } else {
            paneInputPorts.setVisible(false);
            paneOutputPorts.setVisible(false);
        }
        this.customOperatorTypeField.addActionListener(e -> {
            if (!Objects.equals(this.customOperatorTypeField.getSelectedItem(), CustomModuleUtils.CustomOperatorType.STANDARD)) {
                paneInputPorts.setViewportView((Component)inputSchemaTable);
                paneInputPorts.setVisible(true);
                paneOutputPorts.setViewportView((Component)outputVisConfigTable);
                paneOutputPorts.setVisible(true);
            } else {
                paneInputPorts.setViewportView((Component)emptyPanel);
                paneInputPorts.setVisible(false);
                paneOutputPorts.setViewportView((Component)emptyPanel);
                paneOutputPorts.setVisible(false);
            }
            this.revalidate();
            this.repaint();
        });
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)paneInputPorts, c);
        panel.add((Component)paneOutputPorts, c);
    }

    private JComponent makeInputPortSchemaTable(OutputPorts innerSources) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        boolean noPorts = true;
        for (OutputPort outputPort : innerSources.getAllPorts()) {
            if (!outputPort.isConnected()) continue;
            JLabel portNameLabel = new JLabel(outputPort.getName());
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = -1;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)portNameLabel, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 0);
            c.fill = 1;
            RepositoryLocationValueCellEditor repositoryLocationSelector = new RepositoryLocationValueCellEditor(new ParameterTypeRepositoryLocation("", "", true, false, true, false, false));
            this.inputPortsSchemaEditors.put(outputPort.getName(), repositoryLocationSelector);
            panel.add(repositoryLocationSelector.getTableCellEditorComponent(null, null, false, 0, 0), c);
            noPorts = false;
        }
        if (noPorts) {
            ResourceLabel label = new ResourceLabel("save_as_template.no_inner_sources", new Object[0]);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)label, c);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private JComponent makeOutputPortVisConfigTable(InputPorts innerSinks) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        boolean noPorts = true;
        for (InputPort inputPort : innerSinks.getAllPorts()) {
            if (!inputPort.isConnected()) continue;
            JLabel portNameLabel = new JLabel(inputPort.getName());
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = -1;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)portNameLabel, c);
            c.weightx = 1.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 0);
            c.fill = 1;
            RepositoryLocationValueCellEditor repositoryLocationSelector = new RepositoryLocationValueCellEditor(new ParameterTypeRepositoryLocation("", "", true, false, true, false, false));
            this.outputPortsVisConfigEditors.put(inputPort.getName(), repositoryLocationSelector);
            panel.add(repositoryLocationSelector.getTableCellEditorComponent(null, null, false, 0, 0), c);
            noPorts = false;
        }
        if (noPorts) {
            ResourceLabel label = new ResourceLabel("save_as_template.no_inner_sources", new Object[0]);
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.gridwidth = 0;
            c.insets = new Insets(0, 0, 6, 6);
            panel.add((Component)label, c);
        }
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        return panel;
    }

    private JComponent makeCheckboxTable(Operator operator, Map<String, Map<String, CustomParameterInfo>> templateParameters, boolean definesOptionals) {
        List<Operator> ops = this.getSensibleOperators(operator);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.gridwidth = 0;
        boolean first = true;
        for (Operator op : ops) {
            if (!op.isEnabled()) continue;
            JPanel operatorPanel = new JPanel(new BorderLayout());
            Collection parameterTypes = op.getParameters().getParameterTypes();
            if (parameterTypes.isEmpty()) continue;
            JLabel label = new JLabel("<html>" + op.getName() + "<br/><small>" + op.getOperatorDescription().getName() + "</small></html>");
            label.setIcon(op.getOperatorDescription().getSmallIcon());
            label.setPreferredSize(new Dimension(190, 50));
            label.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            label.setVerticalAlignment(1);
            operatorPanel.add((Component)label, "West");
            GridLayout layout = new GridLayout(0, 4);
            layout.setHgap(6);
            layout.setVgap(6);
            JPanel parameterPanel = new JPanel(layout);
            int added = 0;
            Map<String, CustomParameterInfo> parameterMap = templateParameters != null ? templateParameters.get(op.getName()) : null;
            for (ParameterType type : parameterTypes) {
                if (type.isHidden()) continue;
                first = this.addParameter(type, op, parameterPanel, first, parameterMap, templateParameters != null, definesOptionals);
                ++added;
            }
            if (added == 1) {
                parameterPanel.add(new JLabel(""));
            }
            operatorPanel.add((Component)parameterPanel, "Center");
            operatorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            panel.add((Component)operatorPanel, c);
        }
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JPanel(new BorderLayout()), c);
        return panel;
    }

    private List<Operator> getSensibleOperators(Operator operator) {
        ArrayList<Operator> ops = new ArrayList<Operator>();
        this.addSensibleChildren(operator, ops);
        return ops;
    }

    private void addSensibleChildren(Operator operator, List<Operator> ops) {
        ops.add(operator);
        if (operator instanceof OperatorChain && !(operator instanceof CustomSubprocess)) {
            for (ExecutionUnit subprocess : ((OperatorChain)operator).getSubprocesses()) {
                for (Operator childOperator : subprocess.getChildOperators()) {
                    this.addSensibleChildren(childOperator, ops);
                }
            }
        }
    }

    private boolean addParameter(ParameterType type, Operator op, JPanel parameterPanel, boolean first, Map<String, CustomParameterInfo> infoMap, boolean hasMap, boolean definesOptionals) {
        CustomParameterInfo parameterInfo;
        String current;
        JCheckBox box = new JCheckBox(type.getKey());
        box.setSelected(false);
        parameterPanel.add(box);
        final CustomParameterInfo opp = new CustomParameterInfo(op.getName(), type.getKey());
        opp.setDocumentation(type.getDescription());
        opp.setOptional(type.isOptional());
        try {
            current = op.getParameterAsString(type.getKey());
            if (current == null) {
                current = "";
            }
            if (current.length() > 30) {
                current = current.substring(0, 28) + "[...]";
            }
        }
        catch (UndefinedParameterError e1) {
            current = "";
        }
        JLabel currentLabel = new JLabel(current);
        parameterPanel.add(currentLabel);
        final JTextField aliasField = new JTextField(type.getKey());
        aliasField.setPreferredSize(new Dimension(box.getWidth(), aliasField.getPreferredSize().height));
        aliasField.setVisible(false);
        aliasField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                opp.setAlias(aliasField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                opp.setAlias(aliasField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                opp.setAlias(aliasField.getText());
            }
        });
        parameterPanel.add(aliasField);
        final JTextField docuField = new JTextField(type.getDescription());
        docuField.setPreferredSize(new Dimension(box.getWidth(), docuField.getPreferredSize().height));
        docuField.setCaretPosition(0);
        docuField.setVisible(false);
        docuField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                opp.setDocumentation(docuField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                opp.setDocumentation(docuField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                opp.setDocumentation(docuField.getText());
            }
        });
        parameterPanel.add(docuField);
        box.addActionListener(e -> {
            if (box.isSelected()) {
                this.selectedParameters.add(opp);
                aliasField.setVisible(true);
                docuField.setVisible(true);
            } else {
                this.selectedParameters.remove(opp);
                docuField.setVisible(false);
                aliasField.setVisible(false);
            }
        });
        CustomParameterInfo customParameterInfo = parameterInfo = infoMap == null ? null : infoMap.get(type.getKey());
        if (parameterInfo != null) {
            String storedDescription;
            String storedAlias = parameterInfo.getAlias();
            if (storedAlias != null && !storedAlias.isEmpty()) {
                aliasField.setText(storedAlias);
            }
            if ((storedDescription = parameterInfo.getDocumentation()) != null && !storedDescription.isEmpty()) {
                docuField.setText(storedDescription);
            }
            if (definesOptionals) {
                opp.setOptional(parameterInfo.isOptional());
                opp.setExpert(parameterInfo.isExpert());
            }
            opp.setDependency(parameterInfo.getDependency());
        }
        if (parameterInfo != null || !hasMap && first && !current.equals(type.toString(type.getDefaultValue()))) {
            box.setSelected(true);
            this.selectedParameters.add(opp);
            aliasField.setVisible(true);
            docuField.setVisible(true);
            first = false;
        }
        return first;
    }

    void loadSelectedParameters(CustomOperatorTemplate template, Map<String, Map<String, CustomParameterInfo>> templateParameters, Map<Pair<String, String>, Integer> sortingMap) {
        this.selectedParameters.clear();
        JComponent checkboxTable = this.makeCheckboxTable((Operator)this.process.getRootOperator(), templateParameters, template.definesOptionals());
        ArrayList<CustomParameterInfo> asList = new ArrayList<CustomParameterInfo>(this.selectedParameters);
        asList.sort((o1, o2) -> {
            Integer forO1 = (Integer)sortingMap.get(new Pair((Object)o1.getOperator(), (Object)o1.getParameter()));
            Integer forO2 = (Integer)sortingMap.get(new Pair((Object)o2.getOperator(), (Object)o2.getParameter()));
            if (forO1 != null) {
                if (forO2 != null) {
                    return forO1 - forO2;
                }
                return 1;
            }
            if (forO2 != null) {
                return -1;
            }
            return o1.compareTo(o2);
        });
        this.selectedParameters.clear();
        this.selectedParameters.addAll(asList);
        this.tablePane.setViewportView((Component)checkboxTable);
    }

    String getDefinedName() {
        return this.nameField.getText();
    }

    void setDefinedName(String name) {
        this.nameField.setText(name);
    }

    String getIconName() {
        String icon = "painters_palette.png";
        String definedIcon = this.iconField.getText();
        if (definedIcon != null && !definedIcon.isEmpty()) {
            icon = definedIcon.trim() + ".png";
        }
        return icon;
    }

    void setIconName(String iconName) {
        this.iconField.setText(iconName);
    }

    String getColor() {
        if (this.colorCombobox.getSelectedIndex() == 0) {
            return null;
        }
        String colorValue = null;
        try {
            colorValue = (String)this.color.getCellEditorValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return colorValue;
    }

    void setColor(String colorString) {
        if (colorString == null) {
            this.colorCombobox.setSelectedIndex(0);
        } else {
            this.colorCombobox.setSelectedIndex(1);
            this.color.setEditorColor(ParameterTypeColor.string2Color((String)colorString));
        }
    }

    Set<CustomParameterInfo> getSelectedParameters() {
        return this.selectedParameters;
    }

    CustomModuleUtils.CustomOperatorType getCustomOperatorType() {
        return (CustomModuleUtils.CustomOperatorType)this.customOperatorTypeField.getSelectedItem();
    }

    void setCustomOperatorType(CustomModuleUtils.CustomOperatorType type) {
        this.customOperatorTypeField.setSelectedItem(type);
    }

    Map<String, RepositoryLocationValueCellEditor> getInputPortSchemaEditors() {
        return this.inputPortsSchemaEditors;
    }

    Map<String, RepositoryLocationValueCellEditor> getOutputPortsVisConfigEditors() {
        return this.outputPortsVisConfigEditors;
    }

    boolean hasCustomSubprocess() {
        return this.process.getAllOperators().stream().anyMatch(o -> o instanceof CustomSubprocess);
    }
}

