/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.Process;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.extension.processdefined.operator.parameter.AttributeSubsetParameterHelper;
import com.rapidminer.extension.processdefined.operator.parameter.ProcessSuggestionParameterHelper;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.xml.sax.SAXException;

enum CloudResolversCalculator {


    static ExtensionCreator.CreationError calculate(Path processes, JarOutputStream jarOut) {
        if (processes == null) {
            return null;
        }
        try {
            Map<String, String> fileContent = CloudResolversCalculator.calculate(processes);
            for (Map.Entry<String, String> entry : fileContent.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                jarOut.putNextEntry(new ZipEntry(entry.getKey()));
                jarOut.write(entry.getValue().getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (XMLException | IOException | SAXException e) {
            return new ExtensionCreator.CreationError("Failed to write resolver parameters", (Exception)e);
        }
        return null;
    }

    private static Map<String, String> calculate(Path processes) throws IOException, SAXException, XMLException {
        StringBuilder suggestionBuilder = new StringBuilder();
        StringBuilder fixedSubsetBuilder = new StringBuilder();
        for (Path path : ExtensionCreationHelper.getAllContent(processes)) {
            InputStream ins = Files.newInputStream(path, new OpenOption[0]);
            try {
                CustomOperatorTemplate template = new CustomOperatorTemplate(ins);
                Process process = template.getProcessWithoutGUI();
                for (CustomParameterInfo parameter : template.getParameters()) {
                    Operator operator;
                    if ("value".equals(parameter.getParameter()) && (operator = process.getOperator(parameter.getOperator())) instanceof ProcessSuggestionParameterHelper) {
                        CloudResolversCalculator.addToBuilder(path, parameter, suggestionBuilder);
                    }
                    if (!"value".equals(parameter.getParameter()) || !((operator = process.getOperator(parameter.getOperator())) instanceof AttributeSubsetParameterHelper) || !operator.getParameterAsBoolean("use_fixed_values")) continue;
                    CloudResolversCalculator.addToBuilder(path, parameter, fixedSubsetBuilder);
                }
            }
            finally {
                if (ins == null) continue;
                ins.close();
            }
        }
        HashMap<String, String> contents = new HashMap<String, String>();
        contents.put("com/rapidminer/extension/resources/process_operators/process_suggestion_parameters", suggestionBuilder.toString());
        contents.put("com/rapidminer/extension/resources/process_operators/from_enum_subset_parameters", fixedSubsetBuilder.toString());
        return contents;
    }

    private static void addToBuilder(Path path, CustomParameterInfo parameter, StringBuilder builder) {
        builder.append(ProcessDefinedOperators.toSnakeCase((String)path.getFileName().toString().replace(".cusop", ""))).append(":").append(parameter.getAlias()).append("\n");
    }
}

