/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitCustomOperatorCreator;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.tools.FileUtils;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ColorPropertiesCreator {
    private static final String COLOR_REGEX = "^\\s*<color>(.*?)</color>\\s*$";
    private static final Pattern COLOR_PATTERN = Pattern.compile("^\\s*<color>(.*?)</color>\\s*$", 8);
    private final Path originalFolder;
    private final String name;

    ColorPropertiesCreator(Path originalFolder, String name) {
        this.originalFolder = originalFolder;
        this.name = name;
    }

    ExtensionCreator.CreationError addColorContent(StringJoiner builder, Color extensionColor, Manifest manifest) {
        if (extensionColor != null) {
            String hex = String.format("#%02x%02x%02x", extensionColor.getRed(), extensionColor.getGreen(), extensionColor.getBlue());
            builder.add("group..color = " + hex);
        }
        if (RapidMiner.getVersion().isAbove(PluginInitCustomOperatorCreator.COLOR_SUPPORT_STUDIO_VERSION) && this.originalFolder != null) {
            if (!Files.exists(this.originalFolder, new LinkOption[0]) || !Files.isDirectory(this.originalFolder, new LinkOption[0])) {
                return new ExtensionCreator.CreationError("Folder " + this.originalFolder.toAbsolutePath() + " does not exist", null);
            }
            try {
                List<Path> pathList = ExtensionCreationHelper.getAllContent(this.originalFolder);
                for (Path entry : pathList) {
                    String fileName = entry.getFileName().toString().replace(".cusop", "");
                    this.colorLine(entry, fileName, builder);
                }
            }
            catch (IOException e) {
                return new ExtensionCreator.CreationError("Failed to read cusop file.", e);
            }
        }
        if (builder.length() > 0) {
            String nameInClasses = this.name.replace(" ", "");
            manifest.getMainAttributes().putValue("Group-Descriptor", "com/rapidminer/extension/resources/groups" + nameInClasses + ".properties");
        }
        return null;
    }

    private void colorLine(Path entry, String fileName, StringJoiner builder) throws IOException {
        String fileContent = FileUtils.readTextFile((Path)entry);
        Matcher matcher = COLOR_PATTERN.matcher(fileContent);
        if (matcher.find()) {
            String templateColor = matcher.group(1);
            Color color = ParameterTypeColor.string2Color((String)templateColor);
            String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            String key = ProcessDefinedOperators.toSnakeCase((String)fileName);
            builder.add("operator." + key + ".color = " + hex);
        }
    }
}

