/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.Process;
import com.rapidminer.extension.PluginInitCustomOperatorCreator;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.datastructure.PluginInitDataStructure;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.plugin.Plugin;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.xml.sax.SAXException;

enum DependencyCalculator {


    static String calculate(Path processes, String pluginKey) throws IOException, DataStructureNotAvailableException, SAXException, XMLException {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        boolean needsDataStructure = false;
        for (Path path : ExtensionCreationHelper.getAllContent(processes)) {
            CustomOperatorTemplate template = new CustomOperatorTemplate((InputStream)new FileInputStream(path.toString()));
            if (template.getCustomOperatorType() != CustomModuleUtils.CustomOperatorType.STANDARD) {
                if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
                    throw new DataStructureNotAvailableException(template.getCustomOperatorType());
                }
                needsDataStructure = true;
            }
            Process process = template.getProcessWithoutGUI();
            for (Operator operator : process.getAllOperators()) {
                Plugin plugin = operator.getOperatorDescription().getProvider();
                if (plugin == null) continue;
                plugins.add(plugin);
            }
        }
        plugins.add(Plugin.getPluginForClass(PluginInitCustomOperatorCreator.class));
        if (needsDataStructure) {
            plugins.add(Plugin.getPluginForClass(PluginInitDataStructure.class));
        }
        Plugin samePlugin = Plugin.getPluginByExtensionId((String)("rmx_" + pluginKey));
        plugins.remove(samePlugin);
        return DependencyCalculator.createPluginString(plugins);
    }

    static String calculateVersion() {
        Plugin customOpPlugin = Plugin.getPluginByExtensionId((String)"rmx_process_defined_operators");
        return "rmx_process_defined_operators[" + customOpPlugin.getVersion() + "]";
    }

    private static String createPluginString(Set<Plugin> plugins) {
        StringJoiner joiner = new StringJoiner("; ");
        for (Plugin plugin : plugins) {
            String extensionId = plugin.getExtensionId();
            joiner.add(extensionId + "[" + plugin.getVersion() + "]");
        }
        return joiner.toString();
    }

    static class DataStructureNotAvailableException
    extends Exception {
        private final CustomModuleUtils.CustomOperatorType customOperatorType;

        public DataStructureNotAvailableException(CustomModuleUtils.CustomOperatorType customOperatorType) {
            this.customOperatorType = customOperatorType;
        }

        public CustomModuleUtils.CustomOperatorType getCustomOperatorType() {
            return this.customOperatorType;
        }
    }
}

