/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.ExtensionCreator;
import com.rapidminer.extension.processdefined.util.CustomParameterInfo;
import com.rapidminer.extension.processdefined.util.PortInfo;
import com.rapidminer.extension.processdefined.util.TutorialInfo;
import com.rapidminer.tools.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

class DocumentationCreator {
    private static final String DOCU_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"../../../../../documentation2html.xsl\"?>\n<p1:documents xmlns:p1=\"http://rapid-i.com/schemas/documentation/reference/1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n              xsi:schemaLocation=\"http://rapid-i.com/schemas/documentation/reference/1.0                http://rapid-i.com/schemas/documentation/reference/1.0/documentation.xsd\">\n\n<operator key=\"operator.%s:%s\" locale=\"en\" version=\"1.0.0\">\n\t\n\t<title>%s</title>\n\t\t\n    <synopsis>%s</synopsis>\n\t\t\n    <text>\n        %s\n    </text>\n\n%s\n\n %s\n   %s\n</operator>\n</p1:documents>";
    private static final String PARAMETERS_TEMPLATE = "    <parameters>\n%s\n    </parameters>\n";
    private static final String PARAMETER_TEMPLATE = "        <parameter key=\"%s\">\n            %s\n        </parameter>\n";
    private static final String INPUT_PORTS_TEMPLATE = "    <inputPorts>\n%s    </inputPorts>\n";
    private static final String OUTPUT_PORTS_TEMPLATE = "    <outputPorts>\n%s    </outputPorts>\n";
    private static final String PORT_TEMPLATE_UNKNOWN = "        <port name=\"%s\">\n        </port>\n";
    private static final String PORT_TEMPLATE_KNOWN = "        <port name=\"%s\" type=\"%s\">\n            %s\n        </port>\n";
    private static final String TUTORIAL_PROCESS_TEMPLATE = "        <tutorialProcess key=\"process.%s\" title=\"%s\">\n            <description>\n               <paragraph>\n                  %s\n               </paragraph>\n            </description>\n            %s\n        </tutorialProcess>\n";
    private static final String TUTORIAL_PROCESSES_TEMPLATE = "    <tutorialProcesses>\n%s    </tutorialProcesses>\n";
    private final Path originalFolder;
    private final Path docuFolder;
    private final Path templateFolder;
    private final String snakeName;

    DocumentationCreator(Path originalFolder, Path docuFolder, Path templateFolder, String snakeName) {
        this.originalFolder = originalFolder;
        this.docuFolder = docuFolder;
        this.templateFolder = templateFolder;
        this.snakeName = snakeName;
    }

    ExtensionCreator.CreationError splitFiles() {
        if (!Files.exists(this.originalFolder, new LinkOption[0]) || !Files.isDirectory(this.originalFolder, new LinkOption[0])) {
            return new ExtensionCreator.CreationError("Folder " + this.originalFolder.toAbsolutePath().toString() + " does not exist", null);
        }
        Path documentationFolder = this.docuFolder.resolve(this.snakeName);
        try {
            List<Path> pathList = ExtensionCreationHelper.getAllContent(this.originalFolder);
            for (Path entry : pathList) {
                Path relativePath = this.originalFolder.relativize(entry);
                String relativeName = relativePath.toString().replace(".cusop", "");
                String fileName = entry.getFileName().toString().replace(".cusop", "");
                this.splitDocumentation(documentationFolder, entry, relativePath, relativeName, fileName);
            }
        }
        catch (SAXException e) {
            return new ExtensionCreator.CreationError("Could not parse cusop file.", e);
        }
        catch (XMLException e) {
            return new ExtensionCreator.CreationError("Could not write updated cusop file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            return new ExtensionCreator.CreationError("Failed to split off documentation from cusop file.", e);
        }
        return null;
    }

    private void splitDocumentation(Path documentationFolder, Path entry, Path relativePath, String relativeName, String fileName) throws IOException, SAXException, XMLException {
        try (InputStream ins = Files.newInputStream(entry, new OpenOption[0]);){
            CustomOperatorTemplate template = new CustomOperatorTemplate(ins);
            String key = ProcessDefinedOperators.toSnakeCase((String)fileName);
            String docu = DocumentationCreator.fillTemplate(this.snakeName, key, template.getName(), template.getSynopsis(), template.getDescription(), this.getPorts(template), this.getParameters(template), this.getTutorials(template, this.snakeName, key));
            String xmlName = StringUtils.removeEnd((String)relativeName, (String)fileName) + key + ".xml";
            Path docuPath = documentationFolder.resolve(xmlName);
            Files.createDirectories(docuPath.getParent(), new FileAttribute[0]);
            Files.write(docuPath, docu.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            Path templatePath = this.templateFolder.resolve(relativePath);
            Files.createDirectories(templatePath.getParent(), new FileAttribute[0]);
            template.writeWithoutDoku(templatePath);
        }
    }

    private String getTutorials(CustomOperatorTemplate template, String extensionKey, String operatorKey) {
        List tutorialInfos = template.getDocuInfos().getTutorialInfos();
        if (tutorialInfos.isEmpty() || tutorialInfos.stream().allMatch(TutorialInfo::isEmpty)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (TutorialInfo tutorialInfo : tutorialInfos) {
            String key = extensionKey + "." + operatorKey + "." + tutorialInfo.getTitleKey();
            builder.append(String.format(TUTORIAL_PROCESS_TEMPLATE, key, tutorialInfo.getTitle(), tutorialInfo.getDescription(), tutorialInfo.getProcessXml()));
        }
        return String.format(TUTORIAL_PROCESSES_TEMPLATE, builder.toString());
    }

    private String getPorts(CustomOperatorTemplate template) {
        int inputPorts = template.getInputPorts();
        int outputPorts = template.getOutputPorts();
        if (inputPorts < 0 || outputPorts < 0) {
            return "";
        }
        String inputs = "";
        List inputDocus = template.getDocuInfos().getInputPortInfos();
        List inputPortNames = template.getInputPortNames();
        if (inputPorts > 0) {
            StringBuilder inputBuilder = new StringBuilder();
            for (int i = 1; i <= inputPorts; ++i) {
                String name = "input " + i;
                if (inputPortNames.size() >= i) {
                    name = (String)inputPortNames.get(i - 1);
                }
                if (inputDocus.size() < i) {
                    inputBuilder.append(String.format(PORT_TEMPLATE_UNKNOWN, name));
                    continue;
                }
                PortInfo info = (PortInfo)inputDocus.get(i - 1);
                inputBuilder.append(String.format(PORT_TEMPLATE_KNOWN, name, info.getRawPortType(), info.getDescription()));
            }
            inputs = String.format(INPUT_PORTS_TEMPLATE, inputBuilder.toString());
        }
        String outputs = "";
        List outputDocus = template.getDocuInfos().getOutputPortInfos();
        List outputPortNames = template.getOutputPortNames();
        if (outputPorts > 0) {
            StringBuilder outputBuilder = new StringBuilder();
            for (int i = 1; i <= outputPorts; ++i) {
                String name = "result " + i;
                if (outputPortNames.size() >= i) {
                    name = (String)outputPortNames.get(i - 1);
                }
                if (outputDocus.size() < i) {
                    outputBuilder.append(String.format(PORT_TEMPLATE_UNKNOWN, name));
                    continue;
                }
                PortInfo info = (PortInfo)outputDocus.get(i - 1);
                outputBuilder.append(String.format(PORT_TEMPLATE_KNOWN, name, info.getRawPortType(), info.getDescription()));
            }
            outputs = String.format(OUTPUT_PORTS_TEMPLATE, outputBuilder.toString());
        }
        return inputs + outputs;
    }

    private String getParameters(CustomOperatorTemplate template) {
        StringBuilder builder = new StringBuilder();
        for (CustomParameterInfo parameter : template.getParameters()) {
            String documentation = parameter.getDocumentation();
            builder.append(String.format(PARAMETER_TEMPLATE, parameter.getAlias(), documentation == null ? "" : documentation));
        }
        return builder.toString();
    }

    private static String fillTemplate(String extensionKey, String operatorKey, String operatorName, String synopsis, String docu, String ports, String parameters, String tutorialProcesses) {
        return String.format(DOCU_TEMPLATE, extensionKey, operatorKey, operatorName, synopsis, docu, ports, parameters.isEmpty() ? "" : String.format(PARAMETERS_TEMPLATE, parameters), tutorialProcesses);
    }
}

