/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.processdefined.extension;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.PluginInitProcessDefinedOperators;
import com.rapidminer.extension.processdefined.CustomOperatorTemplate;
import com.rapidminer.extension.processdefined.ProcessDefinedOperators;
import com.rapidminer.extension.processdefined.extension.CloudResolversCalculator;
import com.rapidminer.extension.processdefined.extension.ColorPropertiesCreator;
import com.rapidminer.extension.processdefined.extension.DependencyCalculator;
import com.rapidminer.extension.processdefined.extension.DocumentationCreator;
import com.rapidminer.extension.processdefined.extension.ExtensionCreationHelper;
import com.rapidminer.extension.processdefined.extension.IconProcessor;
import com.rapidminer.extension.processdefined.extension.PluginInitDump;
import com.rapidminer.extension.processdefined.operator.HiddenProcessDefinedOperator;
import com.rapidminer.extension.processdefined.util.CustomModuleUtils;
import com.rapidminer.extension.processdefined.util.RepositoryUtils;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.WordUtils;
import org.xml.sax.SAXException;

public class ExtensionCreator {
    static final String PROCESS_OPERATORS_LOCATION = "com/rapidminer/extension/resources/process_operators/";
    static final String HIDDEN_REPO_LOCATION = "com/rapidminer/extension/resources/repository/";
    private static final Logger LOGGER = Logger.getLogger(ExtensionCreator.class.getName());
    private static final Pattern EXCLUDE_FROM_FAT_JAR = Pattern.compile("(^META-INF/INDEX\\.LIST$|^META-INF/.+?\\.(SF|DSA|RSA)$|^module-info\\.class$)");
    private final String vendor;
    private final String homepage;
    private final Path folder;
    private final Color color;
    private final String versionNumber;
    private final Path ioobjectsFolder;
    private final Path optionalJars;
    private final String iconName;
    private final Path additionalIcons;

    public ExtensionCreator(String vendor, String homepage, Path folder, Color color, String versionNumber, Path ioobjectsFolder, Path optionalJars, String iconName, Path additionalIcons) {
        this.vendor = vendor;
        this.homepage = homepage;
        this.folder = folder;
        this.color = color;
        this.versionNumber = versionNumber;
        this.ioobjectsFolder = ioobjectsFolder;
        this.optionalJars = optionalJars;
        this.additionalIcons = additionalIcons;
        this.iconName = iconName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreationError createExtension(String name, List<String> orderedFiles, boolean calculateDependencies, boolean hideProcesses, ProgressListener progressListener) {
        CreationError creationError;
        Path temp;
        int totalProgress = 13;
        if (this.additionalIcons != null) {
            ++totalProgress;
        }
        if (this.optionalJars != null) {
            ++totalProgress;
        }
        progressListener.setTotal(totalProgress);
        String originalName = name = name.trim();
        name = WordUtils.capitalizeFully((String)name);
        String snakeName = ProcessDefinedOperators.toSnakeCase((String)name);
        try {
            temp = Files.createTempDirectory("custom_extension", new FileAttribute[0]);
        }
        catch (IOException e) {
            return new CreationError("Failed to create temporary directory", e);
        }
        try {
            Manifest manifest;
            progressListener.setCompleted(1);
            try {
                manifest = this.createManifest(originalName, name, snakeName, hideProcesses);
            }
            catch (VersionNumber.VersionNumberException e) {
                CreationError creationError2 = new CreationError("Unparsable version number: " + e.getMessage(), (Exception)((Object)e));
                progressListener.complete();
                try {
                    FileUtils.deleteDirectory((File)temp.toFile());
                }
                catch (IOException e2) {
                    LOGGER.log(Level.WARNING, "Unable to delete temp folder", e2);
                }
                return creationError2;
            }
            progressListener.setCompleted(2);
            StringJoiner joiner = new StringJoiner("\n");
            CreationError error = new ColorPropertiesCreator(this.folder, name).addColorContent(joiner, this.color, manifest);
            if (error != null) {
                CreationError e2 = error;
                return e2;
            }
            String colorFile = joiner.length() > 0 ? joiner.toString() : null;
            progressListener.setCompleted(3);
            error = this.calculateDependencies(snakeName, calculateDependencies, manifest);
            if (error != null) {
                CreationError e = error;
                return e;
            }
            progressListener.setCompleted(5);
            String nameInFiles = name.replace(" ", "");
            manifest.getMainAttributes().putValue("Operator-Descriptor", "com/rapidminer/extension/resources/Operators" + nameInFiles + ".xml");
            String extensionJarName = snakeName + "-" + this.versionNumber + "-all.jar";
            Path path = temp.resolve(extensionJarName);
            error = this.createJar(orderedFiles, progressListener, snakeName, manifest, colorFile, nameInFiles, path, hideProcesses);
            if (error != null) {
                CreationError creationError3 = error;
                return creationError3;
            }
            CreationError creationError4 = error = ExtensionCreator.copyJarFile(snakeName, extensionJarName, path);
            return creationError4;
        }
        catch (InvalidPathException e) {
            creationError = new CreationError("Invalid name", e);
            return creationError;
        }
        catch (RuntimeException e) {
            creationError = new CreationError("Failed to create extension due to unexpected error.", e);
            return creationError;
        }
        finally {
            progressListener.complete();
            try {
                FileUtils.deleteDirectory((File)temp.toFile());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Unable to delete temp folder", e);
            }
        }
    }

    private static CreationError copyJarFile(String snakeName, String extensionJarName, Path path) {
        block18: {
            Path newPath = ExtensionCreationHelper.getExtensionsDir().resolve(extensionJarName);
            if (Files.exists(newPath, new LinkOption[0])) {
                URL resourceURL;
                String fullPath = "com/rapidminer/extension/resources/process_operators/CONTENTS";
                Plugin plugin = Plugin.getPluginByExtensionId((String)("rmx_" + snakeName));
                if (plugin != null && (resourceURL = plugin.getClassLoader().getResource(fullPath)) != null) {
                    try {
                        JarURLConnection urlConnection = (JarURLConnection)resourceURL.openConnection();
                        JarFile jarFile = urlConnection.getJarFile();
                        jarFile.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to close jar, reloading might fail", e);
                    }
                }
                try (FileInputStream is = new FileInputStream(path.toFile());
                     FileOutputStream os = new FileOutputStream(newPath.toFile());){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    FileUtils.touch((File)newPath.toFile());
                    break block18;
                }
                catch (IOException e) {
                    return new CreationError("Failed to overwrite existing extension in extensions folder", e);
                }
            }
            try {
                Files.copy(path, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                return new CreationError("Failed to copy extension to extensions folder", e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CreationError createJar(List<String> orderedFiles, ProgressListener progressListener, String snakeName, Manifest manifest, String colorFile, String nameInFiles, Path jarPath, boolean hideProcesses) {
        int completed = 5;
        try (OutputStream fileOut = Files.newOutputStream(jarPath, StandardOpenOption.CREATE_NEW);
             JarOutputStream jarOut = new JarOutputStream(fileOut, manifest);){
            CreationError creationError;
            DocumentationCreator documentationCreator;
            CreationError error;
            ExtensionCreator.addPluginInit(nameInFiles, snakeName, jarOut);
            progressListener.setCompleted(++completed);
            ExtensionCreator.addColorFile(colorFile, manifest, jarOut);
            ExtensionCreator.addOperatorsFile(manifest, jarOut);
            progressListener.setCompleted(++completed);
            Path docuFolder = jarPath.getParent().resolve("Doku");
            Path templatesFolder = jarPath.getParent().resolve("Templates");
            if (this.folder != null && (error = (documentationCreator = new DocumentationCreator(this.folder, docuFolder, templatesFolder, snakeName)).splitFiles()) != null) {
                CreationError creationError2 = error;
                return creationError2;
            }
            progressListener.setCompleted(++completed);
            if (this.folder != null && (error = this.copyDocuFiles(jarOut, docuFolder)) != null) {
                creationError = error;
                return creationError;
            }
            progressListener.setCompleted(++completed);
            if (this.folder != null && (error = this.copyCustomOperators(jarOut, orderedFiles, hideProcesses, templatesFolder)) != null) {
                creationError = error;
                return creationError;
            }
            progressListener.setCompleted(++completed);
            error = this.copyRepoFiles(jarOut);
            if (error != null) {
                creationError = error;
                return creationError;
            }
            if (this.additionalIcons != null) {
                error = IconProcessor.addIcons(this.additionalIcons, jarOut);
                if (error != null) {
                    creationError = error;
                    return creationError;
                }
                progressListener.setCompleted(++completed);
            }
            if ((error = this.copyIcon(jarOut)) != null) {
                creationError = error;
                return creationError;
            }
            progressListener.setCompleted(++completed);
            if (this.optionalJars != null) {
                error = this.copyOptionalJars(jarOut);
                if (error != null) {
                    creationError = error;
                    return creationError;
                }
                progressListener.setCompleted(++completed);
            }
            if ((error = CloudResolversCalculator.calculate(this.folder, jarOut)) != null) {
                creationError = error;
                return creationError;
            }
            progressListener.setCompleted(++completed);
            return null;
        }
        catch (IOException e) {
            return new CreationError("Failed to create the jar", e);
        }
    }

    private CreationError copyDocuFiles(ZipOutputStream zipOut, Path docuFolder) {
        if (Files.exists(docuFolder, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(docuFolder, new FileVisitOption[0]);){
                for (Path entry : (Path[])stream.toArray(Path[]::new)) {
                    if (Files.isDirectory(entry, new LinkOption[0])) continue;
                    String name = docuFolder.relativize(entry).toString().replace(File.separatorChar, '/');
                    zipOut.putNextEntry(new ZipEntry(name));
                    Files.copy(entry, zipOut);
                }
            }
            catch (IOException e) {
                return new CreationError("Failed to copy docu files", e);
            }
        }
        return null;
    }

    private CreationError copyIcon(ZipOutputStream jarOut) {
        if (this.iconName == null || this.iconName.isEmpty()) {
            return null;
        }
        return IconProcessor.copyExtensionIcon(this.iconName, this.additionalIcons, jarOut);
    }

    private Manifest createManifest(String originalName, String name, String snakeName, boolean hideProcesses) {
        VersionNumber number = new VersionNumber(this.versionNumber);
        String versionString = number.getShortLongVersion();
        Manifest man = new Manifest();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("RapidMiner-Version", RapidMiner.getVersion().getShortLongVersion());
        man.getMainAttributes().putValue("Implementation-Title", originalName);
        man.getMainAttributes().putValue("Implementation-Version", versionString);
        man.getMainAttributes().putValue("Specification-Vendor", "RapidMiner GmbH");
        man.getMainAttributes().putValue("Specification-Title", originalName);
        man.getMainAttributes().putValue("RapidMiner-Type", "RapidMiner_Extension");
        man.getMainAttributes().putValue("Implementation-Vendor", this.vendor);
        man.getMainAttributes().putValue("Extension-ID", "rmx_" + snakeName);
        man.getMainAttributes().putValue("Namespace", snakeName);
        man.getMainAttributes().putValue("Created-By", "RapidMiner GmbH");
        man.getMainAttributes().putValue("Specification-Version", versionString);
        man.getMainAttributes().putValue("Implementation-URL", this.homepage.isEmpty() ? "unknown" : this.homepage);
        man.getMainAttributes().putValue("Initialization-Class", "com.rapidminer.extension." + snakeName + ".PluginInit" + name.replace(" ", ""));
        if (hideProcesses) {
            man.getMainAttributes().putValue("hide_defining_processes", Boolean.TRUE.toString());
        }
        return man;
    }

    private CreationError copyOptionalJars(JarOutputStream jarOut) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.optionalJars, "*.jar");){
            HashSet<String> duplicateNameCheck = new HashSet<String>();
            HashMap<String, Set> servicesMap = new HashMap<String, Set>();
            for (Path path : stream) {
                InputStream is = Files.newInputStream(path, StandardOpenOption.READ);
                try (JarInputStream jarIn = new JarInputStream(is);){
                    ZipEntry nextEntry;
                    while ((nextEntry = jarIn.getNextEntry()) != null) {
                        Matcher matcher;
                        if (nextEntry.getName().startsWith("META-INF/services/") && !nextEntry.getName().equals("META-INF/services/")) {
                            String line;
                            Set lines = servicesMap.computeIfAbsent(nextEntry.getName(), k -> new LinkedHashSet());
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)jarIn, StandardCharsets.UTF_8));
                            while ((line = reader.readLine()) != null) {
                                lines.add(line);
                            }
                            jarIn.closeEntry();
                            continue;
                        }
                        if (duplicateNameCheck.contains(nextEntry.getName()) || (matcher = EXCLUDE_FROM_FAT_JAR.matcher(nextEntry.getName())).matches()) continue;
                        jarOut.putNextEntry(nextEntry);
                        IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut);
                        duplicateNameCheck.add(nextEntry.getName());
                        jarIn.closeEntry();
                        jarOut.closeEntry();
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            for (Map.Entry entry : servicesMap.entrySet()) {
                jarOut.putNextEntry(new ZipEntry((String)entry.getKey()));
                for (String line : (Set)entry.getValue()) {
                    jarOut.write((line + "\n").getBytes(StandardCharsets.UTF_8));
                }
                jarOut.closeEntry();
            }
        }
        catch (IOException e) {
            return new CreationError("Failed to copy from folder additional jars", e);
        }
        return null;
    }

    private static void addOperatorsFile(Manifest manifest, JarOutputStream jarOut) throws IOException {
        jarOut.putNextEntry(new ZipEntry(manifest.getMainAttributes().getValue("Operator-Descriptor")));
        String title = manifest.getMainAttributes().getValue("Implementation-Title");
        String docBundle = "com/rapidminer/extension/resources/OperatorsDoc" + title.replace(" ", "");
        jarOut.write(("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<operators name=\"" + manifest.getMainAttributes().getValue("Namespace") + "\" version=\"6.0\" docbundle=\"" + docBundle + "\">\n        <factory>\n            com.rapidminer.extension.processdefined.CustomOperatorFactory\n        </factory>\n</operators>").getBytes(StandardCharsets.UTF_8));
        jarOut.putNextEntry(new ZipEntry(docBundle + ".xml"));
        jarOut.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><operatorHelp lang=\"en_EN\">\n</operatorHelp>".getBytes(StandardCharsets.UTF_8));
    }

    private static void addColorFile(String colorFile, Manifest manifest, JarOutputStream jarOut) throws IOException {
        if (colorFile != null) {
            jarOut.putNextEntry(new ZipEntry(manifest.getMainAttributes().getValue("Group-Descriptor")));
            jarOut.write(colorFile.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void addPluginInit(String name, String namespace, JarOutputStream jarOut) throws IOException {
        jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/" + namespace + "/PluginInit" + name + ".class"));
        jarOut.write(PluginInitDump.dump(name, namespace));
    }

    private CreationError calculateDependencies(String extensionKey, boolean calculateDependencies, Manifest manifest) {
        String dependencies;
        try {
            dependencies = calculateDependencies && this.folder != null ? DependencyCalculator.calculate(this.folder, extensionKey) : DependencyCalculator.calculateVersion();
        }
        catch (IOException e) {
            return new CreationError("Failed to access defining processes", e);
        }
        catch (XMLException | SAXException e) {
            return new CreationError("Failed to parse defining processes", (Exception)e);
        }
        catch (DependencyCalculator.DataStructureNotAvailableException e) {
            return new CreationError("The type of the custom operator is " + e.getCustomOperatorType() + " but the data-structure extension is not available.", e);
        }
        manifest.getMainAttributes().putValue("Plugin-Dependencies", dependencies);
        return null;
    }

    private CreationError copyCustomOperators(ZipOutputStream zipOut, List<String> orderedFiles, boolean hideProcesses, Path templateFolder) {
        ArrayList<String> cusOpFiles = new ArrayList<String>(orderedFiles);
        try {
            List<Path> pathList = ExtensionCreationHelper.getAllContent(templateFolder);
            CreationError e = this.handleDataStructureObjects(pathList, zipOut);
            if (e != null) {
                return e;
            }
            if (hideProcesses) {
                this.copyObfuscated(zipOut, cusOpFiles, pathList, templateFolder);
            } else {
                this.copyUnchanged(zipOut, cusOpFiles, pathList, templateFolder);
            }
        }
        catch (IOException e) {
            return new CreationError("Failed to copy from folder " + templateFolder.toAbsolutePath().toString(), e);
        }
        CreationError e = ExtensionCreator.setupContents(cusOpFiles, zipOut);
        if (e != null) {
            return e;
        }
        if (cusOpFiles.isEmpty()) {
            LOGGER.warning(() -> "No .cusop files found in the specified folder " + (this.folder == null ? "[empty]" : this.folder.toAbsolutePath().toString()));
        } else {
            LOGGER.info(() -> "Successfully copied " + cusOpFiles.size() + " custom operator files.");
        }
        return null;
    }

    private void copyUnchanged(ZipOutputStream zipOut, List<String> cusOpFiles, List<Path> list, Path relativeTo) throws IOException {
        ArrayList<String> cusOpFilesCopy = new ArrayList<String>(cusOpFiles);
        for (Path entry : list) {
            String nameWithExtension = relativeTo.relativize(entry).toString().replace(File.separatorChar, '/');
            String nameWithoutExtension = ExtensionCreator.removeLast(nameWithExtension, ".cusop");
            zipOut.putNextEntry(new ZipEntry(PROCESS_OPERATORS_LOCATION + nameWithExtension));
            Files.copy(entry, zipOut);
            if (!cusOpFiles.contains(nameWithoutExtension)) {
                cusOpFiles.add(nameWithoutExtension);
                continue;
            }
            cusOpFilesCopy.remove(nameWithoutExtension);
        }
        if (!cusOpFilesCopy.isEmpty()) {
            cusOpFiles.removeAll(cusOpFilesCopy);
        }
    }

    private void copyObfuscated(ZipOutputStream zipOut, List<String> cusOpFiles, List<Path> list, Path relativeTo) throws IOException {
        byte[] arr = HiddenProcessDefinedOperator.class.getSimpleName().getBytes(StandardCharsets.UTF_8);
        SecretKeySpec obfuscator = new SecretKeySpec(arr, 0, 16, "AES");
        try {
            Cipher ob = Cipher.getInstance("AES");
            ob.init(1, obfuscator);
            ArrayList<String> cusOpFilesCopy = new ArrayList<String>(cusOpFiles);
            for (Path entry : list) {
                String nameWithExtension = relativeTo.relativize(entry).toString().replace(File.separatorChar, '/');
                String nameWithoutExtension = ExtensionCreator.removeLast(nameWithExtension, ".cusop");
                zipOut.putNextEntry(new ZipEntry(PROCESS_OPERATORS_LOCATION + nameWithExtension));
                try (InputStream fis = Files.newInputStream(entry, new OpenOption[0]);
                     CipherInputStream is = new CipherInputStream(fis, ob);){
                    IOUtils.copy((InputStream)is, (OutputStream)zipOut);
                }
                if (!cusOpFiles.contains(nameWithoutExtension)) {
                    cusOpFiles.add(nameWithoutExtension);
                    continue;
                }
                cusOpFilesCopy.remove(nameWithoutExtension);
            }
            if (!cusOpFilesCopy.isEmpty()) {
                cusOpFiles.removeAll(cusOpFilesCopy);
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IOException("Failed to obfuscate: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreationError handleDataStructureObjects(List<Path> pathList, ZipOutputStream jarOut) {
        ZipOutputStream zos;
        boolean foundNonStandard = false;
        LinkedHashMap<Path, String> schemaObjects = new LinkedHashMap<Path, String>();
        LinkedHashMap<Path, String> visConfigObjects = new LinkedHashMap<Path, String>();
        try {
            for (Path path : pathList) {
                CustomOperatorTemplate template = new CustomOperatorTemplate((InputStream)new FileInputStream(path.toString()));
                if (template.getCustomOperatorType().equals((Object)CustomModuleUtils.CustomOperatorType.STANDARD)) continue;
                foundNonStandard = true;
                if (!PluginInitProcessDefinedOperators.isDataStructurePresent()) {
                    return new CreationError("The type of the custom operator is " + template.getCustomOperatorType() + " but the data-structure extension is not available.", new Exception());
                }
                for (Map.Entry entry : template.getInputPortSchemaMap().entrySet()) {
                    schemaObjects.put(RepositoryUtils.locationToCusopPath((String)((String)entry.getValue() + "." + "data_schema_json")), CustomModuleUtils.makeRelative((String)((String)entry.getValue() + "." + "data_schema_json")));
                }
                for (Map.Entry entry : template.getOutputPortVisConfigMap().entrySet()) {
                    visConfigObjects.put(RepositoryUtils.locationToCusopPath((String)((String)entry.getValue())), CustomModuleUtils.makeRelative((String)((String)entry.getValue())));
                }
            }
        }
        catch (IOException e) {
            return new CreationError("Unable to open cusop file.", e);
        }
        catch (SAXException e) {
            return new CreationError("Unable to parse cusop file.", e);
        }
        if (!schemaObjects.isEmpty()) {
            try {
                jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/repository/schema"));
            }
            catch (IOException e) {
                return new CreationError("Unable to create repository file", e);
            }
            zos = new ZipOutputStream(jarOut);
            try {
                for (Map.Entry entry : schemaObjects.entrySet()) {
                    if (!Files.exists((Path)entry.getKey(), new LinkOption[0])) {
                        CreationError creationError = new CreationError("Schema object file: " + ((Path)entry.getKey()).toString() + " does not exist", null);
                        return creationError;
                    }
                    zos.putNextEntry(new ZipEntry((String)entry.getValue()));
                    Files.copy((Path)entry.getKey(), zos);
                    zos.closeEntry();
                }
            }
            catch (IOException iOException) {
                Map.Entry entry;
                entry = new CreationError("Failed to copy file.", iOException);
                return entry;
            }
            finally {
                try {
                    zos.finish();
                }
                catch (IOException e) {
                    return new CreationError("Failed finish creating repo zip", e);
                }
            }
        }
        if (foundNonStandard) {
            try {
                jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/repository/visualizationConfigs"));
            }
            catch (IOException e) {
                return new CreationError("Unable to create repository file", e);
            }
        }
        if (!visConfigObjects.isEmpty()) {
            zos = new ZipOutputStream(jarOut);
            try {
                for (Map.Entry entry : visConfigObjects.entrySet()) {
                    if (!Files.exists((Path)entry.getKey(), new LinkOption[0])) {
                        CreationError e = new CreationError("Visualization Config file: " + ((Path)entry.getKey()).toString() + " does not exist", null);
                        return e;
                    }
                    zos.putNextEntry(new ZipEntry((String)entry.getValue()));
                    Files.copy((Path)entry.getKey(), zos);
                    zos.closeEntry();
                }
            }
            catch (IOException iOException) {
                CreationError creationError = new CreationError("Failed to copy file.", iOException);
                return creationError;
            }
            finally {
                try {
                    zos.finish();
                }
                catch (IOException e) {
                    return new CreationError("Failed finish creating repo zip", e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CreationError copyRepoFiles(ZipOutputStream jarOut) {
        if (this.ioobjectsFolder == null) {
            return null;
        }
        if (!Files.exists(this.ioobjectsFolder, new LinkOption[0]) && !Files.isDirectory(this.ioobjectsFolder, new LinkOption[0])) {
            return new CreationError("Folder " + this.ioobjectsFolder.toAbsolutePath().toString() + " does not exist", null);
        }
        try {
            jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/repository/data"));
        }
        catch (IOException e) {
            return new CreationError("Unable to create repository file", e);
        }
        ZipOutputStream zos = new ZipOutputStream(jarOut);
        try (Stream<Path> stream = Files.walk(this.ioobjectsFolder, new FileVisitOption[0]);){
            for (Path entry : (Path[])stream.toArray(Path[]::new)) {
                if (Files.isDirectory(entry, new LinkOption[0])) continue;
                zos.putNextEntry(new ZipEntry(this.ioobjectsFolder.relativize(entry).toString().replace(File.separatorChar, '/')));
                Files.copy(entry, zos);
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            CreationError creationError = new CreationError("Failed to copy from folder " + this.ioobjectsFolder.toAbsolutePath().toString(), e);
            return creationError;
        }
        finally {
            try {
                zos.finish();
            }
            catch (IOException e) {
                return new CreationError("Failed finish creating repo zip", e);
            }
        }
        byte[] bytes = ByteBuffer.allocate(8).putLong(System.currentTimeMillis()).array();
        try {
            jarOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/repository/timestamp"));
            jarOut.write(bytes);
        }
        catch (IOException e) {
            return new CreationError("Failed to create timestamp file", e);
        }
        return null;
    }

    private static CreationError setupContents(List<String> cusOpFiles, ZipOutputStream zipOut) {
        try {
            zipOut.putNextEntry(new ZipEntry("com/rapidminer/extension/resources/process_operators/CONTENTS"));
            zipOut.write(cusOpFiles.stream().map(name -> "ENTRY " + name).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return new CreationError("Failed to write contents file", e);
        }
        return null;
    }

    private static String removeLast(String string, String toReplace) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + string.substring(pos + toReplace.length());
        }
        return string;
    }

    public static class CreationError {
        private final String message;
        private final Exception exception;

        CreationError(String message, Exception exception) {
            this.message = message;
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }

        String getMessage() {
            return this.message;
        }
    }
}

