/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.object.ColumnExpr;
import com.rapidminer.extension.indatabase.metadata.DbMetaDataTools;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Ontology;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DbTools {
    public static final int MAX_EX_MSG_LENGTH = 230;
    private static final int MAX_EX_MSG_LOG_LENGTH = 1000;
    private static final long STATEMENT_POLLING_INTERVAL_MS = 300L;
    public static final ThreadLocal<DateFormat> RAPIDMINER_FORMAT_DATE_TIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("MM/dd/yyyy h:mm:ss a", Locale.ENGLISH));
    public static final ThreadLocal<DateFormat> DEFAULT_DB_FORMAT_DATE_TIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH));
    private static final ThreadLocal<DateFormat> RAPIDMINER_FORMAT_DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat("MM/dd/yyyy", Locale.ENGLISH));
    private static final ThreadLocal<DateFormat> DEFAULT_DB_FORMAT_DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH));
    private static final ThreadLocal<DateFormat> RAPIDMINER_FORMAT_TIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("h:mm:ss a", Locale.ENGLISH));
    private static final String DEFAULT_TIME_FORMAT_PATTERN = "HH:mm:ss";
    private static final ThreadLocal<DateFormat> DEFAULT_DB_FORMAT_TIME = ThreadLocal.withInitial(() -> new SimpleDateFormat(DEFAULT_TIME_FORMAT_PATTERN, Locale.ENGLISH));

    private DbTools() {
    }

    public static String defaultFormat(String value, int type) {
        try {
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 10)) {
                Date date = RAPIDMINER_FORMAT_DATE.get().parse(value);
                return DEFAULT_DB_FORMAT_DATE.get().format(date);
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 11)) {
                Date date = RAPIDMINER_FORMAT_TIME.get().parse(value);
                return DEFAULT_DB_FORMAT_TIME.get().format(date);
            }
            if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(type, 9)) {
                Date date = RAPIDMINER_FORMAT_DATE_TIME.get().parse(value);
                return DEFAULT_DB_FORMAT_DATE_TIME.get().format(date);
            }
            return value;
        }
        catch (ParseException e) {
            return value;
        }
    }

    public static String formatErrorMessage(Throwable t) {
        Object details = t.getMessage();
        if (details == null || ((String)details).isEmpty()) {
            details = t.toString();
        }
        if (((String)details).length() > 230) {
            String str = details;
            LogService.getRoot().fine(() -> String.format("%s%s", str.substring(0, Math.min(str.length(), 1000)), str.length() > 1000 ? "..." : ""));
            details = ((String)details).substring(0, 230) + "...";
        }
        return details;
    }

    public static String getReadableRootCause(Throwable t) {
        Throwable j = t;
        while (j.getCause() != null) {
            j = j.getCause();
        }
        String errorMessage = j.getMessage();
        Pattern p = Pattern.compile(".*\"error_description\"\\s*:\\s*\"([^\"]*?)\".*");
        Matcher m = p.matcher(errorMessage);
        if (m.find()) {
            errorMessage = m.group(1);
        }
        return errorMessage;
    }

    public static List<String> sortedList(Collection<String> s) {
        ArrayList<String> res = new ArrayList<String>(s.size());
        res.addAll(s);
        Collections.sort(res);
        return res;
    }

    public static <T> T pollForResult(Nest nest, QueryRunner queryRunner, Future<T> future) throws SQLException, InterruptedException, ExecutionException, ProcessStoppedException {
        T result = null;
        while (!future.isDone()) {
            try {
                result = future.get(300L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                try {
                    nest.checkForStop();
                }
                catch (ProcessStoppedException pse) {
                    queryRunner.cancel();
                    future.cancel(true);
                    throw pse;
                }
            }
        }
        if (result == null) {
            result = future.get();
        }
        return result;
    }

    public static Column buildFirstNonNullExpr(DatabaseProvider provider, Column c1, Column c2) {
        return new ColumnExpr(provider.generateFirstNonNullExpr(c1.toSql(provider), c2.toSql(provider)), c1.getDestCol(), DbMetaDataTools.getTheMoreGeneralSqlType(c1.getType(), c2.getType()));
    }

    public static String newUniqueAlias(String newName, List<String> columnList) {
        boolean unique;
        Object result = newName;
        block0: do {
            unique = true;
            for (String element : columnList) {
                if (!((String)result).equalsIgnoreCase(element)) continue;
                result = (String)result + "_";
                unique = false;
                continue block0;
            }
        } while (!unique);
        return result;
    }

    public static String newUniqueAlias(List<Column> columnList, String newName) {
        List<String> columns = columnList.stream().map(Column::getDestCol).collect(Collectors.toList());
        return DbTools.newUniqueAlias(newName, columns);
    }

    public static boolean isDateValid(int attrType, String dateStr) {
        try {
            DateTimeFormatter dateFormatter;
            if (attrType == 11) {
                dateFormatter = DateTimeFormatter.ofPattern("h:mm:ss a", Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
            } else if (attrType == 10) {
                dateFormatter = DateTimeFormatter.ofPattern("MM/dd/uuuu", Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
            } else if (attrType == 9) {
                dateFormatter = DateTimeFormatter.ofPattern("MM/dd/uuuu h:mm:ss a", Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
            } else {
                return true;
            }
            dateFormatter.parse(dateStr);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    public static String notValidDateErrorMessage(DatabaseProvider provider, int attrType, String filterValue, String attName) {
        String validFormatExample1;
        String validFormat;
        String errorMessage = "The filter value '%s' for the attribute '%s' is not in a valid format (e.g. a valid format is: '%s'). Formatting example: '%s' or '%s'";
        if (attrType == 11) {
            validFormat = "h:mm:ss a";
            validFormatExample1 = "4:30:00 PM";
        } else if (attrType == 10) {
            validFormat = "MM/dd/yyyy";
            validFormatExample1 = "02/21/2022";
        } else if (attrType == 9) {
            validFormat = "MM/dd/yyyy h:mm:ss a";
            validFormatExample1 = "02/21/2022 4:30:00 PM";
        } else {
            return String.format("The filter value '%s' for the attribute '%s' is not in a valid format", filterValue, attName);
        }
        String validFormatExample2 = provider.format(validFormatExample1, new Column("dummy1", attrType));
        return String.format(errorMessage, filterValue, attName, validFormat, validFormatExample1, validFormatExample2);
    }

    public static class LimitedSizeHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -312217979379485278L;
        private final int sizeLimit;

        public LimitedSizeHashMap(int sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.sizeLimit;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LimitedSizeHashMap other = (LimitedSizeHashMap)obj;
            return this.sizeLimit == other.sizeLimit;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.sizeLimit;
        }
    }
}

