/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase;

import com.rapidminer.extension.indatabase.operator.AggregateOperator;
import com.rapidminer.extension.indatabase.operator.AttributeOrdering;
import com.rapidminer.extension.indatabase.operator.ConvertType;
import com.rapidminer.extension.indatabase.operator.CustomSqlOperator;
import com.rapidminer.extension.indatabase.operator.DeclareMissing;
import com.rapidminer.extension.indatabase.operator.DistinctOperator;
import com.rapidminer.extension.indatabase.operator.FilterOperator;
import com.rapidminer.extension.indatabase.operator.GenerateAttributes;
import com.rapidminer.extension.indatabase.operator.GenerateRank;
import com.rapidminer.extension.indatabase.operator.JoinOperator;
import com.rapidminer.extension.indatabase.operator.Multiply;
import com.rapidminer.extension.indatabase.operator.NestedOperator;
import com.rapidminer.extension.indatabase.operator.RenameByReplacing;
import com.rapidminer.extension.indatabase.operator.RenameOperator;
import com.rapidminer.extension.indatabase.operator.ReplaceMissing;
import com.rapidminer.extension.indatabase.operator.ReplaceValue;
import com.rapidminer.extension.indatabase.operator.RetrieveOperator;
import com.rapidminer.extension.indatabase.operator.SampleOperator;
import com.rapidminer.extension.indatabase.operator.SamplingOperator;
import com.rapidminer.extension.indatabase.operator.SelectOperator;
import com.rapidminer.extension.indatabase.operator.SortOperator;
import com.rapidminer.extension.indatabase.operator.StoreOperator;
import com.rapidminer.extension.indatabase.operator.Subprocess;
import com.rapidminer.extension.indatabase.operator.UnionOperator;
import com.rapidminer.operator.Operator;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.plugin.Plugin;
import java.util.LinkedHashMap;
import java.util.Map;

public class OperatorMap {
    public static final String RETRIEVE_OPERATOR_CLASS = "com.rapidminer.operator.io.RepositorySource";
    private static final Map<Class<? extends Operator>, String> indbToStandardOperatorMapping = new LinkedHashMap<Class<? extends Operator>, String>();
    private static final Map<String, Class<? extends Operator>> standardToIndbOperatorMapping = new LinkedHashMap<String, Class<? extends Operator>>();

    private static void registerMapping(Class<? extends Operator> indatabaseOperator, String standardOperator) {
        indbToStandardOperatorMapping.put(indatabaseOperator, standardOperator);
        standardToIndbOperatorMapping.put(standardOperator, indatabaseOperator);
    }

    private OperatorMap() {
    }

    public static Class<? extends Operator> getIndatabaseOperatorFor(Operator standardRapidMinerOperator) {
        Class<? extends Operator> clazz = standardToIndbOperatorMapping.get(standardRapidMinerOperator.getClass().getCanonicalName());
        if (clazz == null) {
            throw new IllegalArgumentException(I18N.getErrorMessage((String)"process.error.operatormap.no_equivalent", (Object[])new Object[]{standardRapidMinerOperator.getClass().getCanonicalName()}));
        }
        return clazz;
    }

    public static Class<? extends Operator> getStandardOperatorFor(Operator indatabaseoperator) {
        String className = indbToStandardOperatorMapping.get(indatabaseoperator.getClass());
        if (className != null) {
            try {
                return Class.forName(className, true, Plugin.getMajorClassLoader());
            }
            catch (ClassNotFoundException e) {
                LogService.getRoot().fine(I18N.getErrorMessage((String)"process.error.operatormap.class_not_found", (Object[])new Object[]{indatabaseoperator.getClass().getCanonicalName()}));
            }
        }
        throw new IllegalArgumentException(I18N.getErrorMessage((String)"process.error.operatormap.no_equivalent", (Object[])new Object[]{indatabaseoperator.getClass().getCanonicalName()}));
    }

    public static boolean canConvertToIndatabase(Operator op) {
        return standardToIndbOperatorMapping.containsKey(op.getClass().getCanonicalName());
    }

    public static boolean canConvertToStandard(Operator op) {
        return indbToStandardOperatorMapping.containsKey(op.getClass());
    }

    public static boolean isExecutableInIndatabase(Operator op) {
        return op instanceof NestedOperator;
    }

    static {
        OperatorMap.registerMapping(RetrieveOperator.class, "com.rapidminer.extension.jdbc.operator.io.DatabaseDataReader");
        OperatorMap.registerMapping(RetrieveOperator.class, "eu.radoop.io.HiveRetrieve");
        OperatorMap.registerMapping(RetrieveOperator.class, RETRIEVE_OPERATOR_CLASS);
        OperatorMap.registerMapping(StoreOperator.class, "com.rapidminer.extension.jdbc.operator.io.DatabaseDataWriter");
        OperatorMap.registerMapping(StoreOperator.class, "eu.radoop.io.HiveStore");
        OperatorMap.registerMapping(StoreOperator.class, "com.rapidminer.operator.io.RepositoryStorer");
        OperatorMap.registerMapping(SampleOperator.class, "eu.radoop.manipulation.HiveExampleFilterRange");
        OperatorMap.registerMapping(SampleOperator.class, "com.rapidminer.operator.preprocessing.filter.ExampleRangeFilter");
        OperatorMap.registerMapping(SamplingOperator.class, "com.rapidminer.operator.preprocessing.sampling.StratifiedSamplingOperator");
        OperatorMap.registerMapping(SamplingOperator.class, "com.rapidminer.operator.preprocessing.sampling.BootstrappingOperator");
        OperatorMap.registerMapping(SamplingOperator.class, "com.rapidminer.operator.preprocessing.sampling.KennardStoneSampling");
        OperatorMap.registerMapping(SamplingOperator.class, "com.rapidminer.operator.preprocessing.sampling.ModelBasedSampling");
        OperatorMap.registerMapping(SamplingOperator.class, "eu.radoop.manipulation.HiveSample");
        OperatorMap.registerMapping(SamplingOperator.class, "com.rapidminer.operator.preprocessing.sampling.SamplingOperator");
        OperatorMap.registerMapping(ConvertType.class, "com.rapidminer.operator.preprocessing.filter.NominalToNumeric");
        OperatorMap.registerMapping(ConvertType.class, "com.rapidminer.operator.preprocessing.filter.Real2Integer");
        OperatorMap.registerMapping(ConvertType.class, "com.rapidminer.operator.preprocessing.filter.NumericToBinominal");
        OperatorMap.registerMapping(ConvertType.class, "eu.radoop.manipulation.HiveTypeConversion");
        OperatorMap.registerMapping(ConvertType.class, "com.rapidminer.operator.preprocessing.filter.NumericToPolynominal");
        OperatorMap.registerMapping(AggregateOperator.class, "com.rapidminer.operator.features.construction.AttributeAggregationOperator");
        OperatorMap.registerMapping(AggregateOperator.class, "eu.radoop.manipulation.HiveAggregate");
        OperatorMap.registerMapping(AggregateOperator.class, "com.rapidminer.operator.preprocessing.transformation.aggregation.AggregationOperator");
        OperatorMap.registerMapping(GenerateAttributes.class, " com.rapidminer.operator.preprocessing.filter.AttributeAdd");
        OperatorMap.registerMapping(GenerateAttributes.class, "eu.radoop.manipulation.HiveAttributeGenerate");
        OperatorMap.registerMapping(GenerateAttributes.class, "com.rapidminer.operator.features.construction.AttributeConstruction");
        OperatorMap.registerMapping(GenerateAttributes.class, "com.rapidminer.extension.blending.attributes.generation.GenerateColumns");
        OperatorMap.registerMapping(SelectOperator.class, "com.rapidminer.operator.features.selection.RemoveUselessFeatures");
        OperatorMap.registerMapping(SelectOperator.class, "com.rapidminer.operator.features.selection.RemoveCorrelatedFeatures");
        OperatorMap.registerMapping(SelectOperator.class, "eu.radoop.manipulation.HiveAttributeFilter");
        OperatorMap.registerMapping(SelectOperator.class, "eu.radoop.manipulation.HiveRandomAttributeFilter");
        OperatorMap.registerMapping(SelectOperator.class, "com.rapidminer.operator.preprocessing.filter.attributes.AttributeFilter");
        OperatorMap.registerMapping(SelectOperator.class, "com.rapidminer.extension.blending.operator.attributes.SelectAttributes");
        OperatorMap.registerMapping(FilterOperator.class, "eu.radoop.manipulation.HiveExampleFilter");
        OperatorMap.registerMapping(FilterOperator.class, "com.rapidminer.operator.preprocessing.filter.ExampleFilter");
        OperatorMap.registerMapping(JoinOperator.class, "com.rapidminer.operator.preprocessing.join.ExampleSetCartesian");
        OperatorMap.registerMapping(JoinOperator.class, "eu.radoop.manipulation.HiveJoin");
        OperatorMap.registerMapping(JoinOperator.class, "com.rapidminer.extension.concurrency.operator.preprocessing.join.BeltTableJoin");
        OperatorMap.registerMapping(UnionOperator.class, "com.rapidminer.operator.preprocessing.join.ExampleSetMerge");
        OperatorMap.registerMapping(UnionOperator.class, "eu.radoop.manipulation.HiveUnion");
        OperatorMap.registerMapping(UnionOperator.class, "com.rapidminer.operator.preprocessing.join.ExampleSetUnion");
        OperatorMap.registerMapping(DistinctOperator.class, "eu.radoop.manipulation.HiveRemoveDuplicates");
        OperatorMap.registerMapping(DistinctOperator.class, "com.rapidminer.operator.preprocessing.filter.RemoveDuplicates");
        OperatorMap.registerMapping(SortOperator.class, "com.rapidminer.operator.indatabase.SortAttributeFilter");
        OperatorMap.registerMapping(SortOperator.class, "com.rapidminer.operator.preprocessing.filter.NonDominatedSorting");
        OperatorMap.registerMapping(SortOperator.class, "com.rapidminer.operator.preprocessing.filter.PermutationOperator");
        OperatorMap.registerMapping(SortOperator.class, "eu.radoop.manipulation.HiveSort");
        OperatorMap.registerMapping(SortOperator.class, "com.rapidminer.operator.preprocessing.filter.Sorting");
        OperatorMap.registerMapping(SortOperator.class, "com.rapidminer.extension.blending.operator.examples.sort.MultiSorting");
        OperatorMap.registerMapping(RenameOperator.class, "eu.radoop.manipulation.HiveAttributeRename");
        OperatorMap.registerMapping(RenameOperator.class, "com.rapidminer.operator.preprocessing.filter.ChangeAttributeName");
        OperatorMap.registerMapping(RenameOperator.class, "com.rapidminer.extension.blending.attributes.rename.Rename");
        OperatorMap.registerMapping(RenameByReplacing.class, "eu.radoop.manipulation.HiveAttributeRenameReplace");
        OperatorMap.registerMapping(RenameByReplacing.class, "com.rapidminer.operator.preprocessing.filter.ChangeAttributeNamesReplace");
        OperatorMap.registerMapping(ReplaceMissing.class, "eu.radoop.manipulation.HiveReplaceMissing");
        OperatorMap.registerMapping(ReplaceMissing.class, "com.rapidminer.operator.preprocessing.filter.MissingValueReplenishment");
        OperatorMap.registerMapping(DeclareMissing.class, "eu.radoop.manipulation.HiveDeclareMissing");
        OperatorMap.registerMapping(DeclareMissing.class, "com.rapidminer.operator.preprocessing.filter.DeclareMissingValueOperator");
        OperatorMap.registerMapping(ReplaceValue.class, "eu.radoop.manipulation.HiveReplace");
        OperatorMap.registerMapping(ReplaceValue.class, "com.rapidminer.operator.preprocessing.filter.AttributeValueReplace");
        OperatorMap.registerMapping(Multiply.class, "eu.radoop.operator.RadoopIOMultiplier");
        OperatorMap.registerMapping(Multiply.class, "com.rapidminer.operator.IOMultiplier");
        OperatorMap.registerMapping(CustomSqlOperator.class, "eu.radoop.manipulation.HiveScript");
        OperatorMap.registerMapping(CustomSqlOperator.class, "com.rapidminer.extension.jdbc.operator.SQLExecution");
        OperatorMap.registerMapping(Subprocess.class, "eu.radoop.operator.meta.RadoopSimpleOperatorChain");
        OperatorMap.registerMapping(Subprocess.class, "com.rapidminer.operator.SimpleOperatorChain");
        OperatorMap.registerMapping(AttributeOrdering.class, "eu.radoop.operator.HiveAttributeOrdering");
        OperatorMap.registerMapping(AttributeOrdering.class, "com.rapidminer.operator.preprocessing.filter.attributes.AttributeOrderingOperator");
        OperatorMap.registerMapping(GenerateRank.class, "eu.radoop.operator.HiveRankGenerate");
        OperatorMap.registerMapping(GenerateRank.class, "com.rapidminer.operator.preprocessing.IdTagging");
        OperatorMap.registerMapping(GenerateRank.class, "com.rapidminer.extension.blending.attributes.generation.GenerateID");
    }
}

