/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase;

import com.rapidminer.RapidMiner;
import com.rapidminer.extension.indatabase.gui.DbExpressionValueCellEditor;
import com.rapidminer.extension.indatabase.gui.ListWithButtonValueCellEditor;
import com.rapidminer.extension.indatabase.gui.ParameterTypeDbExpression;
import com.rapidminer.extension.indatabase.gui.ParameterTypeListWithAction;
import com.rapidminer.extension.indatabase.provider.DatabaseProviderFactory;
import com.rapidminer.extension.indatabase.provider.bigquery.GoogleBigQueryProvider;
import com.rapidminer.extension.indatabase.provider.databricks.DatabricksProvider;
import com.rapidminer.extension.indatabase.provider.embedded.EmbeddedProvider;
import com.rapidminer.extension.indatabase.provider.impala.ImpalaProvider;
import com.rapidminer.extension.indatabase.provider.mssql.MSSQLProvider;
import com.rapidminer.extension.indatabase.provider.mysql.MySQLProvider;
import com.rapidminer.extension.indatabase.provider.oracle.OracleProvider;
import com.rapidminer.extension.indatabase.provider.other.GenericProvider;
import com.rapidminer.extension.indatabase.provider.postgresql.PostgreSQLProvider;
import com.rapidminer.extension.indatabase.provider.snowflake.SnowflakeProvider;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseService;
import com.rapidminer.extension.jdbc.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.properties.PropertyPanel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.ParameterService;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class PluginInitInDatabaseProcessing {
    public static final String PROPERTY_BREAKPOINT_SAMPLE_SIZE = "rapidminer.in_database_processing.sample_size.breakpoint";
    private static final int DEFAULT_BREAKPOINT_SAMPLE_SIZE = 10000;
    private static final Level DEFAULT_LEVEL = Level.INFO;
    public static final String PROPERTY_LOG_LEVEL = "rapidminer.in_database_processing.loglevel";
    private static final Level[] SELECTABLE_LEVELS = new Level[]{Level.OFF, Level.FINEST, Level.FINER, Level.FINE, Level.INFO};
    private static final int INDEX_LOG_LEVEL_INFO = 4;
    protected static final String[] SELECTABLE_LEVEL_NAMES = (String[])Arrays.stream(SELECTABLE_LEVELS).map(Level::getName).toArray(String[]::new);

    private PluginInitInDatabaseProcessing() {
    }

    public static void initPlugin() {
        DatabaseService.init();
        DatabaseConnectionService.init();
        GoogleBigQueryProvider.INSTANCE.getClass();
        MySQLProvider.INSTANCE.getClass();
        PostgreSQLProvider.INSTANCE.getClass();
        MSSQLProvider.INSTANCE.getClass();
        OracleProvider.INSTANCE.getClass();
        DatabricksProvider.INSTANCE.getClass();
        SnowflakeProvider.INSTANCE.getClass();
        EmbeddedProvider.INSTANCE.getClass();
        GenericProvider.INSTANCE.getClass();
        ImpalaProvider.INSTANCE.getClass();
        if (!RapidMiner.getExecutionMode().isHeadless()) {
            for (String id : DatabaseProviderFactory.getOrderedProviderIdList()) {
                try {
                    I18N.registerGUIBundle((ResourceBundle)ResourceBundle.getBundle(String.format("com.rapidminer.extension.resources.i18n.db_%s_GUIInDatabaseProcessing", id), Locale.getDefault(), PluginInitInDatabaseProcessing.class.getClassLoader()));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        ParameterService.registerParameter((ParameterType)new ParameterTypeInt(PROPERTY_BREAKPOINT_SAMPLE_SIZE, "", 0, Integer.MAX_VALUE, 10000));
        ParameterService.registerParameter((ParameterType)new ParameterTypeCategory(PROPERTY_LOG_LEVEL, "", SELECTABLE_LEVEL_NAMES, 4));
    }

    public static void initGui(MainFrame mainframe) {
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeDbExpression.class, DbExpressionValueCellEditor.class);
        PropertyPanel.registerPropertyValueCellEditor(ParameterTypeListWithAction.class, ListWithButtonValueCellEditor.class);
    }

    public static void initFinalChecks() {
    }

    public static void initPluginManager() {
    }

    public static int getBreakpointSampleSize() {
        int sampleSize = 10000;
        String sampleSizeText = ParameterService.getParameterValue((String)PROPERTY_BREAKPOINT_SAMPLE_SIZE);
        if (sampleSizeText != null) {
            try {
                sampleSize = Integer.parseInt(sampleSizeText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return sampleSize;
    }

    public static Level getLogLevel() {
        Level level = DEFAULT_LEVEL;
        String levelS = ParameterService.getParameterValue((String)PROPERTY_LOG_LEVEL);
        if (levelS != null) {
            try {
                level = Level.parse(levelS);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }
}

