/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.data;

import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.utils.ExampleSets;
import com.rapidminer.extension.indatabase.DbTools;
import com.rapidminer.extension.indatabase.PluginInitInDatabaseProcessing;
import com.rapidminer.extension.indatabase.data.ExecutionResultWithErrors;
import com.rapidminer.extension.indatabase.data.OverwriteMode;
import com.rapidminer.extension.indatabase.data.SampleDbTableExampleSet;
import com.rapidminer.extension.indatabase.db.object.Table;
import com.rapidminer.extension.indatabase.db.step.AbsoluteSample;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.db.step.GeneratedDbStep;
import com.rapidminer.extension.indatabase.db.step.Sample;
import com.rapidminer.extension.indatabase.operator.Nest;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.provider.IndbResultSet;
import com.rapidminer.extension.indatabase.provider.QueryRunner;
import com.rapidminer.extension.indatabase.provider.storage.CreateTableOptions;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class DbTableExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 8096403858173590210L;
    public static final String DB_WARNINGS = "DB Warnings";
    private final GeneratedDbStep dbStep;
    private final Attributes attributes;

    public DbTableExampleSet(DatabaseProvider provider, DbStep step) {
        this(provider, step, (Attributes)new SimpleAttributes());
        step.getColumns(provider).forEach(c -> this.attributes.addRegular(AttributeFactory.createAttribute((String)c.getDestCol(), (int)DatabaseHandler.getRapidMinerTypeIndex((int)c.getType()))));
    }

    public DbTableExampleSet(DatabaseProvider provider, DbStep step, Attributes attrs) {
        this.dbStep = GeneratedDbStep.of(provider, step);
        this.attributes = attrs;
    }

    public int size() {
        return 0;
    }

    public ExampleTable getExampleTable() {
        ArrayList attrs = new ArrayList();
        this.attributes.allAttributes().forEachRemaining(attrs::add);
        return ExampleSets.createTableFrom(attrs);
    }

    public Example getExample(int index) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + "#getExample()");
    }

    public Iterator<Example> iterator() {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getSimpleName() + "#iterator()");
    }

    public SampleDbTableExampleSet exploreTable(Nest nest) throws OperatorException {
        SampleDbTableExampleSet res;
        int size = PluginInitInDatabaseProcessing.getBreakpointSampleSize();
        DbStep step = this.dbStep;
        if (size > 0) {
            step = Sample.builder().from(step).limit(size).offset(0L).build();
        }
        DatabaseProvider provider = nest.getProvider();
        String sql = step.toSql(provider);
        try {
            ExecutionResultWithErrors resultWithErrors = this.execute(nest, sql);
            ExampleTable exampleTable = resultWithErrors.getExampleSetBuilder().build().getExampleTable();
            res = new SampleDbTableExampleSet(provider, (DbStep)this.dbStep, exampleTable);
            res.getAnnotations().setAnnotation("Source", sql);
            if (!resultWithErrors.getErrors().isEmpty()) {
                res.getAnnotations().setAnnotation(DB_WARNINGS, String.join((CharSequence)"\n", resultWithErrors.getErrors()));
            }
        }
        catch (SQLException e) {
            throw new UserError((Operator)nest, "sql_error", new Object[]{DbTools.formatErrorMessage(e)});
        }
        return res;
    }

    public ExampleSet materialize(Nest nest) throws SQLException, OperatorException {
        ExecutionResultWithErrors resultWithErrors;
        ExampleSet result;
        DatabaseProvider provider = nest.getProvider();
        String sql = this.dbStep.toSql(provider);
        if (!nest.getParameter("limit_sample_size").isEmpty()) {
            sql = AbsoluteSample.builder().from(this.dbStep).limit(Integer.valueOf(nest.getParameter("limit_sample_size")).intValue()).build().toSql(provider);
        }
        if ((result = (resultWithErrors = this.execute(nest, sql)).getExampleSetBuilder().build()) != null) {
            result.getAnnotations().setAnnotation("Source", sql);
            if (!resultWithErrors.getErrors().isEmpty()) {
                result.getAnnotations().setAnnotation(DB_WARNINGS, String.join((CharSequence)"\n", resultWithErrors.getErrors()));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ExecutionResultWithErrors execute(Nest nest, String sql) throws SQLException, OperatorException {
        try {
            DatabaseProvider provider = nest.getProvider();
            try (QueryRunner queryRunner = provider.createQueryRunner(nest.getDbHandler());){
                ExecutionResultWithErrors executionResultWithErrors;
                block14: {
                    IndbResultSet rs = queryRunner.executeQuery(sql);
                    try {
                        rs.getErrors().forEach(LogService.getRoot()::warning);
                        executionResultWithErrors = new ExecutionResultWithErrors(rs.createExampleTable((Operator)nest), rs.getErrors());
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return executionResultWithErrors;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void materializeAs(Nest nest, Table table, OverwriteMode mode) throws SQLException, OperatorException {
        this.materializeAs(nest, table, mode, CreateTableOptions.DEFAULT);
    }

    public void materializeAs(Nest nest, Table table, OverwriteMode mode, CreateTableOptions options) throws SQLException, OperatorException {
        Objects.requireNonNull(table.getTable());
        DatabaseProvider provider = nest.getProvider();
        try (QueryRunner queryRunner = provider.createQueryRunner(nest.getDbHandler());){
            String ctasSql = this.getSql(nest, table, mode, options);
            if (mode == OverwriteMode.OVERWRITE) {
                provider.dropIfExists(nest, queryRunner, table);
            }
            queryRunner.execute(ctasSql);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ProcessStoppedException((Operator)nest);
        }
    }

    private String getSql(Nest nest, Table table, OverwriteMode mode, CreateTableOptions options) throws OperatorException {
        DatabaseProvider provider = nest.getProvider();
        if (mode == OverwriteMode.APPEND) {
            return provider.insertIntoTableSql(table, this.dbStep);
        }
        return provider.generateCreateTableSql(table, this.dbStep, options);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getAttributes().hashCode();
        result = 31 * result + (this.dbStep == null ? 0 : this.dbStep.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DbTableExampleSet other = (DbTableExampleSet)((Object)obj);
        if (!this.getAttributes().equals((Object)other.getAttributes())) {
            return false;
        }
        return !(this.dbStep == null ? other.dbStep != null : !this.dbStep.equals(other.dbStep));
    }

    public GeneratedDbStep getDbStep() {
        return this.dbStep;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }
}

