/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.data;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.set.SimpleExampleReader;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.extension.indatabase.data.DbTableExampleSet;
import com.rapidminer.extension.indatabase.db.step.DbStep;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import java.util.Iterator;
import java.util.Objects;

public class SampleDbTableExampleSet
extends DbTableExampleSet {
    private static final long serialVersionUID = 3062127684388774544L;
    private final ExampleTable exampleTable;

    public SampleDbTableExampleSet(DatabaseProvider provider, DbStep step, ExampleTable exampleTable) {
        super(provider, step, (Attributes)new SimpleAttributes());
        this.exampleTable = exampleTable;
        int i = 0;
        for (Attribute attr : exampleTable.getAttributes()) {
            attr.setTableIndex(i++);
            super.getAttributes().addRegular(attr);
        }
    }

    @Override
    public int size() {
        return this.exampleTable.size();
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    @Override
    public Example getExample(int index) {
        DataRow dataRow = this.exampleTable.getDataRow(index);
        if (dataRow == null) {
            return null;
        }
        return new Example(dataRow, (ExampleSet)this);
    }

    @Override
    public Iterator<Example> iterator() {
        return new SimpleExampleReader(this.exampleTable.getDataRowReader(), (ExampleSet)this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.exampleTable);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SampleDbTableExampleSet other = (SampleDbTableExampleSet)((Object)obj);
        return Objects.equals(this.exampleTable, other.exampleTable);
    }
}

