/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db;

import com.google.cloud.bigquery.BigQuery;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.example.Attribute;
import com.rapidminer.extension.cloud.connectivity.operator.google.GoogleServiceConnection;
import com.rapidminer.extension.cloud.connectivity.operator.google.bigquery.GoogleBigQueryClient;
import com.rapidminer.extension.cloud.connectivity.operator.google.bigquery.GoogleBigQueryService;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.LogService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class CachedConnectionProvider {
    final ConnectionInformation dbInformation;
    final BigQuery bigQuery;
    final DatabaseProvider provider;
    final AtomicReference<List<String>> projectList = new AtomicReference();
    final Map<String, AtomicReference<List<String>>> schemaPerProject = new HashMap<String, AtomicReference<List<String>>>();
    final Map<String, AtomicReference<List<String>>> tablesPerSchema = new HashMap<String, AtomicReference<List<String>>>();
    final Map<String, AtomicReference<List<Attribute>>> columnsPerTable = new HashMap<String, AtomicReference<List<Attribute>>>();
    private static final Map<Integer, CachedConnectionProvider> handlerMap = new HashMap<Integer, CachedConnectionProvider>();
    final Object CACHE_LOCK = new Object();
    private static final int HASH_MULTIPLIER = 7;
    private static final int HASH_JDBC_OFFSET = 1;
    private static final int HASH_BIGQUERY_OFFSET = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedConnectionProvider getOrCreateJDBCConnection(ConnectionInformation connectionInformation, DatabaseProvider provider) {
        String dialect = provider.getId();
        Integer key = CachedConnectionProvider.getHashValue(CachedConnectionProvider.getHashForConnectionInformation(connectionInformation), provider, 1);
        String string = key.toString().intern();
        synchronized (string) {
            if (!handlerMap.containsKey(key)) {
                LogService.getRoot().fine(() -> String.format("Initializing new cached database handler for %s with dialect %s", connectionInformation.getConfiguration().getName(), dialect));
                CachedConnectionProvider cachedDbHandler = new CachedConnectionProvider(connectionInformation, provider);
                handlerMap.put(key, cachedDbHandler);
                LogService.getRoot().fine(() -> String.format("Created new cached database handler for %s with dialect %s", connectionInformation.getConfiguration().getName(), dialect));
            }
            return handlerMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CachedConnectionProvider getOrCreateBigQueryConnection(GoogleServiceConnection bigQueryConnection, DatabaseProvider provider) throws UserError {
        String dialect = provider.getId();
        Integer key = CachedConnectionProvider.getHashValue(CachedConnectionProvider.getHashForGoogleServiceConnection(bigQueryConnection), provider, 4);
        String string = key.toString().intern();
        synchronized (string) {
            if (!handlerMap.containsKey(key)) {
                LogService.getRoot().fine(() -> String.format("Initializing new cached database handler for %s with dialect %s", bigQueryConnection.getName(), dialect));
                CachedConnectionProvider cachedDbHandler = new CachedConnectionProvider(bigQueryConnection, provider);
                handlerMap.put(key, cachedDbHandler);
                LogService.getRoot().fine(() -> String.format("Created new cached database handler for %s with dialect %s", bigQueryConnection.getName(), dialect));
            }
            return handlerMap.get(key);
        }
    }

    private static Integer getHashValue(int entryHash, DatabaseProvider provider, int hashOffset) {
        return (entryHash + provider.getId().hashCode()) * 7 + hashOffset;
    }

    private static int getHashForConnectionInformation(ConnectionInformation info) {
        return Objects.hash(info.getConfiguration().getAllParameterKeys().stream().sorted().map(key -> info.getConfiguration().getValue(key)).reduce((s1, s2) -> s1 + s2), info.getConfiguration().getType(), info.getConfiguration().getId(), info.getConfiguration().getName());
    }

    private static int getHashForGoogleServiceConnection(GoogleServiceConnection connection) {
        return Objects.hash(connection.getParameters().keySet().stream().filter(k -> !k.equals("ID")).sorted().map(k -> k + "=" + connection.getParameter(k)).toArray());
    }

    private CachedConnectionProvider(ConnectionInformation dbInformation, DatabaseProvider prov) {
        this.dbInformation = dbInformation;
        this.bigQuery = null;
        this.provider = prov;
    }

    private CachedConnectionProvider(GoogleServiceConnection bigQueryConnection, DatabaseProvider prov) throws UserError {
        this.dbInformation = null;
        GoogleBigQueryClient client = (GoogleBigQueryClient)GoogleBigQueryService.INSTANCE.createClient(bigQueryConnection, GoogleBigQueryClient.class);
        this.bigQuery = client.createConnection();
        this.provider = prov;
    }
}

