/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db;

import com.google.cloud.bigquery.BigQuery;
import com.rapidminer.connection.ConnectionInformation;
import com.rapidminer.connection.adapter.ConnectionAdapterHandler;
import com.rapidminer.example.Attribute;
import com.rapidminer.extension.cloud.connectivity.operator.google.GoogleServiceConnection;
import com.rapidminer.extension.indatabase.db.CachedConnectionProvider;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.jdbc.connection.JDBCConnectionHandler;
import com.rapidminer.extension.jdbc.tools.jdbc.DatabaseHandler;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.tools.config.ConfigurationException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class CachedDatabaseHandler {
    private final CachedConnectionProvider cachedConnectionProvider;
    private final Operator operator;

    public boolean isDatabaseConnection() {
        return this.cachedConnectionProvider.dbInformation != null;
    }

    public static CachedDatabaseHandler getOrCreate(ConnectionInformation connectionInformation, Operator operator, DatabaseProvider provider) throws UserError, ConfigurationException {
        CachedConnectionProvider cachedConnectionProvider = connectionInformation.getConfiguration().getType().equals(JDBCConnectionHandler.INSTANCE.getType()) ? CachedConnectionProvider.getOrCreateJDBCConnection(connectionInformation, provider) : CachedConnectionProvider.getOrCreateBigQueryConnection((GoogleServiceConnection)ConnectionAdapterHandler.getHandler((String)"google-cloud-storage").getAdapter(connectionInformation, operator), provider);
        return new CachedDatabaseHandler(operator, cachedConnectionProvider);
    }

    private CachedDatabaseHandler(Operator operator, CachedConnectionProvider cachedConnectionProvider) {
        this.operator = operator;
        this.cachedConnectionProvider = cachedConnectionProvider;
    }

    public BigQuery getBigQuery() {
        if (this.cachedConnectionProvider.bigQuery == null) {
            throw new IllegalStateException("This is not a BigQuery connection.");
        }
        return this.cachedConnectionProvider.bigQuery;
    }

    public DatabaseProvider getProvider() {
        return this.cachedConnectionProvider.provider;
    }

    public boolean schemaExists(String schema, boolean force) throws SQLException, OperatorException {
        return this.getSchemaNames(force).stream().anyMatch(schema::equalsIgnoreCase);
    }

    public boolean schemaExists(String project, String schema, boolean force) throws SQLException, OperatorException {
        return this.getSchemaNames(project, force).stream().anyMatch(schema::equalsIgnoreCase);
    }

    public boolean tableExists(String schema, String table, boolean force) throws SQLException, OperatorException {
        return this.getTableNames(schema, force).stream().anyMatch(table::equalsIgnoreCase);
    }

    public boolean tableExists(String project, String schema, String table, boolean force) throws SQLException, OperatorException {
        return this.getTableNames(project, schema, force).stream().anyMatch(table::equalsIgnoreCase);
    }

    public List<String> getProjectNames(boolean force) throws SQLException, OperatorException {
        return this.refreshCache(this.cachedConnectionProvider.projectList, this.cachedConnectionProvider.provider::getProjectNames, force);
    }

    public List<String> getSchemaNames(boolean force) throws SQLException, OperatorException {
        this.cachedConnectionProvider.schemaPerProject.computeIfAbsent("", k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.schemaPerProject.get(""), this.cachedConnectionProvider.provider::getSchemaNames, force);
    }

    public List<String> getSchemaNames(String project, boolean force) throws SQLException, OperatorException {
        this.cachedConnectionProvider.schemaPerProject.computeIfAbsent(project, k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.schemaPerProject.get(project), dbHandler -> this.cachedConnectionProvider.provider.getSchemaNames(dbHandler, project), force);
    }

    public List<String> getTableNames(String schemaName, boolean force) throws SQLException, OperatorException {
        String key = CachedDatabaseHandler.asProjectAndSchemaString("", schemaName);
        this.cachedConnectionProvider.tablesPerSchema.computeIfAbsent(key, k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.tablesPerSchema.get(key), dbHandler -> this.cachedConnectionProvider.provider.getTableNames(dbHandler, schemaName), force);
    }

    public List<String> getTableNames(String projectName, String schemaName, boolean force) throws SQLException, OperatorException {
        String key = CachedDatabaseHandler.asProjectAndSchemaString(projectName, schemaName);
        this.cachedConnectionProvider.tablesPerSchema.computeIfAbsent(key, k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.tablesPerSchema.get(key), dbHandler -> this.cachedConnectionProvider.provider.getTableNames(dbHandler, projectName, schemaName), force);
    }

    public List<Attribute> getColumnMetaData(String schemaName, String tableName, boolean force) throws SQLException, OperatorException {
        String key = CachedDatabaseHandler.asSchemaAndTableString("", schemaName, tableName);
        this.cachedConnectionProvider.columnsPerTable.computeIfAbsent(key, k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.columnsPerTable.get(key), dbHandler -> this.cachedConnectionProvider.provider.getColumnMetaData(dbHandler, schemaName, tableName), force);
    }

    public List<Attribute> getColumnMetaData(String projectName, String schemaName, String tableName, boolean force) throws SQLException, OperatorException {
        String key = CachedDatabaseHandler.asSchemaAndTableString(projectName, schemaName, tableName);
        this.cachedConnectionProvider.columnsPerTable.computeIfAbsent(key, k -> new AtomicReference());
        return this.refreshCache(this.cachedConnectionProvider.columnsPerTable.get(key), dbHandler -> this.cachedConnectionProvider.provider.getColumnMetaData(dbHandler, projectName, schemaName, tableName), force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> refreshCache(AtomicReference<List<T>> cacheRef, SupplierThrowingSQLException<List<T>> supplierFunc, boolean force) throws SQLException, OperatorException {
        Objects.requireNonNull(cacheRef);
        List<T> cache = cacheRef.get();
        if (cache != null && !force) {
            return cache;
        }
        Object object = this.cachedConnectionProvider.CACHE_LOCK;
        synchronized (object) {
            cache = cacheRef.get();
            if (cache != null && !force) {
                return cache;
            }
            List<T> result = supplierFunc.get(this);
            cacheRef.set(result);
            return result;
        }
    }

    private static String asProjectAndSchemaString(String project, String schema) {
        return String.format("'%s'.'%s'", project, schema);
    }

    private static String asSchemaAndTableString(String project, String schema, String table) {
        return String.format("'%s'.'%s'.'%s'", project, schema, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Object object = this.cachedConnectionProvider.CACHE_LOCK;
        synchronized (object) {
            this.cachedConnectionProvider.projectList.set(null);
            this.cachedConnectionProvider.schemaPerProject.clear();
            this.cachedConnectionProvider.tablesPerSchema.clear();
            this.cachedConnectionProvider.columnsPerTable.clear();
        }
    }

    public DatabaseHandler getConnectedDatabaseHandler() throws SQLException {
        if (this.isDatabaseConnection()) {
            return DatabaseHandler.getConnectedDatabaseHandler((Operator)this.operator, (ConnectionInformation)this.cachedConnectionProvider.dbInformation);
        }
        throw new UnsupportedOperationException("This is a Google Cloud Services connection, no database handler is available.");
    }

    public Operator getOperator() {
        return this.operator;
    }

    private static interface SupplierThrowingSQLException<T> {
        public T get(CachedDatabaseHandler var1) throws SQLException, OperatorException;
    }
}

