/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.extension.indatabase.db.object;

import com.rapidminer.extension.indatabase.db.object.Column;
import com.rapidminer.extension.indatabase.db.step.Sort;
import com.rapidminer.extension.indatabase.provider.DatabaseProvider;
import com.rapidminer.extension.indatabase.sql.SortAnsiSql;
import java.util.List;
import java.util.stream.Collectors;

public final class AnalyticFunctionExpr
extends Column {
    private static final long serialVersionUID = 7373431478765824194L;
    private final String function;
    private final List<Column> partitionBy;
    private final List<Sort.SortColumn> sortBy;

    @Override
    public String toSql(DatabaseProvider provider) {
        String partitionByStr = this.partitionBy.stream().map(c -> c.toSql(provider)).collect(Collectors.joining(", "));
        String sortByStr = SortAnsiSql.buildOrderByExpression(provider, this.sortBy);
        return String.format("%s() OVER (%s %s) %s", this.function, this.partitionBy.isEmpty() ? "" : String.format("PARTITION BY %s", partitionByStr), this.sortBy.isEmpty() ? "" : String.format("ORDER BY %s", sortByStr), super.toSql(provider));
    }

    protected AnalyticFunctionExpr(AnalyticFunctionExprBuilder<?, ?> b) {
        super(b);
        this.function = b.function;
        this.partitionBy = b.partitionBy;
        this.sortBy = b.sortBy;
    }

    public static AnalyticFunctionExprBuilder<?, ?> builder() {
        return new AnalyticFunctionExprBuilderImpl();
    }

    public String getFunction() {
        return this.function;
    }

    public List<Column> getPartitionBy() {
        return this.partitionBy;
    }

    public List<Sort.SortColumn> getSortBy() {
        return this.sortBy;
    }

    @Override
    public String toString() {
        return "AnalyticFunctionExpr(function=" + this.getFunction() + ", partitionBy=" + String.valueOf(this.getPartitionBy()) + ", sortBy=" + String.valueOf(this.getSortBy()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyticFunctionExpr)) {
            return false;
        }
        AnalyticFunctionExpr other = (AnalyticFunctionExpr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$function = this.getFunction();
        String other$function = other.getFunction();
        if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
            return false;
        }
        List<Column> this$partitionBy = this.getPartitionBy();
        List<Column> other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !((Object)this$partitionBy).equals(other$partitionBy)) {
            return false;
        }
        List<Sort.SortColumn> this$sortBy = this.getSortBy();
        List<Sort.SortColumn> other$sortBy = other.getSortBy();
        return !(this$sortBy == null ? other$sortBy != null : !((Object)this$sortBy).equals(other$sortBy));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnalyticFunctionExpr;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        List<Column> $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : ((Object)$partitionBy).hashCode());
        List<Sort.SortColumn> $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)$sortBy).hashCode());
        return result;
    }

    public static abstract class AnalyticFunctionExprBuilder<C extends AnalyticFunctionExpr, B extends AnalyticFunctionExprBuilder<C, B>>
    extends Column.ColumnBuilder<C, B> {
        private String function;
        private List<Column> partitionBy;
        private List<Sort.SortColumn> sortBy;

        public B function(String function) {
            this.function = function;
            return (B)this.self();
        }

        public B partitionBy(List<Column> partitionBy) {
            this.partitionBy = partitionBy;
            return (B)this.self();
        }

        public B sortBy(List<Sort.SortColumn> sortBy) {
            this.sortBy = sortBy;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AnalyticFunctionExpr.AnalyticFunctionExprBuilder(super=" + super.toString() + ", function=" + this.function + ", partitionBy=" + String.valueOf(this.partitionBy) + ", sortBy=" + String.valueOf(this.sortBy) + ")";
        }
    }

    private static final class AnalyticFunctionExprBuilderImpl
    extends AnalyticFunctionExprBuilder<AnalyticFunctionExpr, AnalyticFunctionExprBuilderImpl> {
        private AnalyticFunctionExprBuilderImpl() {
        }

        @Override
        protected AnalyticFunctionExprBuilderImpl self() {
            return this;
        }

        @Override
        public AnalyticFunctionExpr build() {
            return new AnalyticFunctionExpr(this);
        }
    }
}

